/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.drawables;

import java.awt.Color;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.actions.ExpandCollapseAction;
import nl.rug.syntree.hierarchicalmodel.actions.PendleAction;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.hierarchicalmodel.nodecontent.DocumentContent;
import nl.rug.syntree.mainview.components.ActionGroup;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.DrawableDocument;
import org.w3c.dom.Element;

public class DrawableNode
extends DrawableDocument {
    private HierarchicalNode node;
    protected Element animElm;
    protected Element animCircle;

    public DrawableNode(TreeView tv, HierarchicalNode node) {
        super(tv, node.getContent());
        Position p = (Position)node.getTweakByType(Position.class);
        if (p == null) {
            p = new Position(null, node, 0.0f, 0.0f);
            node.addTweak(p);
        }
        this.pos = p;
        super.grabTweaks();
        this.fixed = true;
        this.node = node;
    }

    private boolean updateAsGhost() {
        float radius = Math.min(this.cachedWidth, this.cachedHeight) / 2.0f;
        this.animCircle.setAttributeNS(null, "r", "" + radius);
        this.animElm.setAttributeNS(null, "values", (double)radius * 0.6 + ";" + (double)radius * 1.0 + ";" + (double)radius * 0.6);
        if (this.animCircle.getParentNode() == null) {
            this.group.insertBefore(this.animCircle, this.flowRoot);
        }
        return true;
    }

    @Override
    protected void doAnchorPoints(boolean ad) {
    }

    @Override
    protected Color getColour() {
        return super.getColour("tv-node-bg-colour");
    }

    @Override
    public void draw() {
        super.makeBG();
        super.makeGroup();
        this.group.setAttributeNS("http://let.webhosting.rug.nl/incpar/", "syntree:node", "" + this.getId());
        this.group.setAttributeNS(null, "fill", TreeView.colourToHTML((Color)this.tv.getSetting("tv-node-bg-colour")));
        super.appendGroup();
        super.appendToGroup(this.bg);
        super.makeFlowRoot();
        this.animCircle = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "circle");
        this.animCircle.setAttributeNS(null, "fill", "" + TreeView.colourToHTML((Color)this.tv.getSetting("tv-ghost-bg-colour")));
        this.animCircle.setAttributeNS(null, "cx", "0");
        this.animCircle.setAttributeNS(null, "cy", "0");
        this.animElm = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "animate");
        this.animElm.setAttributeNS(null, "attributeName", "r");
        this.animElm.setAttributeNS(null, "dur", "1s");
        this.animElm.setAttributeNS(null, "repeatCount", "indefinite");
        this.animCircle.appendChild(this.animElm);
        if (((HierarchicalNode)this.that()).pendle()) {
            this.updateAsGhost();
        }
    }

    @Override
    public ActionGroup getActions() {
        ActionGroup ret = super.getActions();
        ret.removeAction(this.tv.getControl().getAnchorizeAction());
        ret.add(this.title(), this.tv.getControl().getHideAction());
        ret.add(this.title(), this.tv.getControl().getMoveNodeAction());
        ret.add(this.title(), this.tv.getController().getAction(PendleAction.class));
        ret.add(this.title(), this.tv.getControl().getResetPositionAction());
        ret.add(this.title(), this.tv.getController().getAction(ExpandCollapseAction.class));
        return ret;
    }

    @Override
    public int getId() {
        return this.node.getId();
    }

    @Override
    public String getIDPrefix() {
        return "node";
    }

    @Override
    public HierarchicalObject that() {
        return this.node;
    }

    @Override
    public String title() {
        return "Node";
    }

    @Override
    public boolean update(Object obj) {
        if (obj instanceof DocumentContent) {
            return super.update(obj);
        }
        if (!(obj instanceof HierarchicalNode)) {
            return false;
        }
        this.node = (HierarchicalNode)obj;
        if (((HierarchicalNode)this.that()).pendle()) {
            this.updateAsGhost();
        } else if (this.animCircle != null && this.animCircle.getParentNode() != null) {
            this.animCircle.getParentNode().removeChild(this.animCircle);
        }
        return super.update(this.node.getContent());
    }
}

