/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.drawables;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Hidden;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.hierarchicalmodel.annotations.Style;
import nl.rug.syntree.mainview.components.ActionGroup;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.PosDrawable;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public abstract class DrawableObject {
    protected transient TreeView tv;
    protected transient Element group;
    protected transient Vector<PosDrawable> drawnAnchorPoints = new Vector();
    protected Position anchorPoints;
    protected Position pos;
    protected Style style;
    protected HierarchicalModel model;
    protected int id;
    protected boolean fixed = false;
    protected boolean amDrawn = false;
    private EventListener defaultListen = null;
    private boolean listenDefault = false;

    public DrawableObject(TreeView tv) {
        this.id = tv.getModel().getID();
        this.model = tv.getModel();
        this.tv = tv;
        this.defaultListen = new EventListener(){

            @Override
            public void handleEvent(Event evt) {
                switch (evt.getType()) {
                    case "mouseover": {
                        DrawableObject.this.onMouseOver((DOMMouseEvent)evt);
                        break;
                    }
                    case "mouseout": {
                        DrawableObject.this.onMouseOut((DOMMouseEvent)evt);
                    }
                }
                if (DrawableObject.this.tv.haltClick()) {
                    return;
                }
                switch (evt.getType()) {
                    case "mouseup": {
                        DrawableObject.this.onMouseUp((DOMMouseEvent)evt);
                        break;
                    }
                    case "mousedown": {
                        DrawableObject.this.onMouseDown((DOMMouseEvent)evt);
                        break;
                    }
                    case "click": {
                        DrawableObject.this.onMouseClick((DOMMouseEvent)evt);
                    }
                }
            }
        };
    }

    private void addAnchorPoint(Position.Pnt pos) {
        PosDrawable anch = new PosDrawable(this.tv, pos, this);
        this.drawnAnchorPoints.add(anch);
        anch.draw();
    }

    private void addListeners(EventListener el) {
        ((SVGOMElement)this.group).addEventListener("mouseup", el, false);
        ((SVGOMElement)this.group).addEventListener("mousedown", el, false);
        ((SVGOMElement)this.group).addEventListener("mouseover", el, false);
        ((SVGOMElement)this.group).addEventListener("mouseout", el, false);
        ((SVGOMElement)this.group).addEventListener("click", el, false);
    }

    private void grabPos() {
        Position thatPos = null;
        if (this.that() == null) {
            if (this.pos == null) {
                this.pos = new Position();
            }
            return;
        }
        thatPos = (Position)this.that().getTweakByType(Position.class);
        if (thatPos == null) {
            if (this.pos == null) {
                this.pos = new Position();
            }
            this.that().addTweak(this.pos);
        } else {
            this.pos = thatPos;
        }
    }

    private void grabStyle() {
        Style thatStyle = null;
        if (this.that() != null) {
            thatStyle = (Style)this.that().getTweakByType(Style.class);
        }
        this.style = thatStyle;
    }

    private void removeListeners(EventListener el) {
        ((SVGOMElement)this.group).removeEventListener("mouseup", el, false);
        ((SVGOMElement)this.group).removeEventListener("mousedown", el, false);
        ((SVGOMElement)this.group).removeEventListener("mouseover", el, false);
        ((SVGOMElement)this.group).removeEventListener("mouseout", el, false);
        ((SVGOMElement)this.group).removeEventListener("click", el, false);
    }

    protected void appendGroup() {
        if (this.group.getParentNode() != null) {
            return;
        }
        this.selectMe(this.amSelected());
        this.tv.annoElm.appendChild(this.group);
        this.addListeners(this.defaultListen);
        this.listenDefault = true;
        this.amDrawn = true;
    }

    protected void appendToGroup(Element elm) {
        if (this.group == null) {
            this.makeGroup();
        }
        this.group.appendChild(elm);
    }

    protected void doAnchorPoints(boolean ad) {
        if (ad) {
            if (this.drawnAnchorPoints.size() > 0) {
                this.removeAnchorPoints();
            }
            if (this.pos != null) {
                for (Position.Pnt p : this.pos) {
                    this.addAnchorPoint(p);
                }
            }
        } else {
            this.removeAnchorPoints();
            this.tv.setSelectedPos(null);
        }
    }

    protected Color getColour(String settingDef) {
        Color clr = this.style != null && this.style.colour != null ? this.style.colour : (Color)this.tv.getSetting(settingDef);
        return clr;
    }

    protected int getThickness() {
        if (this.style == null) {
            this.style = new Style();
            this.that().addTweak(this.style);
        }
        if (this.style.thickness == null) {
            return (Integer)this.tv.getSetting("tv-line-width");
        }
        return this.style.thickness;
    }

    protected void grabTweaks() {
        this.grabPos();
        this.grabStyle();
    }

    protected Element makeGroup() {
        this.group = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "g");
        this.group.setAttributeNS(null, "id", this.getIDPrefix() + "-" + this.getId());
        this.group.setAttributeNS("http://let.webhosting.rug.nl/incpar/", "obj", "" + this.that().getId());
        this.group.setAttributeNS(null, "render-order", "2");
        return this.group;
    }

    protected void removeAnchorPoints() {
        for (PosDrawable anch : this.drawnAnchorPoints) {
            anch.wipe();
        }
        this.drawnAnchorPoints.clear();
    }

    protected void update() {
        this.selectMe(this.amSelected());
    }

    public DrawableObject addPos(Position.Pnt p) {
        this.pos.add(p);
        this.that().validate();
        return this;
    }

    public boolean amSelected() {
        return this.tv.getController().isSelected(this.that());
    }

    private void doSelect(DOMMouseEvent evt, HierarchicalObject obj) {
        if (this.tv.haltSelect()) {
            return;
        }
        HierarchicalController ctrl = this.tv.getController();
        if (evt.getCtrlKey()) {
            if (ctrl.isSelected(obj)) {
                ctrl.deselect(obj);
            } else {
                ctrl.select(obj);
            }
        } else if (ctrl.isSelected(obj) && evt.getButton() != 2) {
            ctrl.selectNone();
        } else if (evt.getButton() == 2) {
            ctrl.select(obj);
        } else {
            ctrl.selectOnly(obj);
        }
        evt.stopPropagation();
    }

    public abstract void draw();

    public ActionGroup getActions() {
        ActionGroup ret = new ActionGroup(this.tv.getControl().getAnchorizeAction());
        return ret;
    }

    public Rectangle2D.Float getBounds() {
        if (this.group == null) {
            return null;
        }
        GraphicsNode node = this.tv.getUpdateManager().getBridgeContext().getGraphicsNode(this.group);
        if (node == null) {
            System.err.println("DrO getBounds, node = null");
            return null;
        }
        Rectangle2D r = node.getGlobalTransform().createTransformedShape(node.getBounds()).getBounds2D();
        Rectangle2D.Float ret = new Rectangle2D.Float((float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight());
        if (!node.isVisible()) {
            System.err.println("DrO not visible, bounds: " + ret);
        }
        if (this.isHidden()) {
            System.out.println("DrO getBounds, hidden");
            ret.width = 0.0f;
            ret.height = 0.0f;
        }
        return ret;
    }

    public Point2D.Float getCenter() {
        if (this.pos != null) {
            return this.pos.center();
        }
        return null;
    }

    public Element getGroupElm() {
        return this.group;
    }

    public int getId() {
        return this.id;
    }

    public abstract String getIDPrefix();

    public HierarchicalModel getModel() {
        return this.model;
    }

    public Position getPos() {
        return this.pos;
    }

    public Style getStyle() {
        return this.style;
    }

    public float getX() {
        return this.pos.centerX();
    }

    public float getY() {
        return this.pos.centerY();
    }

    public boolean inFOV() {
        if (!this.isDrawn()) {
            return false;
        }
        Rectangle2D.Float bgBounds = this.tv.getBackgroundBounds();
        if (bgBounds == null) {
            return false;
        }
        return bgBounds.contains(this.getBounds());
    }

    public boolean isDrawn() {
        return this.amDrawn && this.group != null && this.group.getParentNode() != null;
    }

    public boolean isHidden() {
        return this.that().getTweakByType(Hidden.class) != null;
    }

    public void onMouseClick(DOMMouseEvent evt) {
        this.doSelect(evt, this.that());
    }

    public void onMouseDown(DOMMouseEvent evt) {
    }

    public void onMouseOut(DOMMouseEvent evt) {
    }

    public void onMouseOver(DOMMouseEvent evt) {
    }

    public void onMouseUp(DOMMouseEvent evt) {
    }

    public void replaceEventListeners(EventListener el) {
        if (this.listenDefault) {
            this.removeListeners(this.defaultListen);
            this.listenDefault = false;
        }
        this.addListeners(el);
    }

    public void reposition() {
        if (this.group != null && this.fixed) {
            this.group.setAttributeNS(null, "transform", "translate(" + this.getX() + "," + this.getY() + ")");
        } else {
            this.group.removeAttributeNS(null, "transform");
        }
    }

    public void restoreListeners() {
        if (this.listenDefault) {
            return;
        }
        this.addListeners(this.defaultListen);
        this.listenDefault = true;
    }

    public void selectMe(boolean b) {
        if (this.group == null) {
            return;
        }
        this.doAnchorPoints(b);
        if (b) {
            if (this.group.getParentNode() != null) {
                this.group.getParentNode().appendChild(this.group);
            }
        } else if (this.group.getParentNode() != null) {
            // empty if block
        }
    }

    public DrawableObject setColour(Color clr) {
        if (this.style == null) {
            this.style = new Style();
            this.that().addTweak(this.style);
        }
        this.style.colour = clr;
        return this;
    }

    public DrawableObject setPos(Position pos) {
        this.pos = pos;
        return this;
    }

    public DrawableObject setStyle(Style s) {
        this.style = s;
        return this;
    }

    public DrawableObject setThickness(int thickness) {
        if (this.style == null) {
            this.style = new Style();
            this.that().addTweak(this.style);
        }
        this.style.thickness = thickness;
        return this;
    }

    public abstract HierarchicalObject that();

    public abstract String title();

    public final void translate(float dx, float dy) {
        if (this.group == null) {
            return;
        }
        if (this.fixed) {
            dx += this.getX();
            dy += this.getY();
        }
        this.group.setAttributeNS(null, "transform", "translate(" + dx + "," + dy + ")");
    }

    public abstract boolean update(Object var1);

    public boolean validate() {
        return this.that().validate();
    }

    public void scrollIntoView() {
        if (!this.isDrawn()) {
            return;
        }
        if (this.inFOV()) {
            return;
        }
        Rectangle2D.Float bounds = this.getBounds();
        if (bounds == null) {
            return;
        }
        System.out.println("DrO sIV: " + bounds);
        AffineTransform at = this.tv.getRenderingTransform();
        double x = bounds.getCenterX() * at.getScaleX();
        double y = bounds.getCenterY() * at.getScaleY();
        this.tv.centrate(x, y);
    }

    public void wipe() {
        this.removeAnchorPoints();
        if (this.group != null && this.group.getParentNode() != null) {
            this.group.getParentNode().removeChild(this.group);
        }
        this.amDrawn = false;
    }
}

