/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.drawables;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Strike;
import nl.rug.syntree.mainview.components.ActionGroup;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.DrawableObject;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;

public class DrawableStrike
extends DrawableObject {
    protected Strike strike = null;
    protected Element line1 = null;
    protected Element line1bg = null;
    protected Element line2 = null;
    protected Element line2bg = null;
    protected Element ellipse = null;
    protected Element ellipsebg = null;

    public DrawableStrike(TreeView tv, Strike strike) {
        super(tv);
        this.strike = strike;
        this.pos = strike.pos();
    }

    private void circledLine() {
        this.styleLine(this.line1);
        this.styleBg(this.line1bg);
        this.styleLine(this.ellipse);
        this.styleBg(this.ellipsebg);
        Rectangle2D.Float extent = this.extent();
        float x1 = extent.x;
        float y1 = extent.y + extent.height;
        float x2 = extent.x + extent.width;
        float y2 = extent.y;
        if (this.strike.northSouth()) {
            y1 = extent.y;
            y2 = extent.y + extent.height;
        }
        this.singular(this.line1, this.line1bg, x1, y1, x2, y2);
        this.ellipse.setAttributeNS(null, "cx", "" + extent.getCenterX());
        this.ellipse.setAttributeNS(null, "cy", "" + extent.getCenterY());
        this.ellipsebg.setAttributeNS(null, "cx", "" + extent.getCenterX());
        this.ellipsebg.setAttributeNS(null, "cy", "" + extent.getCenterY());
        float rx = extent.width / 2.0f * (float)Math.sqrt(2.0);
        float ry = extent.height / 2.0f * (float)Math.sqrt(2.0);
        this.ellipse.setAttributeNS(null, "rx", "" + rx);
        this.ellipse.setAttributeNS(null, "ry", "" + ry);
        this.ellipsebg.setAttributeNS(null, "rx", "" + rx);
        this.ellipsebg.setAttributeNS(null, "ry", "" + ry);
    }

    private void cross() {
        this.styleLine(this.line1);
        this.styleBg(this.line1bg);
        this.styleLine(this.line2);
        this.styleBg(this.line2bg);
        Rectangle2D.Float extent = this.extent();
        float x1 = extent.x;
        float y1 = extent.y + extent.height;
        float x2 = extent.x + extent.width;
        float y2 = extent.y;
        this.singular(this.line1, this.line1bg, x1, y1, x2, y2);
        y1 = extent.y;
        y2 = extent.y + extent.height;
        this.singular(this.line2, this.line2bg, x1, y1, x2, y2);
    }

    private void doubleLine() {
        this.styleLine(this.line1);
        this.styleBg(this.line1bg);
        this.styleLine(this.line2);
        this.styleBg(this.line2bg);
        Rectangle2D.Float extent = this.extent();
        float dh = extent.height * 0.1f;
        float dw = extent.width * 0.1f;
        float x1 = extent.x;
        float y1 = extent.y + extent.height;
        float x2 = extent.x + extent.width;
        float y2 = extent.y;
        if (this.strike.northSouth()) {
            y1 = extent.y;
            y2 = extent.y + extent.height;
            this.singular(this.line1, this.line1bg, x1 + dw, y1, x2, y2 - dh);
            this.singular(this.line2, this.line2bg, x1, y1 + dh, x2 - dw, y2);
        } else {
            this.singular(this.line1, this.line1bg, x1, y1 - dh, x2 - dw, y2);
            this.singular(this.line2, this.line2bg, x1 + dw, y1, x2, y2 + dh);
        }
    }

    private Rectangle2D.Float extent() {
        Rectangle2D.Float ret = this.pos.extent(this.tv);
        float minRad = ((Float)this.tv.getSetting("tv-mark-min-radius")).floatValue();
        if (ret.width < minRad) {
            ret.width = minRad;
        }
        if (ret.height < minRad) {
            ret.height = minRad;
        }
        return ret;
    }

    private void fixAppendage() {
        if (this.line1bg.getParentNode() == null) {
            this.appendToGroup(this.line1bg);
        }
        if (this.line1.getParentNode() == null) {
            this.appendToGroup(this.line1);
        }
        switch (this.strike.style()) {
            case CircledLine: {
                if (this.ellipsebg.getParentNode() == null) {
                    this.appendToGroup(this.ellipsebg);
                }
                if (this.ellipse.getParentNode() != null) break;
                this.appendToGroup(this.ellipse);
                break;
            }
            case DoubleLine: 
            case Cross: {
                if (this.line2bg.getParentNode() == null) {
                    this.appendToGroup(this.line2bg);
                }
                if (this.line2.getParentNode() != null) break;
                this.appendToGroup(this.line2);
                break;
            }
        }
    }

    private void fixExistence() {
        if (this.line1 == null) {
            this.line1 = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "line");
        }
        if (this.line1bg == null) {
            this.line1bg = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "line");
        }
        switch (this.strike.style()) {
            case DoubleLine: 
            case Cross: {
                if (this.line2 == null) {
                    this.line2 = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "line");
                }
                if (this.line2bg == null) {
                    this.line2bg = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "line");
                }
                if (this.ellipse != null && this.ellipse.getParentNode() != null) {
                    this.ellipse.getParentNode().removeChild(this.ellipse);
                    this.ellipse = null;
                }
                if (this.ellipsebg == null || this.ellipsebg.getParentNode() == null) break;
                this.ellipsebg.getParentNode().removeChild(this.ellipsebg);
                this.ellipsebg = null;
                break;
            }
            case CircledLine: {
                if (this.ellipse == null) {
                    this.ellipse = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "ellipse");
                }
                if (this.ellipsebg == null) {
                    this.ellipsebg = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "ellipse");
                }
                if (this.line2 != null && this.line2.getParentNode() != null) {
                    this.line2.getParentNode().removeChild(this.line2);
                    this.line2 = null;
                }
                if (this.line2bg == null || this.line2bg.getParentNode() == null) break;
                this.line2bg.getParentNode().removeChild(this.line2bg);
                this.line2bg = null;
                break;
            }
            case Line: {
                if (this.line2 != null && this.line2.getParentNode() != null) {
                    this.line2.getParentNode().removeChild(this.line2);
                    this.line2 = null;
                }
                if (this.line2bg != null && this.line2bg.getParentNode() != null) {
                    this.line2bg.getParentNode().removeChild(this.line2bg);
                    this.line2bg = null;
                }
                if (this.ellipse != null && this.ellipse.getParentNode() != null) {
                    this.ellipse.getParentNode().removeChild(this.ellipse);
                    this.ellipse = null;
                }
                if (this.ellipsebg == null || this.ellipsebg.getParentNode() == null) break;
                this.ellipsebg.getParentNode().removeChild(this.ellipsebg);
                this.ellipsebg = null;
            }
        }
    }

    private void singleLine() {
        this.styleLine(this.line1);
        this.styleBg(this.line1bg);
        Rectangle2D.Float extent = this.extent();
        float x1 = extent.x;
        float y1 = extent.y + extent.height;
        float x2 = extent.x + extent.width;
        float y2 = extent.y;
        if (this.strike.northSouth()) {
            y1 = extent.y;
            y2 = extent.y + extent.height;
        }
        this.singular(this.line1, this.line1bg, x1, y1, x2, y2);
    }

    private void singular(Element line, Element bg, float x1, float y1, float x2, float y2) {
        line.setAttributeNS(null, "x1", "" + x1);
        line.setAttributeNS(null, "y1", "" + y1);
        line.setAttributeNS(null, "x2", "" + x2);
        line.setAttributeNS(null, "y2", "" + y2);
        bg.setAttributeNS(null, "x1", "" + x1);
        bg.setAttributeNS(null, "y1", "" + y1);
        bg.setAttributeNS(null, "x2", "" + x2);
        bg.setAttributeNS(null, "y2", "" + y2);
    }

    private void styleBg(Element line) {
        line.setAttributeNS(null, "stroke", TreeView.colourToHTML(super.getColour("tv-strike-colour")));
        line.setAttributeNS(null, "stroke-width", "" + super.getThickness() * 2);
        line.setAttributeNS(null, "stroke-opacity", "0.0");
        line.setAttributeNS(null, "fill", "none");
        line.setAttributeNS(null, "stroke-linecap", "round");
        line.setAttributeNS(null, "stroke-linejoin", "round");
    }

    private void styleLine(Element line) {
        line.setAttributeNS(null, "stroke", TreeView.colourToHTML(super.getColour("tv-strike-colour")));
        line.setAttributeNS(null, "stroke-width", "" + super.getThickness());
        line.setAttributeNS(null, "fill", "none");
        line.setAttributeNS(null, "stroke-linecap", "round");
        line.setAttributeNS(null, "stroke-linejoin", "round");
    }

    @Override
    public void draw() {
        super.makeGroup();
        super.appendGroup();
        this.update(this.strike);
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    @Override
    public void onMouseOut(DOMMouseEvent evt) {
        if (this.line1bg != null) {
            this.line1bg.setAttributeNS(null, "stroke-opacity", this.amSelected() ? "1.0" : "0.0");
        }
        if (this.line2bg != null) {
            this.line2bg.setAttributeNS(null, "stroke-opacity", this.amSelected() ? "1.0" : "0.0");
        }
        if (this.ellipsebg != null) {
            this.ellipsebg.setAttributeNS(null, "stroke-opacity", this.amSelected() ? "1.0" : "0.0");
        }
    }

    @Override
    public void onMouseOver(DOMMouseEvent evt) {
        if (this.line1bg != null) {
            this.line1bg.setAttributeNS(null, "stroke-opacity", "1.0");
        }
        if (this.line2bg != null) {
            this.line2bg.setAttributeNS(null, "stroke-opacity", "1.0");
        }
        if (this.ellipsebg != null) {
            this.ellipsebg.setAttributeNS(null, "stroke-opacity", "1.0");
        }
    }

    @Override
    public void reposition() {
        switch (this.strike.style()) {
            case CircledLine: {
                this.circledLine();
                break;
            }
            case Cross: {
                this.cross();
                break;
            }
            case DoubleLine: {
                this.doubleLine();
                break;
            }
            case Line: {
                this.singleLine();
            }
        }
    }

    @Override
    public void selectMe(boolean b) {
        Color clr = b ? (Color)this.tv.getSetting("selection-colour") : super.getColour("tv-strike-colour");
        if (this.line1bg != null) {
            this.line1bg.setAttributeNS(null, "stroke", TreeView.colourToHTML(clr));
        }
        if (this.line2bg != null) {
            this.line2bg.setAttributeNS(null, "stroke", TreeView.colourToHTML(clr));
        }
        if (this.ellipsebg != null) {
            this.ellipsebg.setAttributeNS(null, "stroke", TreeView.colourToHTML(clr));
        }
        super.selectMe(b);
    }

    @Override
    public String title() {
        String ret = "Strike (";
        switch (this.strike.style()) {
            case CircledLine: {
                ret = ret + "circled line";
                break;
            }
            case Cross: {
                ret = ret + "cross";
                break;
            }
            case DoubleLine: {
                ret = ret + "double line";
                break;
            }
            case Line: {
                ret = ret + "single line";
            }
        }
        return ret + ")";
    }

    @Override
    public ActionGroup getActions() {
        ActionGroup ret = super.getActions();
        ret.add(this.title(), this.tv.getControl().getFlipStrikeAction());
        return ret.add(this.title(), this.tv.getControl().getChangeStrikeActions());
    }

    @Override
    public HierarchicalObject that() {
        return this.strike;
    }

    @Override
    public boolean update(Object obj) {
        if (!(obj instanceof Strike)) {
            return false;
        }
        this.strike = (Strike)obj;
        this.pos = this.strike.pos();
        super.grabTweaks();
        this.fixExistence();
        this.reposition();
        this.fixAppendage();
        super.update();
        return true;
    }
}

