/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.drawables;

import java.awt.Color;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.DrawableObject;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.svg.SVGOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class PosDrawable {
    public Element elm;
    public DrawableObject obj;
    public Position.Pnt pos;
    private TreeView tv;
    private boolean selected;
    private Element depLignum;
    private EventListener evtListener = new EventListener(){

        private void click(DOMMouseEvent me) {
            if (me.getButton() == 0) {
                PosDrawable.this.tv.startUserPositioning(PosDrawable.this.tv.getSelectedPosObj(), PosDrawable.this.tv.getSelectedPos());
            }
        }

        private void mouseOut() {
            if (!PosDrawable.this.selected) {
                PosDrawable.this.elm.setAttributeNS(null, "stroke", "" + TreeView.colourToHTML((Color)PosDrawable.this.tv.getSetting("tv-pos-selected-colour")));
            }
        }

        private void mouseOver() {
            PosDrawable.this.tv.setSelectedPos(PosDrawable.this);
        }

        @Override
        public void handleEvent(Event evt) {
            if (PosDrawable.this.tv.haltClick()) {
                return;
            }
            switch (evt.getType()) {
                case "click": {
                    this.click((DOMMouseEvent)evt);
                    break;
                }
                case "mouseover": {
                    this.mouseOver();
                    break;
                }
                case "mouseout": {
                    this.mouseOut();
                }
            }
            evt.stopPropagation();
            evt.preventDefault();
        }
    };

    public PosDrawable(TreeView tv, Position.Pnt pos, DrawableObject obj) {
        this.tv = tv;
        this.pos = pos;
        this.obj = obj;
    }

    public void draw() {
        this.elm = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "circle");
        this.elm.setAttributeNS(null, "stroke", "" + TreeView.colourToHTML((Color)this.tv.getSetting("tv-pos-selected-colour")));
        this.elm.setAttributeNS(null, "stroke-width", "3");
        this.elm.setAttributeNS(null, "r", "3");
        this.elm.setAttributeNS(null, "fill", "#000");
        String x = "0";
        String y = "0";
        if (!this.obj.fixed) {
            x = "" + this.pos.getAbsX();
            y = "" + this.pos.getAbsY();
        }
        this.elm.setAttributeNS(null, "cx", x);
        this.elm.setAttributeNS(null, "cy", y);
        this.obj.appendToGroup(this.elm);
        if (this.pos.anchor() != null && ((Boolean)this.tv.getSetting("tv-show-deplines")).booleanValue()) {
            this.depLignum = this.tv.doc.createElementNS("http://www.w3.org/2000/svg", "line");
            this.depLignum.setAttributeNS(null, "stroke", "#FF0000");
            this.depLignum.setAttributeNS(null, "stroke-width", "1");
            this.depLignum.setAttributeNS(null, "stroke-dasharray", "2");
            this.depLignum.setAttributeNS(null, "x1", "" + this.pos.getAbsX());
            this.depLignum.setAttributeNS(null, "y1", "" + this.pos.getAbsY());
            this.depLignum.setAttributeNS(null, "x2", "" + this.pos.anchor().getAbsX());
            this.depLignum.setAttributeNS(null, "y2", "" + this.pos.anchor().getAbsY());
            this.depLignum.setAttributeNS(null, "marker-end", "url(#depArrow)");
            this.tv.annoElm.appendChild(this.depLignum);
        }
        ((SVGOMElement)this.elm).addEventListener("click", this.evtListener, false);
        ((SVGOMElement)this.elm).addEventListener("mouseover", this.evtListener, false);
        ((SVGOMElement)this.elm).addEventListener("mouseout", this.evtListener, false);
    }

    public void selectMe(boolean b) {
        this.selected = b;
        if (b) {
            this.elm.setAttributeNS(null, "stroke", "#00F");
        } else {
            this.elm.setAttributeNS(null, "stroke", "" + TreeView.colourToHTML((Color)this.tv.getSetting("tv-pos-selected-colour")));
        }
    }

    public void wipe() {
        if (this.elm == null) {
            return;
        }
        this.elm.getParentNode().removeChild(this.elm);
        if (this.depLignum != null) {
            this.depLignum.getParentNode().removeChild(this.depLignum);
        }
    }
}

