/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.drawables;

import java.awt.Color;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;

public class StyleToCSSConverter {
    private static HashMap<Object, String> mapping = null;

    private static String convert(Object key, String cssKey, Object value) {
        switch (cssKey) {
            case "baseline-shift": {
                if (!((Boolean)value).booleanValue()) {
                    return null;
                }
                if (key.equals(StyleConstants.Subscript)) {
                    return "sub";
                }
                if (key.equals(StyleConstants.Superscript)) {
                    return "super";
                }
            }
            case "background-color": 
            case "color": 
            case "fill": {
                Color clr = (Color)value;
                return "rgb(" + clr.getRed() + "," + clr.getGreen() + "," + clr.getBlue() + ")";
            }
            case "font-weight": {
                return (Boolean)value != false ? "bold" : "normal";
            }
            case "text-decoration": {
                if (!((Boolean)value).booleanValue()) {
                    return null;
                }
                if (key.equals(StyleConstants.StrikeThrough)) {
                    return "line-through";
                }
                if (key.equals(StyleConstants.Underline)) {
                    return "underline";
                }
                return "none";
            }
            case "font-size": {
                return value.toString() + "pt";
            }
            case "font-style": {
                return (Boolean)value != false ? "italic" : "normal";
            }
        }
        return value.toString();
    }

    public static String convertAlignment(Object value) {
        if (value == null) {
            return "middle";
        }
        switch ((Integer)value) {
            case 0: {
                return "start";
            }
            case 1: {
                return "middle";
            }
            case 2: {
                return "end";
            }
        }
        return "middle";
    }

    private static void convertAndPut(Object key, Object value, HashMap<String, String> map) {
        if (!StyleToCSSConverter.canConvert(key)) {
            return;
        }
        String cssAttr = mapping.get(key);
        String cssVal = StyleToCSSConverter.convert(key, cssAttr, value);
        if (cssVal != null) {
            map.put(cssAttr, cssVal);
        }
    }

    private static void initMapping() {
        mapping = new HashMap();
        mapping.put(StyleConstants.Background, "background-color");
        mapping.put(StyleConstants.Bold, "font-weight");
        mapping.put(StyleConstants.Family, "font-family");
        mapping.put(StyleConstants.FontFamily, "font-family");
        mapping.put(StyleConstants.FontSize, "font-size");
        mapping.put(StyleConstants.Foreground, "fill");
        mapping.put(StyleConstants.Italic, "font-style");
        mapping.put(StyleConstants.LineSpacing, "line-height");
        mapping.put(StyleConstants.Size, "font-size");
        mapping.put(StyleConstants.StrikeThrough, "text-decoration");
        mapping.put(StyleConstants.Underline, "text-decoration");
        mapping.put(StyleConstants.Subscript, "baseline-shift");
        mapping.put(StyleConstants.Superscript, "baseline-shift");
    }

    public static HashMap<String, String> attrToMap(AttributeSet attr) {
        HashMap<String, String> ret = new HashMap<String, String>();
        Enumeration<?> keys = attr.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = attr.getAttribute(key);
            StyleToCSSConverter.convertAndPut(key, value, ret);
        }
        return ret;
    }

    public static boolean canConvert(Object key) {
        if (mapping == null) {
            StyleToCSSConverter.initMapping();
        }
        return mapping.containsKey(key);
    }

    public static String mapToString(HashMap<String, String> map) {
        String ret = "";
        for (String key : map.keySet()) {
            ret = ret + key + ":" + map.get(key) + ";";
        }
        return ret;
    }
}

