/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.texteditor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import nl.rug.batik.texteditor.editorkit.ScaledLabelView;
import nl.rug.batik.texteditor.editorkit.ScaledView;
import nl.rug.syntree.bracketstructure.texteditor.BracketDocumentContent;
import rtf.AdvancedRTFDocument;
import rtf.AdvancedRTFEditorKit;

public class SVGEditorKit
extends AdvancedRTFEditorKit {
    public static final String ORIGSIZE_ATTR = "orig-font-size";
    public static final float SCALING_FACTOR = 0.7f;

    @Override
    public AdvancedRTFDocument createDefaultDocument() {
        return new BracketDocumentContent();
    }

    public Action getActionByName(String name) {
        for (Action act : super.getActions()) {
            if (!act.getValue("Name").equals(name)) continue;
            return act;
        }
        return null;
    }

    @Override
    public String getContentType() {
        return "text/rtf";
    }

    @Override
    public ViewFactory getViewFactory() {
        return new SVGViewFactory();
    }

    public class SVGViewFactory
    implements ViewFactory {
        @Override
        public View create(Element elm) {
            String kind = elm.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new ScaledLabelView(elm);
                }
                if (kind.equals("paragraph")) {
                    return new SVGParagraphView(elm);
                }
                if (kind.equals("section")) {
                    return new ScaledView(elm, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elm);
                }
                if (kind.equals("icon")) {
                    return new IconView(elm);
                }
            }
            return new ScaledLabelView(elm);
        }
    }

    public class SVGParagraphView
    extends ParagraphView {
        public SVGParagraphView(Element elm) {
            super(elm);
        }

        @Override
        public float getMinimumSpan(int axis) {
            return super.getPreferredSpan(axis);
        }

        @Override
        public void layout(int width, int height) {
            super.layout(width + 1, height);
        }
    }

    public static class SmallCapsAction
    extends StyledEditorKit.StyledTextAction {
        public static final String SMALLCAPS_ATTR = "SmallCaps";

        public SmallCapsAction() {
            super(SMALLCAPS_ATTR);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor == null) {
                return;
            }
            String text = editor.getSelectedText();
            int selStart = editor.getSelectionStart();
            int selEnd = editor.getSelectionEnd();
            if (text == null) {
                return;
            }
            MutableAttributeSet mas = (MutableAttributeSet)this.getStyledEditorKit(editor).getInputAttributes().copyAttributes();
            if (mas.isDefined(SMALLCAPS_ATTR)) {
                SubscriptAction.setFontScaling(mas, false);
                String origText = (String)mas.getAttribute(SMALLCAPS_ATTR);
                text = origText.toUpperCase().equals(text) ? origText : text.toLowerCase();
                mas.removeAttribute(SMALLCAPS_ATTR);
            } else {
                SubscriptAction.setFontScaling(mas, true);
                mas.addAttribute(SMALLCAPS_ATTR, text);
                text = text.toUpperCase();
            }
            editor.replaceSelection(text);
            editor.setSelectionStart(selStart);
            editor.setSelectionEnd(selEnd);
            this.setCharacterAttributes(editor, mas, true);
        }
    }

    public static class SuperscriptAction
    extends StyledEditorKit.StyledTextAction {
        public SuperscriptAction() {
            super(StyleConstants.Superscript.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor == null) {
                return;
            }
            MutableAttributeSet mas = (MutableAttributeSet)this.getStyledEditorKit(editor).getInputAttributes().copyAttributes();
            if (StyleConstants.isSuperscript(mas)) {
                SubscriptAction.setFontScaling(mas, false);
                StyleConstants.setSuperscript(mas, false);
            } else {
                SubscriptAction.setFontScaling(mas, true);
                StyleConstants.setSubscript(mas, false);
                StyleConstants.setSuperscript(mas, true);
            }
            this.setCharacterAttributes(editor, mas, true);
        }
    }

    public static class SubscriptAction
    extends StyledEditorKit.StyledTextAction {
        public SubscriptAction() {
            super(StyleConstants.Subscript.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor == null) {
                return;
            }
            MutableAttributeSet mas = (MutableAttributeSet)this.getStyledEditorKit(editor).getInputAttributes().copyAttributes();
            if (StyleConstants.isSubscript(mas)) {
                SubscriptAction.setFontScaling(mas, false);
                StyleConstants.setSubscript(mas, false);
            } else {
                SubscriptAction.setFontScaling(mas, true);
                StyleConstants.setSuperscript(mas, false);
                StyleConstants.setSubscript(mas, true);
            }
            this.setCharacterAttributes(editor, mas, true);
        }

        public static void setFontScaling(MutableAttributeSet mas, boolean add) {
            if (!add) {
                if (!mas.isDefined(SVGEditorKit.ORIGSIZE_ATTR)) {
                    return;
                }
                int origSize = (Integer)mas.getAttribute(SVGEditorKit.ORIGSIZE_ATTR);
                StyleConstants.setFontSize(mas, origSize);
                mas.removeAttribute(SVGEditorKit.ORIGSIZE_ATTR);
            } else {
                if (mas.isDefined(SVGEditorKit.ORIGSIZE_ATTR)) {
                    return;
                }
                int origSize = StyleConstants.getFontSize(mas);
                mas.addAttribute(SVGEditorKit.ORIGSIZE_ATTR, origSize);
                StyleConstants.setFontSize(mas, Math.round((float)origSize * 0.7f));
            }
        }
    }

    public static class StrikethroughAction
    extends StyledEditorKit.StyledTextAction {
        public StrikethroughAction() {
            super(StyleConstants.StrikeThrough.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor == null) {
                return;
            }
            StyledEditorKit kit = this.getStyledEditorKit(editor);
            MutableAttributeSet attr = kit.getInputAttributes();
            boolean strikeThrough = !StyleConstants.isStrikeThrough(attr);
            StyleConstants.setStrikeThrough(attr, strikeThrough);
            this.setCharacterAttributes(editor, attr, false);
        }
    }

    public static class BackgroundAction
    extends StyledEditorKit.StyledTextAction {
        private Color fg;

        public BackgroundAction(Color fg) {
            super(StyleConstants.Background.toString());
            this.fg = fg;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setBackground(sas, this.fg);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }
}

