/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.texteditor;

import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.text.SimpleAttributeSet;
import nl.rug.syntree.hierarchicalmodel.nodecontent.DocumentContent;
import nl.rug.syntree.mainview.components.FormatActions;
import nl.rug.syntree.mainview.components.RTFEditorPane;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.texteditor.SVGEditorKit;
import nl.rug.syntree.treediagram.texteditor.SVGScrollPane;

public class SVGEditorPane
extends RTFEditorPane {
    private TreeView tv;
    private SVGScrollPane scrollPane;
    private DocumentContent content;

    public SVGEditorPane(TreeView tv, SVGScrollPane scrollPane, DocumentContent content) {
        this.tv = tv;
        this.scrollPane = scrollPane;
        this.content = content;
        this.setEditorKit(new SVGEditorKit());
        this.setDocument(this.content);
        this.content.addDocumentListener(scrollPane);
        this.content.putProperty("PARENT_COMPONENT", this.tv);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setOpaque(true);
        this.setEnabled(true);
    }

    public void end() {
        Rectangle bounds = this.getBounds();
        this.content.cachedWidth = bounds.width;
        this.content.cachedHeight = bounds.height;
        this.content.putProperty("PARENT_COMPONENT", null);
        this.content.removeDocumentListener(this.scrollPane);
        this.setEnabled(false);
        FormatActions.notifyStyleListeners(new SimpleAttributeSet());
    }

    public DocumentContent getContent() {
        return this.content;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }
}

