/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.treediagram.texteditor;

import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.texteditor.SVGEditorPane;
import org.apache.batik.swing.gvt.JGVTComponentListener;

public class SVGScrollPane
extends JScrollPane
implements DocumentListener,
JGVTComponentListener {
    private TreeView tv;
    private Rectangle2D anchorBounds;
    private SVGEditorPane editor;

    public SVGScrollPane(TreeView tv, Rectangle2D anchorBounds) {
        this.tv = tv;
        this.anchorBounds = anchorBounds;
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVGScrollPane.this.reposition();
            }
        });
    }

    @Override
    public void componentTransformChanged(ComponentEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVGScrollPane.this.activeResize();
                SVGScrollPane.this.reposition();
            }
        });
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVGScrollPane.this.activeResize();
                SVGScrollPane.this.reposition();
            }
        });
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SVGScrollPane.this.editor.getDocument().getLength() > 0) {
                    SVGScrollPane.this.activeResize();
                }
                SVGScrollPane.this.reposition();
            }
        });
    }

    public void reposition() {
        int x = (int)Math.ceil(this.anchorBounds.getCenterX() - this.getBounds().getWidth() / 2.0);
        int y = (int)Math.ceil(this.anchorBounds.getCenterY() - this.getBounds().getHeight() / 2.0);
        this.setBounds(x, y, this.getWidth(), this.getHeight());
    }

    public void resize() {
        double pw = this.anchorBounds.getWidth();
        double ph = this.anchorBounds.getHeight();
        if (ph == pw) {
            pw = 0.0;
            ph = this.tv.getRenderingTransform().getScaleY() * 50.0;
        }
        this.setSize((int)pw + 2, (int)ph + 2);
        this.editor.setSize((int)pw + 2, (int)ph + 2);
        this.revalidate();
    }

    public void activeResize() {
        Dimension ps = this.editor.getPreferredSize();
        this.setSize(ps.width + 2, ps.height + 2);
        this.editor.setSize(ps.width + 2, ps.height + 2);
        this.revalidate();
    }

    public void setEditor(SVGEditorPane editor) {
        this.editor = editor;
    }
}

