/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatablePreserveAspectRatioValue
extends AnimatableValue {
    protected static final String[] ALIGN_VALUES;
    protected static final String[] MEET_OR_SLICE_VALUES;
    protected short align;
    protected short meetOrSlice;

    static {
        String[] stringArray = new String[11];
        stringArray[1] = "none";
        stringArray[2] = "xMinYMin";
        stringArray[3] = "xMidYMin";
        stringArray[4] = "xMaxYMin";
        stringArray[5] = "xMinYMid";
        stringArray[6] = "xMidYMid";
        stringArray[7] = "xMaxYMid";
        stringArray[8] = "xMinYMax";
        stringArray[9] = "xMidYMax";
        stringArray[10] = "xMaxYMax";
        ALIGN_VALUES = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[1] = "meet";
        stringArray2[2] = "slice";
        MEET_OR_SLICE_VALUES = stringArray2;
    }

    protected AnimatablePreserveAspectRatioValue(AnimationTarget target) {
        super(target);
    }

    public AnimatablePreserveAspectRatioValue(AnimationTarget target, short align, short meetOrSlice) {
        super(target);
        this.align = align;
        this.meetOrSlice = meetOrSlice;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue result, AnimatableValue to, float interpolation, AnimatableValue accumulation, int multiplier) {
        short newMeetOrSlice;
        short newAlign;
        AnimatablePreserveAspectRatioValue res = result == null ? new AnimatablePreserveAspectRatioValue(this.target) : (AnimatablePreserveAspectRatioValue)result;
        if (to != null && (double)interpolation >= 0.5) {
            AnimatablePreserveAspectRatioValue toValue = (AnimatablePreserveAspectRatioValue)to;
            newAlign = toValue.align;
            newMeetOrSlice = toValue.meetOrSlice;
        } else {
            newAlign = this.align;
            newMeetOrSlice = this.meetOrSlice;
        }
        if (res.align != newAlign || res.meetOrSlice != newMeetOrSlice) {
            res.align = this.align;
            res.meetOrSlice = this.meetOrSlice;
            res.hasChanged = true;
        }
        return res;
    }

    public short getAlign() {
        return this.align;
    }

    public short getMeetOrSlice() {
        return this.meetOrSlice;
    }

    @Override
    public boolean canPace() {
        return false;
    }

    @Override
    public float distanceTo(AnimatableValue other) {
        return 0.0f;
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatablePreserveAspectRatioValue(this.target, 1, 1);
    }

    @Override
    public String toStringRep() {
        if (this.align < 1 || this.align > 10) {
            return null;
        }
        String value = ALIGN_VALUES[this.align];
        if (this.align == 1) {
            return value;
        }
        if (this.meetOrSlice < 1 || this.meetOrSlice > 2) {
            return null;
        }
        return String.valueOf(value) + ' ' + MEET_OR_SLICE_VALUES[this.meetOrSlice];
    }
}

