/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.batik.apps.rasterizer.SVGConverter;
import org.apache.batik.apps.rasterizer.SVGConverterController;
import org.apache.batik.apps.rasterizer.SVGConverterSource;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.TestReport;
import org.apache.batik.transcoder.Transcoder;

abstract class AbstractConfigTest
extends AbstractTest
implements SVGConverterController {
    public static final String ERROR_NO_COMPUTED_TASK = "ConfigTest.error.no.computed.task";
    public static final String ERROR_UNEXPECTED_TRANSCODER_CLASS = "ConfigTest.error.unexpected.transcoder.class";
    public static final String ENTRY_KEY_EXPECTED_TRANSCODER_CLASS = "ConfigTest.entry.key.expected.transcoder.class";
    public static final String ENTRY_KEY_COMPUTED_TRANSCODER_CLASS = "ConfigTest.entry.key.computed.trancoder.class";
    public static final String ERROR_UNEXPECTED_NUMBER_OF_HINTS = "ConfigTest.error.unexpected.number.of.hints";
    public static final String ENTRY_KEY_EXPECTED_NUMBER_OF_HINTS = "ConfigTest.entry.key.expected.number.of.hints";
    public static final String ENTRY_KEY_COMPUTED_NUMBER_OF_HINTS = "ConfigTest.entry.key.computed.number.of.hints";
    public static final String ENTRY_KEY_EXPECTED_HINTS = "ConfigTest.entry.key.expected.hints";
    public static final String ENTRY_KEY_COMPUTED_HINTS = "ConfigTest.entry.key.computed.hints";
    public static final String ERROR_UNEXPECTED_TRANSCODING_HINT = "ConfigTest.error.unexpected.transcoding.hint";
    public static final String ENTRY_KEY_EXPECTED_HINT_KEY = "ConfigTest.entry.key.expected.hint.key";
    public static final String ENTRY_KEY_COMPUTED_HINT_VALUE = "ConfigTest.entry.key.computed.hint.value";
    public static final String ENTRY_KEY_EXPECTED_HINT_VALUE = "ConfigTest.entry.key.expected.hint.value";
    public static final String ERROR_UNEXPECTED_SOURCES_LIST = "ConfigTest.error.unexpected.sources.list";
    public static final String ENTRY_KEY_EXPECTED_NUMBER_OF_SOURCES = "ConfigTest.entry.key.expected.number.of.sources";
    public static final String ENTRY_KEY_COMPUTED_NUMBER_OF_SOURCES = "ConfigTest.entry.key.computed.number.of.sources";
    public static final String ENTRY_KEY_EXPECTED_SOURCE_AT_INDEX = "ConfigTest.entry.key.expected.source.at.index";
    public static final String ENTRY_KEY_COMPUTED_SOURCE_AT_INDEX = "ConfigTest.entry.key.computed.source.at.index";
    public static final String ENTRY_KEY_COMPUTED_SOURCES_LIST = "ConfigTest.entry.key.computed.sources.list";
    public static final String ENTRY_KEY_EXPECTED_SOURCES_LIST = "ConfigTest.entry.key.expected.sources.list";
    public static final String ERROR_UNEXPECTED_DEST_LIST = "ConfigTest.error.unexpected.dest.list";
    public static final String ENTRY_KEY_EXPECTED_NUMBER_OF_DEST = "ConfigTest.entry.key.expected.number.of.dest";
    public static final String ENTRY_KEY_COMPUTED_NUMBER_OF_DEST = "ConfigTest.entry.key.computed.number.of.dest";
    public static final String ENTRY_KEY_EXPECTED_DEST_AT_INDEX = "ConfigTest.entry.key.expected.dest.at.index";
    public static final String ENTRY_KEY_COMPUTED_DEST_AT_INDEX = "ConfigTest.entry.key.computed.dest.at.index";
    public static final String ENTRY_KEY_COMPUTED_DEST_LIST = "ConfigTest.entry.key.computed.dest.list";
    public static final String ENTRY_KEY_EXPECTED_DEST_LIST = "ConfigTest.entry.key.expected.dest.list";
    protected Config expectedConfig;
    protected Config computedConfig;

    protected AbstractConfigTest() {
    }

    protected void setExpectedConfig(Config expectedConfig) {
        this.expectedConfig = expectedConfig;
    }

    protected abstract void configure(SVGConverter var1);

    protected String makeSourceList(List v) {
        int n = v.size();
        StringBuffer sb = new StringBuffer(n * 8);
        int i = 0;
        while (i < n) {
            sb.append(v.get(i).toString());
            ++i;
        }
        return sb.toString();
    }

    protected String makeHintsString(Map map) {
        Iterator iter = map.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            Object key = iter.next();
            sb.append(key.toString());
            sb.append('(');
            sb.append(map.get(key).toString());
            sb.append(") -- ");
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public TestReport runImpl() throws Exception {
        Object cs;
        Object es;
        int cn;
        SVGConverter c = new SVGConverter(this);
        this.configure(c);
        c.execute();
        if (this.computedConfig == null) {
            return this.reportError(ERROR_NO_COMPUTED_TASK);
        }
        if (!this.expectedConfig.transcoderClass.equals(this.computedConfig.transcoderClass)) {
            TestReport report = this.reportError(ERROR_UNEXPECTED_TRANSCODER_CLASS);
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_TRANSCODER_CLASS, this.expectedConfig.transcoderClass);
            report.addDescriptionEntry(ENTRY_KEY_COMPUTED_TRANSCODER_CLASS, this.computedConfig.transcoderClass);
            return report;
        }
        int en = this.expectedConfig.sources.size();
        if (en != (cn = this.computedConfig.sources.size())) {
            TestReport report = this.reportError(ERROR_UNEXPECTED_SOURCES_LIST);
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_NUMBER_OF_SOURCES, "" + en);
            report.addDescriptionEntry(ENTRY_KEY_COMPUTED_NUMBER_OF_SOURCES, "" + cn);
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_SOURCES_LIST, this.makeSourceList(this.expectedConfig.sources));
            report.addDescriptionEntry(ENTRY_KEY_COMPUTED_SOURCES_LIST, this.makeSourceList(this.computedConfig.sources));
            return report;
        }
        int i = 0;
        while (i < en) {
            es = this.expectedConfig.sources.get(i);
            cs = this.computedConfig.sources.get(i);
            if (!this.computedConfig.sources.contains(es)) {
                TestReport report = this.reportError(ERROR_UNEXPECTED_SOURCES_LIST);
                report.addDescriptionEntry(ENTRY_KEY_EXPECTED_SOURCE_AT_INDEX, "[" + i + "] = -" + es + "- (" + es.getClass().getName() + ")");
                report.addDescriptionEntry(ENTRY_KEY_COMPUTED_SOURCE_AT_INDEX, "[" + i + "] = -" + cs + "- (" + es.getClass().getName() + ")");
                report.addDescriptionEntry(ENTRY_KEY_EXPECTED_SOURCES_LIST, this.makeSourceList(this.expectedConfig.sources));
                report.addDescriptionEntry(ENTRY_KEY_COMPUTED_SOURCES_LIST, this.makeSourceList(this.computedConfig.sources));
                return report;
            }
            ++i;
        }
        en = this.expectedConfig.dest.size();
        if (en != (cn = this.computedConfig.dest.size())) {
            TestReport report = this.reportError(ERROR_UNEXPECTED_DEST_LIST);
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_NUMBER_OF_DEST, "" + en);
            report.addDescriptionEntry(ENTRY_KEY_COMPUTED_NUMBER_OF_DEST, "" + cn);
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_DEST_LIST, this.makeSourceList(this.expectedConfig.dest));
            report.addDescriptionEntry(ENTRY_KEY_COMPUTED_DEST_LIST, this.makeSourceList(this.computedConfig.dest));
            return report;
        }
        i = 0;
        while (i < en) {
            es = this.expectedConfig.dest.get(i);
            cs = this.computedConfig.dest.get(i);
            if (!this.computedConfig.dest.contains(cs)) {
                TestReport report = this.reportError(ERROR_UNEXPECTED_DEST_LIST);
                report.addDescriptionEntry(ENTRY_KEY_EXPECTED_DEST_AT_INDEX, "[" + i + "] = " + es);
                report.addDescriptionEntry(ENTRY_KEY_COMPUTED_DEST_AT_INDEX, "[" + i + "] = " + cs);
                report.addDescriptionEntry(ENTRY_KEY_EXPECTED_DEST_LIST, this.makeSourceList(this.expectedConfig.dest));
                report.addDescriptionEntry(ENTRY_KEY_COMPUTED_DEST_LIST, this.makeSourceList(this.computedConfig.dest));
                return report;
            }
            ++i;
        }
        en = this.expectedConfig.hints.size();
        if (en != (cn = this.computedConfig.hints.size())) {
            TestReport report = this.reportError(ERROR_UNEXPECTED_NUMBER_OF_HINTS);
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_NUMBER_OF_HINTS, "" + en);
            report.addDescriptionEntry(ENTRY_KEY_COMPUTED_NUMBER_OF_HINTS, "" + cn);
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_HINTS, this.makeHintsString(this.expectedConfig.hints));
            report.addDescriptionEntry(ENTRY_KEY_COMPUTED_HINTS, this.makeHintsString(this.computedConfig.hints));
            return report;
        }
        for (Object hintKey : this.expectedConfig.hints.keySet()) {
            Object computedHintValue;
            Object expectedHintValue = this.expectedConfig.hints.get(hintKey);
            if (expectedHintValue.equals(computedHintValue = this.computedConfig.hints.get(hintKey))) continue;
            TestReport report = this.reportError(ERROR_UNEXPECTED_TRANSCODING_HINT);
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_HINT_KEY, hintKey.toString());
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_HINT_VALUE, expectedHintValue.toString());
            report.addDescriptionEntry(ENTRY_KEY_COMPUTED_HINT_VALUE, "" + computedHintValue);
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_HINTS, this.makeHintsString(this.expectedConfig.hints));
            report.addDescriptionEntry(ENTRY_KEY_COMPUTED_HINTS, this.makeHintsString(this.computedConfig.hints));
            return report;
        }
        return this.reportSuccess();
    }

    @Override
    public boolean proceedWithComputedTask(Transcoder transcoder, Map hints, List sources, List dest) {
        this.computedConfig = new Config();
        this.computedConfig.transcoderClass = transcoder.getClass();
        this.computedConfig.sources = new ArrayList(sources);
        this.computedConfig.dest = new ArrayList(dest);
        this.computedConfig.hints = new HashMap(hints);
        return false;
    }

    @Override
    public boolean proceedWithSourceTranscoding(SVGConverterSource source, File dest) {
        return true;
    }

    @Override
    public boolean proceedOnSourceTranscodingFailure(SVGConverterSource source, File dest, String errorCode) {
        return true;
    }

    @Override
    public void onSourceTranscodingSuccess(SVGConverterSource source, File dest) {
    }

    static class Config {
        Class transcoderClass;
        HashMap hints;
        List sources;
        List dest;

        Config() {
        }
    }
}

