/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.batik.apps.rasterizer.DestinationType;
import org.apache.batik.apps.rasterizer.SVGConverter;
import org.apache.batik.apps.rasterizer.SVGConverterController;
import org.apache.batik.apps.rasterizer.SVGConverterException;
import org.apache.batik.apps.rasterizer.SVGConverterSource;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.TestReport;
import org.apache.batik.transcoder.Transcoder;

class ConfigErrorTest
extends AbstractTest
implements SVGConverterController {
    String errorCode;
    String foundErrorCode = null;
    public static final String ERROR_DID_NOT_GET_ERROR = "ConfigErrorTest.error.did.not.get.error";
    public static final String ERROR_UNEXPECTED_ERROR_CODE = "ConfigErrorTest.error.unexpected.error.code";
    public static final String ENTRY_KEY_EXPECTED_ERROR_CODE = "ConfigErrorTest.entry.key.expected.error.code";
    public static final String ENTRY_KEY_GOT_ERROR_CODE = "ConfigErrorTest.entry.key.got.error.code";

    public ConfigErrorTest(String expectedErrorCode) {
        this.errorCode = expectedErrorCode;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public TestReport runImpl() throws Exception {
        SVGConverter c = new SVGConverter(this);
        c.setDestinationType(DestinationType.PNG);
        c.setSources(new String[]{"samples/anne.svg"});
        this.configure(c);
        try {
            c.execute();
        }
        catch (SVGConverterException e) {
            e.printStackTrace();
            this.foundErrorCode = e.getErrorCode();
        }
        if (this.foundErrorCode == null) {
            TestReport report = this.reportError(ERROR_DID_NOT_GET_ERROR);
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_ERROR_CODE, this.errorCode);
            return report;
        }
        if (this.foundErrorCode.equals(this.errorCode)) {
            return this.reportSuccess();
        }
        TestReport report = this.reportError(ERROR_UNEXPECTED_ERROR_CODE);
        report.addDescriptionEntry(ENTRY_KEY_EXPECTED_ERROR_CODE, this.errorCode);
        report.addDescriptionEntry(ENTRY_KEY_GOT_ERROR_CODE, this.foundErrorCode);
        return report;
    }

    protected void configure(SVGConverter c) {
    }

    @Override
    public boolean proceedWithComputedTask(Transcoder transcoder, Map hints, List sources, List dest) {
        System.out.println("==================> Starting to process Task <=========================");
        return true;
    }

    @Override
    public boolean proceedWithSourceTranscoding(SVGConverterSource source, File dest) {
        System.out.print("Transcoding " + source + " to " + dest + " ... ");
        return true;
    }

    @Override
    public boolean proceedOnSourceTranscodingFailure(SVGConverterSource source, File dest, String errorCode) {
        System.out.println(" ... FAILURE");
        this.foundErrorCode = errorCode;
        return true;
    }

    @Override
    public void onSourceTranscodingSuccess(SVGConverterSource source, File dest) {
        System.out.println(" ... SUCCESS");
    }
}

