/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.batik.apps.rasterizer.AbstractConfigTest;
import org.apache.batik.apps.rasterizer.DestinationType;
import org.apache.batik.apps.rasterizer.SVGConverter;
import org.apache.batik.apps.rasterizer.SVGConverterFileSource;
import org.apache.batik.transcoder.image.PNGTranscoder;

class HintsConfigTest
extends AbstractConfigTest {
    static final String SOURCE_FILE = "samples/anne.svg";
    static final String DEST_FILE_NAME = "samples/anne";
    static final Class EXPECTED_TRANSCODER_CLASS = PNGTranscoder.class;
    static final DestinationType DST_TYPE = DestinationType.PNG;

    public HintsConfigTest(Object[][] hintsMap) {
        AbstractConfigTest.Config config = new AbstractConfigTest.Config();
        config.transcoderClass = EXPECTED_TRANSCODER_CLASS;
        ArrayList<SVGConverterFileSource> sources = new ArrayList<SVGConverterFileSource>();
        sources.add(new SVGConverterFileSource(new File(SOURCE_FILE)));
        config.sources = sources;
        ArrayList<File> dest = new ArrayList<File>();
        dest.add(new File(DEST_FILE_NAME + DST_TYPE.getExtension()));
        config.dest = dest;
        HashMap<Object, Object> hints = new HashMap<Object, Object>();
        int n = hintsMap.length;
        int i = 0;
        while (i < n) {
            hints.put(hintsMap[i][0], hintsMap[i][1]);
            ++i;
        }
        config.hints = hints;
        this.setExpectedConfig(config);
    }

    @Override
    public void configure(SVGConverter c) {
        c.setSources(new String[]{SOURCE_FILE});
        c.setDst(new File(DEST_FILE_NAME + DST_TYPE.getExtension()));
        c.setDestinationType(DST_TYPE);
        this.deltaConfigure(c);
    }

    protected void deltaConfigure(SVGConverter c) {
    }
}

