/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.util.StringTokenizer;
import org.apache.batik.apps.rasterizer.Main;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.TestReport;

class MainIllegalArgTest
extends AbstractTest {
    String badOption;
    String args;
    TestReport report;
    public static final String ERROR_NO_ERROR_REPORTED = "MainIllegalArgTest.error.no.error.reported";
    public static final String ERROR_UNEXPECTED_ERROR_CODE = "MainIllegalArgTest.error.unexpected.error.code";
    public static final String ENTRY_KEY_EXPECTED_ERROR_CODE = "MainIllegalArgTest.entry.key.expected.error.code";
    public static final String ENTRY_KEY_GOT_ERROR_CODE = "MainIllegalArgTest.entry.key.got.error.code";

    public MainIllegalArgTest(String badOption, String args) {
        this.badOption = badOption;
        this.args = args;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public TestReport runImpl() throws Exception {
        String[] argsArray = this.makeArgsArray(this.args);
        Main main = new Main(argsArray){

            @Override
            public void error(String errorCode, Object[] errorArgs) {
                if ("Main.error.illegal.argument".equals(errorCode)) {
                    MainIllegalArgTest.this.report = MainIllegalArgTest.this.reportSuccess();
                } else {
                    MainIllegalArgTest.this.report = MainIllegalArgTest.this.reportError(MainIllegalArgTest.ERROR_UNEXPECTED_ERROR_CODE);
                    MainIllegalArgTest.this.report.addDescriptionEntry(MainIllegalArgTest.ENTRY_KEY_EXPECTED_ERROR_CODE, "Main.error.illegal.argument");
                    MainIllegalArgTest.this.report.addDescriptionEntry(MainIllegalArgTest.ENTRY_KEY_GOT_ERROR_CODE, errorCode);
                }
            }
        };
        main.execute();
        if (this.report == null) {
            this.report = this.reportError(ERROR_NO_ERROR_REPORTED);
        }
        return this.report;
    }

    String[] makeArgsArray(String args) {
        StringTokenizer st = new StringTokenizer(args, " ");
        String[] argsArray = new String[st.countTokens()];
        int i = 0;
        while (i < argsArray.length) {
            argsArray[i] = st.nextToken();
            ++i;
        }
        return argsArray;
    }
}

