/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.List;
import org.apache.batik.apps.rasterizer.DestinationType;
import org.apache.batik.apps.rasterizer.MainConfigErrorTest;
import org.apache.batik.apps.rasterizer.MainConfigTest;
import org.apache.batik.apps.rasterizer.MainIllegalArgTest;
import org.apache.batik.apps.rasterizer.SVGConverter;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestSuite;
import org.apache.batik.test.TestReport;

public class MainTest
extends DefaultTestSuite {
    public MainTest() {
        AbstractTest t = new MainConfigTest("-d samples"){

            @Override
            public TestReport validate(SVGConverter c) {
                File dst = c.getDst();
                if (dst != null && dst.equals(new File("samples"))) {
                    return this.reportSuccess();
                }
                return this.reportError("-d", "samples", "" + dst);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.output");
        t = new MainConfigTest("samples/anne.svg"){
            String ERROR_UNEXPECTED_SOURCES;
            {
                this.ERROR_UNEXPECTED_SOURCES = "MainConfigTest.error.unexpected.sources";
            }

            @Override
            public TestReport validate(SVGConverter c) {
                String src;
                List sources = c.getSources();
                if (sources.size() == 1 && "samples/anne.svg".equals(src = (String)sources.get(0))) {
                    return this.reportSuccess();
                }
                return this.reportError(this.ERROR_UNEXPECTED_SOURCES);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.source");
        t = new MainConfigTest("-m image/jpeg"){

            @Override
            public TestReport validate(SVGConverter c) {
                DestinationType type = c.getDestinationType();
                if (type.equals(DestinationType.JPEG)) {
                    return this.reportSuccess();
                }
                return this.reportError("-m", DestinationType.JPEG.toString(), "" + type);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.mimeType.jpegA");
        t = new MainConfigTest("-m image/jpg"){

            @Override
            public TestReport validate(SVGConverter c) {
                DestinationType type = c.getDestinationType();
                if (type.equals(DestinationType.JPEG)) {
                    return this.reportSuccess();
                }
                return this.reportError("-m", DestinationType.JPEG.toString(), "" + type);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.mimeType.jpegB");
        t = new MainConfigTest("-m image/jpe"){

            @Override
            public TestReport validate(SVGConverter c) {
                DestinationType type = c.getDestinationType();
                if (type.equals(DestinationType.JPEG)) {
                    return this.reportSuccess();
                }
                return this.reportError("-m", DestinationType.JPEG.toString(), "" + type);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.mimeType.jpegC");
        t = new MainConfigTest("-m image/png"){

            @Override
            public TestReport validate(SVGConverter c) {
                DestinationType type = c.getDestinationType();
                if (type.equals(DestinationType.PNG)) {
                    return this.reportSuccess();
                }
                return this.reportError("-m", DestinationType.PNG.toString(), "" + type);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.mimeType.png");
        t = new MainConfigTest("-m application/pdf"){

            @Override
            public TestReport validate(SVGConverter c) {
                DestinationType type = c.getDestinationType();
                if (type.equals(DestinationType.PDF)) {
                    return this.reportSuccess();
                }
                return this.reportError("-m", DestinationType.PDF.toString(), "" + type);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.mimeType.pdf");
        t = new MainConfigTest("-m image/tiff"){

            @Override
            public TestReport validate(SVGConverter c) {
                DestinationType type = c.getDestinationType();
                if (type.equals(DestinationType.TIFF)) {
                    return this.reportSuccess();
                }
                return this.reportError("-m", DestinationType.TIFF.toString(), "" + type);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.mimeType.tiff");
        t = new MainConfigTest("-w 467.69"){

            @Override
            public TestReport validate(SVGConverter c) {
                float width = c.getWidth();
                if (width == 467.69f) {
                    return this.reportSuccess();
                }
                return this.reportError("-w", "467.69", "" + width);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.width");
        t = new MainConfigTest("-h 345.67"){

            @Override
            public TestReport validate(SVGConverter c) {
                float height = c.getHeight();
                if (height == 345.67f) {
                    return this.reportSuccess();
                }
                return this.reportError("-h", "345.67", "" + height);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.height");
        t = new MainConfigTest("-maxw 467.69"){

            @Override
            public TestReport validate(SVGConverter c) {
                float maxWidth = c.getMaxWidth();
                if (maxWidth == 467.69f) {
                    return this.reportSuccess();
                }
                return this.reportError("-maxw", "467.69", "" + maxWidth);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.maxWidth");
        t = new MainConfigTest("-maxh 345.67"){

            @Override
            public TestReport validate(SVGConverter c) {
                float maxHeight = c.getMaxHeight();
                if (maxHeight == 345.67f) {
                    return this.reportSuccess();
                }
                return this.reportError("-maxh", "345.67", "" + maxHeight);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.maxHeight");
        t = new MainConfigTest("-a 5,10,20,30"){

            @Override
            public TestReport validate(SVGConverter c) {
                Rectangle2D.Float eAoi = new Rectangle2D.Float(5.0f, 10.0f, 20.0f, 30.0f);
                Rectangle2D aoi = c.getArea();
                if (eAoi.equals(aoi)) {
                    return this.reportSuccess();
                }
                return this.reportError("-a", this.toString(eAoi), this.toString(aoi));
            }

            public String toString(Rectangle2D r) {
                if (r == null) {
                    return "null";
                }
                return String.valueOf(r.getX()) + "," + r.getY() + "," + r.getWidth() + "," + r.getHeight();
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.aoi");
        t = new MainConfigTest("-bg 128.200.100.50"){

            @Override
            public TestReport validate(SVGConverter c) {
                Color eBg = new Color(200, 100, 50, 128);
                Color bg = c.getBackgroundColor();
                if (eBg.equals(bg)) {
                    return this.reportSuccess();
                }
                return this.reportError("-bg", this.toString(eBg), this.toString(bg));
            }

            public String toString(Color c) {
                if (c == null) {
                    return "null";
                }
                return String.valueOf(c.getAlpha()) + "." + c.getRed() + "." + c.getGreen() + "." + c.getBlue();
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.backgroundColor");
        t = new MainConfigTest("-cssMedia projection"){

            @Override
            public TestReport validate(SVGConverter c) {
                String eCssMedia = "projection";
                String cssMedia = c.getMediaType();
                if (eCssMedia.equals(cssMedia)) {
                    return this.reportSuccess();
                }
                return this.reportError("-cssMedia", eCssMedia, cssMedia);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.cssMedia");
        t = new MainConfigTest("-font-family Arial, Comic Sans MS"){

            @Override
            public TestReport validate(SVGConverter c) {
                String eFontFamily = "Arial, Comic Sans MS";
                String fontFamily = c.getDefaultFontFamily();
                if (eFontFamily.equals(fontFamily)) {
                    return this.reportSuccess();
                }
                return this.reportError("-font-family", eFontFamily, fontFamily);
            }

            @Override
            String[] makeArgsArray(String args) {
                return new String[]{"-font-family", "Arial, Comic Sans MS"};
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.fontFamily");
        t = new MainConfigTest("-cssAlternate myAlternateStylesheet"){

            @Override
            public TestReport validate(SVGConverter c) {
                String eAlternate = "myAlternateStylesheet";
                String alternate = c.getAlternateStylesheet();
                if (eAlternate.equals(alternate)) {
                    return this.reportSuccess();
                }
                return this.reportError("-cssAlternate", eAlternate, alternate);
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.cssAlternate");
        t = new MainConfigTest("-validate"){

            @Override
            public TestReport validate(SVGConverter c) {
                if (c.getValidate()) {
                    return this.reportSuccess();
                }
                return this.reportError("-validate", "true", "false");
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.validate");
        t = new MainConfigTest("-onload"){

            @Override
            public TestReport validate(SVGConverter c) {
                if (c.getExecuteOnload()) {
                    return this.reportSuccess();
                }
                return this.reportError("-onload", "true", "false");
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.onload");
        t = new MainConfigTest("-scripts text/jpython"){

            @Override
            public TestReport validate(SVGConverter c) {
                if ("text/jpython".equals(c.getAllowedScriptTypes())) {
                    return this.reportSuccess();
                }
                return this.reportError("-scripts", "text/jpython", ">>" + c.getAllowedScriptTypes() + "<<");
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.scripts");
        t = new MainConfigTest("-anyScriptOrigin"){

            @Override
            public TestReport validate(SVGConverter c) {
                if (!c.getConstrainScriptOrigin()) {
                    return this.reportSuccess();
                }
                return this.reportError("-anyScriptOrigin", "true", "false");
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.anyScriptOrigin");
        t = new MainConfigTest("-scriptSecurityOff"){

            @Override
            public TestReport validate(SVGConverter c) {
                if (c.getSecurityOff()) {
                    return this.reportSuccess();
                }
                return this.reportError("-scriptSecurityOff", "true", "false");
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.scriptSecurityOff");
        t = new MainConfigTest("-lang fr"){

            @Override
            public TestReport validate(SVGConverter c) {
                if ("fr".equals(c.getLanguage())) {
                    return this.reportSuccess();
                }
                return this.reportError("-lang", "fr", c.getLanguage());
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.lang");
        t = new MainConfigTest("-cssUser myStylesheet.css"){

            @Override
            public TestReport validate(SVGConverter c) {
                if ("myStylesheet.css".equals(c.getUserStylesheet())) {
                    return this.reportSuccess();
                }
                return this.reportError("-cssUser", "myStylesheet.css", c.getUserStylesheet());
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.cssUser");
        t = new MainConfigTest("-dpi 5.08"){

            @Override
            public TestReport validate(SVGConverter c) {
                if (c.getPixelUnitToMillimeter() == 5.0f) {
                    return this.reportSuccess();
                }
                return this.reportError("-dpi", "5f", "" + c.getPixelUnitToMillimeter());
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.dpi");
        t = new MainConfigTest("-q .5"){

            @Override
            public TestReport validate(SVGConverter c) {
                if (c.getQuality() == 0.5f) {
                    return this.reportSuccess();
                }
                return this.reportError("-q", ".5f", "" + c.getQuality());
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.quality");
        t = new MainConfigTest("-indexed 8"){

            @Override
            public TestReport validate(SVGConverter c) {
                if (c.getIndexed() == 8) {
                    return this.reportSuccess();
                }
                return this.reportError("-indexed", "8", "" + c.getIndexed());
            }
        };
        this.addTest(t);
        t.setId("MainConfigTest.indexed");
        t = new MainConfigErrorTest("-d", "hello.svg -d");
        this.addTest(t);
        t.setId("MainConfigErrorTest.output");
        t = new MainConfigErrorTest("-m", "hello.svg -m");
        this.addTest(t);
        t.setId("MainConfigErrorTest.mimeType");
        t = new MainConfigErrorTest("-w", "hello.svg -w");
        this.addTest(t);
        t.setId("MainConfigErrorTest.width");
        t = new MainConfigErrorTest("-h", "hello.svg -h");
        this.addTest(t);
        t.setId("MainConfigErrorTest.height");
        t = new MainConfigErrorTest("-maxw", "hello.svg -maxw");
        this.addTest(t);
        t.setId("MainConfigErrorTest.maxWidth");
        t = new MainConfigErrorTest("-maxh", "hello.svg -maxh");
        this.addTest(t);
        t.setId("MainConfigErrorTest.maxHeight");
        t = new MainConfigErrorTest("-a", "hello.svg -a");
        this.addTest(t);
        t.setId("MainConfigErrorTest.area");
        t = new MainConfigErrorTest("-bg", "hello.svg -bg");
        this.addTest(t);
        t.setId("MainConfigErrorTest.backgroundColor");
        t = new MainConfigErrorTest("-cssMedia", "hello.svg -cssMedia");
        this.addTest(t);
        t.setId("MainConfigErrorTest.mediaType");
        t = new MainConfigErrorTest("-font-family", "hello.svg -font-family");
        this.addTest(t);
        t.setId("MainConfigErrorTest.font-family");
        t = new MainConfigErrorTest("-cssAlternate", "hello.svg -cssAlternate");
        this.addTest(t);
        t.setId("MainConfigErrorTest.cssAlternate");
        t = new MainConfigErrorTest("-lang", "hello.svg -lang");
        this.addTest(t);
        t.setId("MainConfigErrorTest.lang");
        t = new MainConfigErrorTest("-cssUser", "hello.svg -cssUser");
        this.addTest(t);
        t.setId("MainConfigErrorTest.cssUser");
        t = new MainConfigErrorTest("-dpi", "hello.svg -dpi");
        this.addTest(t);
        t.setId("MainConfigErrorTest.dpi");
        t = new MainConfigErrorTest("-q", "hello.svg -q");
        this.addTest(t);
        t.setId("MainConfigErrorTest.quality");
        t = new MainConfigErrorTest("-scripts", "hello.svg -scripts");
        this.addTest(t);
        t.setId("MainConfigErrorTest.allowedScriptTypes");
        t = new MainIllegalArgTest("-m", "-m images/jpeq");
        this.addTest(t);
        t.setId("MainIllegalArgTest.mediaType");
        t = new MainIllegalArgTest("-w", "-w abd");
        this.addTest(t);
        t.setId("MainIllegalArgTest.width");
        t = new MainIllegalArgTest("-h", "-h abaa");
        this.addTest(t);
        t.setId("MainIllegalArgTest.height");
        t = new MainIllegalArgTest("-maxw", "-maxw abd");
        this.addTest(t);
        t.setId("MainIllegalArgTest.maxWidth");
        t = new MainIllegalArgTest("-maxh", "-maxh abaa");
        this.addTest(t);
        t.setId("MainIllegalArgTest.maxHeight");
        t = new MainIllegalArgTest("a", "-a aaaaaa");
        this.addTest(t);
        t.setId("MainIllegalArgTest.aoi");
        t = new MainIllegalArgTest("bg", "-bg a.b.c.d");
        this.addTest(t);
        t.setId("MainIllegalArgTest.bg");
        t = new MainIllegalArgTest("dpi", "-dpi invalidDPI");
        this.addTest(t);
        t.setId("MainIllegalArgTest.dpi");
        t = new MainIllegalArgTest("q", "-q illegalQuality");
        this.addTest(t);
        t.setId("MainIllegalArgTest.q");
    }
}

