/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.batik.apps.rasterizer.ConfigErrorTest;
import org.apache.batik.apps.rasterizer.ConverterOutputTest;
import org.apache.batik.apps.rasterizer.DestConfigTest;
import org.apache.batik.apps.rasterizer.DestinationType;
import org.apache.batik.apps.rasterizer.HintsConfigTest;
import org.apache.batik.apps.rasterizer.OperationTest;
import org.apache.batik.apps.rasterizer.SVGConverter;
import org.apache.batik.apps.rasterizer.SVGConverterFileSource;
import org.apache.batik.apps.rasterizer.SVGConverterSource;
import org.apache.batik.apps.rasterizer.SourcesConfigTest;
import org.apache.batik.apps.rasterizer.TranscoderConfigTest;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestSuite;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;

public class SVGConverterTest
extends DefaultTestSuite {
    public SVGConverterTest() {
        AbstractTest t = null;
        t = new TranscoderConfigTest(DestinationType.PNG, PNGTranscoder.class);
        this.addTest(t);
        t.setId("TranscoderConfigTest.PNG");
        t = new TranscoderConfigTest(DestinationType.JPEG, JPEGTranscoder.class);
        this.addTest(t);
        t.setId("TranscoderConfigTest.JPEG");
        t = new TranscoderConfigTest(DestinationType.TIFF, TIFFTranscoder.class);
        this.addTest(t);
        t.setId("TranscoderConfigTest.TIFF");
        try {
            Class<?> pdfClass = Class.forName("org.apache.fop.svg.PDFTranscoder");
            t = new TranscoderConfigTest(DestinationType.PDF, pdfClass);
            t.setId("TranscoderConfigTest.PDF");
            this.addTest(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_AOI, new Rectangle(40, 50, 40, 80)}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setArea(new Rectangle(40, 50, 40, 80));
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_AOI");
        t = new HintsConfigTest(new Object[][]{{JPEGTranscoder.KEY_QUALITY, new Float(0.5)}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setQuality(0.5f);
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_QUALITY");
        t = new HintsConfigTest(new Object[][]{{PNGTranscoder.KEY_INDEXED, new Integer(8)}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setIndexed(8);
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_INDEXED");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_BACKGROUND_COLOR, Color.pink}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setBackgroundColor(Color.pink);
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_BACKGROUND_COLOR");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_HEIGHT, new Float(50.0f)}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setHeight(50.0f);
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_HEIGHT");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_WIDTH, new Float(50.0f)}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setWidth(50.0f);
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_WIDTH");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_MAX_HEIGHT, new Float(50.0f)}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setMaxHeight(50.0f);
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_MAX_HEIGHT");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_MAX_WIDTH, new Float(50.0f)}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setMaxWidth(50.0f);
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_MAX_WIDTH");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_MEDIA, "print"}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setMediaType("print");
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_MEDIA");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_DEFAULT_FONT_FAMILY, "Times"}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setDefaultFontFamily("Times");
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_DEFAULT_FONT_FAMILY");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_ALTERNATE_STYLESHEET, "myStyleSheet"}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setAlternateStylesheet("myStyleSheet");
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_ALTERNATE_STYLESHEET");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_USER_STYLESHEET_URI, "userStylesheet.css"}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setUserStylesheet("userStylesheet.css");
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_USER_STYLESHEET_URI");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_LANGUAGE, "fr"}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setLanguage("fr");
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_LANGUAGE");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, new Float(0.5f)}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setPixelUnitToMillimeter(0.5f);
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_PIXEL_UNIT_TO_MILLIMETER");
        t = new HintsConfigTest(new Object[][]{{ImageTranscoder.KEY_XML_PARSER_VALIDATING, Boolean.TRUE}}){

            @Override
            protected void deltaConfigure(SVGConverter c) {
                c.setValidate(true);
            }
        };
        this.addTest(t);
        t.setId("HintsConfigTest.KEY_XML_PARSER_VALIDATING");
        t = new SourcesConfigTest(new String[]{"samples/anne", "samples/batikFX", "samples/tests/spec/styling/smiley"}){

            @Override
            protected void setSources(SVGConverter c) {
                c.setSources(new String[]{"samples/anne.svg", "samples/batikFX.svg", "samples/tests/spec/styling/smiley.svg"});
            }
        };
        this.addTest(t);
        t.setId("SourcesConfigTest.SimpleList");
        t = new DestConfigTest(new String[]{"samples/anne.svg"}, new String[]{"test-reports/anne.png"}){

            @Override
            protected void setDestination(SVGConverter c) {
                c.setDst(new File("test-reports/anne.png"));
            }
        };
        this.addTest(t);
        t.setId("DestConfigTest.DstFile");
        t = new DestConfigTest(new String[]{"samples/anne.svg", "samples/tests/spec/styling/smiley.svg"}, new String[]{"test-resources/anne.png", "test-resources/smiley.png"}){

            @Override
            protected void setDestination(SVGConverter c) {
                c.setDst(new File("test-resources"));
            }
        };
        this.addTest(t);
        t.setId("DestConfigTest.DstDir");
        t = new OperationTest(){

            @Override
            protected void configure(SVGConverter c) {
                c.setSources(new String[]{"samples/anne.svg"});
                c.setDst(new File("anne.png"));
                File file = new File("anne.png");
                file.deleteOnExit();
            }
        };
        this.addTest(t);
        t.setId("OperationTest.Bug4888");
        t = new OperationTest(){

            @Override
            protected void configure(SVGConverter c) {
                c.setDestinationType(DestinationType.PDF);
                c.setSources(new String[]{"samples/anne.svg"});
            }
        };
        this.addTest(t);
        t.setId("Operationtest.PDFTranscoding");
        t = new ConfigErrorTest("SVGConverter.error.no.sources.specified"){

            @Override
            protected void configure(SVGConverter c) {
                c.setSources(null);
            }
        };
        this.addTest(t);
        t.setId("ConfigErrorTest.ERROR_NO_SOURCES_SPECIFIED");
        t = new ConfigErrorTest("SVGConverter.error.cannot.compute.destination"){

            @Override
            protected void configure(SVGConverter c) {
                c.setSources(new String[]{"http://xml.apache.org/batik/dummy.svg"});
            }
        };
        this.addTest(t);
        t.setId("ConfigErrorTest.ERROR_CANNOT_COMPUTE_DESTINATION");
        t = new ConfigErrorTest("SVGConverter.error.cannot.use.dst.file"){

            @Override
            protected void configure(SVGConverter c) {
                File dummy = null;
                try {
                    dummy = File.createTempFile("dummyPNG", ".png");
                }
                catch (IOException ioEx) {
                    throw new Error(ioEx.getMessage());
                }
                c.setSources(new String[]{"samples/anne.svg", "samples/batikFX.svg"});
                c.setDst(dummy);
                dummy.deleteOnExit();
            }
        };
        this.addTest(t);
        t.setId("ConfigErrorTest.ERROR_CANNOT_USE_DST_FILE");
        t = new ConfigErrorTest("SVGConverter.error.source.same.as.destination"){

            @Override
            protected void configure(SVGConverter c) {
                c.setSources(new String[]{"samples/anne.svg"});
                c.setDst(new File("samples/anne.svg"));
            }
        };
        this.addTest(t);
        t.setId("ConfigErrorTest.ERROR_SOURCE_SAME_AS_DESTINATION");
        t = new ConfigErrorTest("SVGConverter.error.cannot.read.source"){

            @Override
            protected void configure(SVGConverter c) {
                c.setSources(new String[]{"test-resources/org/apache/batik/apps/rasterizer/notReadable.svg"});
                c.setDst(new File("test-reports"));
            }

            @Override
            public boolean proceedWithSourceTranscoding(SVGConverterSource source, File dest) {
                File hackedFile;
                ((SVGConverterFileSource)source).file = hackedFile = new File(((SVGConverterFileSource)source).file.getPath()){

                    @Override
                    public boolean canRead() {
                        System.out.println("Yahoooooooo! In canRead");
                        return false;
                    }
                };
                return true;
            }
        };
        this.addTest(t);
        t.setId("ConfigErrorTest.ERROR_CANNOT_READ_SOURCE");
        t = new ConfigErrorTest("SVGConverter.error.cannot.open.source"){

            @Override
            protected void configure(SVGConverter c) {
                c.setSources(new String[]{"test-resources/org/apache/batik/apps/rasterizer/notReadable.svg"});
            }

            @Override
            public boolean proceedWithComputedTask(Transcoder transcoder, Map hints, List sources, List dest) {
                System.out.println("==================> Hacked Starting to process Task <=========================");
                SVGConverterFileSource source = (SVGConverterFileSource)sources.get(0);
                source = new SVGConverterFileSource(source.file){

                    @Override
                    public InputStream openStream() throws FileNotFoundException {
                        throw new FileNotFoundException("Simulated FileNotFoundException");
                    }
                };
                sources.set(0, source);
                return true;
            }
        };
        this.addTest(t);
        t.setId("ConfigErrorTest.ERROR_CANNOT_OPEN_SOURCE");
        t = new ConfigErrorTest("SVGConverter.error.output.not.writeable"){

            @Override
            protected void configure(SVGConverter c) {
                c.setSources(new String[]{"samples/anne.svg"});
                File o = new File("test-resources/org/apache/batik/apps/rasterizer/readOnly.png");
                o.setReadOnly();
                c.setDst(o);
            }
        };
        this.addTest(t);
        t.setId("ConfigErrorTest.ERROR_OUTPUT_NOT_WRITEABLE");
        t = new ConfigErrorTest("SVGConverter.error.unable.to.create.output.dir"){

            @Override
            protected void configure(SVGConverter c) {
                c.setDst(new File("ZYZ::/cannotCreate\u0000"));
            }
        };
        this.addTest(t);
        t.setId("ConfigErrorTest.ERROR_UNABLE_TO_CREATE_OUTPUT_DIR");
        t = new ConfigErrorTest("SVGConverter.error.while.rasterizing.file"){

            @Override
            protected void configure(SVGConverter c) {
                c.setSources(new String[]{"test-resources/org/apache/batik/apps/rasterizer/invalidSVG.svg"});
            }
        };
        this.addTest(t);
        t.setId("ConfigErrorTest(SVGConverter.ERROR_WHILE_RASTERIZING_FILE");
        t = new ConverterOutputTest("samples/anne.svg", "test-reports/anne.png", "test-references/samples/anne.png");
        this.addTest(t);
        t.setId("OutputTest.plain");
        t = new ConverterOutputTest("samples/anne.svg#svgView(viewBox(0,0,100,200))", "test-reports/anne.png", "test-references/samples/anneViewBox1.png");
        this.addTest(t);
        t.setId("OutputTest.reference");
    }
}

