/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.batik.apps.rasterizer.AbstractConfigTest;
import org.apache.batik.apps.rasterizer.DestinationType;
import org.apache.batik.apps.rasterizer.SVGConverter;
import org.apache.batik.apps.rasterizer.SVGConverterFileSource;

class TranscoderConfigTest
extends AbstractConfigTest {
    static final String SOURCE_FILE = "samples/anne.svg";
    static final String DEST_FILE_NAME = "samples/anne";
    protected DestinationType dstType;

    public TranscoderConfigTest(DestinationType dstType, Class expectedTranscoderClass) {
        HashMap hints;
        this.dstType = dstType;
        AbstractConfigTest.Config config = new AbstractConfigTest.Config();
        config.transcoderClass = expectedTranscoderClass;
        ArrayList<SVGConverterFileSource> sources = new ArrayList<SVGConverterFileSource>();
        sources.add(new SVGConverterFileSource(new File(SOURCE_FILE)));
        config.sources = sources;
        ArrayList<File> dest = new ArrayList<File>();
        dest.add(new File(DEST_FILE_NAME + dstType.getExtension()));
        config.dest = dest;
        config.hints = hints = new HashMap();
        this.setExpectedConfig(config);
    }

    @Override
    public void configure(SVGConverter c) {
        c.setSources(new String[]{SOURCE_FILE});
        c.setDst(new File(DEST_FILE_NAME + this.dstType.getExtension()));
        c.setDestinationType(this.dstType);
    }
}

