/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class SVGGElementBridge
extends AbstractGraphicsNodeBridge {
    @Override
    public String getLocalName() {
        return "g";
    }

    @Override
    public Bridge getInstance() {
        return new SVGGElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        Rectangle2D r;
        CompositeGraphicsNode gn = (CompositeGraphicsNode)super.createGraphicsNode(ctx, e);
        if (gn == null) {
            return null;
        }
        this.associateSVGContext(ctx, e, gn);
        RenderingHints hints = null;
        hints = CSSUtilities.convertColorRendering(e, hints);
        if (hints != null) {
            gn.setRenderingHints(hints);
        }
        if ((r = CSSUtilities.convertEnableBackground(e)) != null) {
            gn.setBackgroundEnable(r);
        }
        return gn;
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return new CompositeGraphicsNode();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public void handleDOMNodeInsertedEvent(MutationEvent evt) {
        if (evt.getTarget() instanceof Element) {
            this.handleElementAdded((CompositeGraphicsNode)this.node, this.e, (Element)((Object)evt.getTarget()));
        } else {
            super.handleDOMNodeInsertedEvent(evt);
        }
    }

    protected void handleElementAdded(CompositeGraphicsNode gn, Node parent, Element childElt) {
        GVTBuilder builder = this.ctx.getGVTBuilder();
        GraphicsNode childNode = builder.build(this.ctx, childElt);
        if (childNode == null) {
            return;
        }
        int idx = -1;
        Node ps = childElt.getPreviousSibling();
        while (ps != null) {
            if (ps.getNodeType() == 1) {
                Element pse = (Element)ps;
                GraphicsNode psgn = this.ctx.getGraphicsNode(pse);
                while (psgn != null && psgn.getParent() != gn) {
                    psgn = psgn.getParent();
                }
                if (psgn != null && (idx = gn.indexOf(psgn)) != -1) break;
            }
            ps = ps.getPreviousSibling();
        }
        gn.add(++idx, childNode);
    }
}

