/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import java.util.StringTokenizer;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.engine.value.svg.MarkerManager;
import org.apache.batik.css.engine.value.svg.OpacityManager;
import org.apache.batik.css.engine.value.svg.SVGColorManager;
import org.apache.batik.css.engine.value.svg.SVGPaintManager;
import org.apache.batik.css.engine.value.svg.SpacingManager;
import org.apache.batik.css.parser.Parser;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;
import org.w3c.css.sac.LexicalUnit;

public class PropertyManagerTest
extends AbstractTest {
    public static final String ERROR_IS_INHERITED = "PropertyManagerTest.error.inherited";
    public static final String ERROR_INHERIT_VALUE = "PropertyManagerTest.error.inherit.value";
    public static final String ERROR_INVALID_DEFAULT_VALUE = "PropertyManagerTest.error.invalid.default.value";
    public static final String ERROR_INVALID_VALUE = "PropertyManagerTest.error.invalid.value";
    public static final String ERROR_INSTANTIATION = "PropertyManagerTest.error.instantiation";
    protected String managerClassName;
    protected Boolean isInherited;
    protected String[] identValues;
    protected String defaultValue;

    public PropertyManagerTest(String managerClassName, Boolean isInherited, String defaultValue, String identValueList) {
        this.managerClassName = managerClassName;
        this.isInherited = isInherited;
        this.defaultValue = defaultValue;
        StringTokenizer tokens = new StringTokenizer(identValueList, "|");
        int nbIdentValue = tokens.countTokens();
        if (nbIdentValue > 0) {
            this.identValues = new String[nbIdentValue];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                this.identValues[i] = tokens.nextToken().trim();
                ++i;
            }
        }
    }

    protected ValueManager createValueManager() throws Exception {
        return (ValueManager)Class.forName(this.managerClassName).newInstance();
    }

    @Override
    public TestReport runImpl() throws Exception {
        String s;
        ValueManager manager;
        DefaultTestReport report = new DefaultTestReport(this);
        try {
            manager = this.createValueManager();
        }
        catch (Exception ex) {
            report.setErrorCode(ERROR_INSTANTIATION);
            report.setPassed(false);
            report.addDescriptionEntry(ERROR_INSTANTIATION, ex.getMessage());
            return report;
        }
        if (!this.defaultValue.equals("__USER_AGENT__") && !this.defaultValue.equalsIgnoreCase(s = manager.getDefaultValue().getCssText())) {
            report.setErrorCode(ERROR_INVALID_DEFAULT_VALUE);
            report.setPassed(false);
            report.addDescriptionEntry(ERROR_INVALID_DEFAULT_VALUE, "should be: " + this.defaultValue);
        }
        if (this.isInherited.booleanValue() != manager.isInheritedProperty()) {
            report.setErrorCode(ERROR_IS_INHERITED);
            report.setPassed(false);
            report.addDescriptionEntry(ERROR_IS_INHERITED, "");
        }
        Parser cssParser = new Parser();
        try {
            LexicalUnit lu = cssParser.parsePropertyValue("inherit");
            Value v = manager.createValue(lu, null);
            String s2 = v.getCssText();
            if (!"inherit".equalsIgnoreCase(s2)) {
                report.setErrorCode(ERROR_INHERIT_VALUE);
                report.setPassed(false);
                report.addDescriptionEntry(ERROR_INHERIT_VALUE, "inherit");
            }
        }
        catch (Exception ex) {
            report.setErrorCode(ERROR_INHERIT_VALUE);
            report.setPassed(false);
            report.addDescriptionEntry(ERROR_INHERIT_VALUE, ex.getMessage());
        }
        if (this.identValues != null) {
            try {
                int i = 0;
                while (i < this.identValues.length) {
                    LexicalUnit lu = cssParser.parsePropertyValue(this.identValues[i]);
                    Value v = manager.createValue(lu, null);
                    String s3 = v.getCssText();
                    if (!this.identValues[i].equalsIgnoreCase(s3)) {
                        report.setErrorCode(ERROR_INVALID_VALUE);
                        report.setPassed(false);
                        report.addDescriptionEntry(ERROR_INVALID_VALUE, String.valueOf(this.identValues[i]) + '/' + s3);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                report.setErrorCode(ERROR_INVALID_VALUE);
                report.setPassed(false);
                report.addDescriptionEntry(ERROR_INVALID_VALUE, ex.getMessage());
            }
        }
        return report;
    }

    public static class DefaultOpacityManager
    extends OpacityManager {
        public DefaultOpacityManager() {
            super("opacity", false);
        }
    }

    public static class FillManager
    extends SVGPaintManager {
        public FillManager() {
            super("fill");
        }
    }

    public static class FillOpacityManager
    extends OpacityManager {
        public FillOpacityManager() {
            super("fill-opacity", true);
        }
    }

    public static class FloodColorManager
    extends SVGColorManager {
        public FloodColorManager() {
            super("flood-color");
        }
    }

    public static class FloodOpacityManager
    extends OpacityManager {
        public FloodOpacityManager() {
            super("flood-opacity", false);
        }
    }

    public static class LetterSpacingManager
    extends SpacingManager {
        public LetterSpacingManager() {
            super("letter-spacing");
        }
    }

    public static class LightingColorManager
    extends SVGColorManager {
        public LightingColorManager() {
            super("lighting-color", ValueConstants.WHITE_RGB_VALUE);
        }
    }

    public static class MarkerEndManager
    extends MarkerManager {
        public MarkerEndManager() {
            super("marker-end");
        }
    }

    public static class MarkerMidManager
    extends MarkerManager {
        public MarkerMidManager() {
            super("marker-mid");
        }
    }

    public static class MarkerStartManager
    extends MarkerManager {
        public MarkerStartManager() {
            super("marker-start");
        }
    }

    public static class StopColorManager
    extends SVGColorManager {
        public StopColorManager() {
            super("stop-color");
        }
    }

    public static class StopOpacityManager
    extends OpacityManager {
        public StopOpacityManager() {
            super("stop-opacity", false);
        }
    }

    public static class StrokeManager
    extends SVGPaintManager {
        public StrokeManager() {
            super("stroke", ValueConstants.NONE_VALUE);
        }
    }

    public static class StrokeOpacityManager
    extends OpacityManager {
        public StrokeOpacityManager() {
            super("stroke-opacity", true);
        }
    }

    public static class WordSpacingManager
    extends SpacingManager {
        public WordSpacingManager() {
            super("word-spacing");
        }
    }
}

