/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.StringReader;
import java.io.StringWriter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.TestReport;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMUtilitiesCharacterEscaping
extends AbstractTest {
    @Override
    public TestReport runImpl() throws Exception {
        SVGDOMImplementation impl = new SVGDOMImplementation();
        Document doc = impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        Element svg = doc.getDocumentElement();
        Element text = doc.createElementNS("http://www.w3.org/2000/svg", "text");
        svg.appendChild(text);
        text.setAttributeNS(null, "id", "myText");
        String unescapedContent = "You should not escape: & # \" ...";
        CDATASection cdata = doc.createCDATASection(unescapedContent);
        text.appendChild(cdata);
        StringWriter stringWriter = new StringWriter();
        DOMUtilities.writeDocument(doc, stringWriter);
        String docString = ((Object)stringWriter).toString();
        System.err.println(">>>>>>>>>>> Document content \n\n" + docString + "\n\n<<<<<<<<<<<<<<<<");
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        doc = f.createDocument("http://xml.apache.org/batik/foo.svg", new StringReader(((Object)stringWriter).toString()));
        text = doc.getElementById("myText");
        cdata = (CDATASection)text.getFirstChild();
        if (cdata.getData().equals(unescapedContent)) {
            return this.reportSuccess();
        }
        TestReport report = this.reportError("Unexpected CDATA read-back");
        report.addDescriptionEntry("expected cdata", unescapedContent);
        report.addDescriptionEntry("actual cdata", cdata.getData());
        return report;
    }
}

