/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.File;
import java.net.URL;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReplaceChildTest
extends AbstractTest {
    public static String ERROR_GET_ELEMENT_BY_ID_FAILED = "error.get.element.by.id.failed";
    public static String ENTRY_KEY_ID = "entry.key.id";
    protected String testFileName;
    protected String rootTag;
    protected String targetId;

    public ReplaceChildTest(String file, String root, String id) {
        this.testFileName = file;
        this.rootTag = root;
        this.targetId = id;
    }

    @Override
    public TestReport runImpl() throws Exception {
        File f;
        URL url;
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXDocumentFactory df = new SAXDocumentFactory(GenericDOMImplementation.getDOMImplementation(), parser);
        Document doc = df.createDocument(null, this.rootTag, (url = (f = new File(this.testFileName)).toURL()).toString(), url.openStream());
        Element e = doc.getElementById(this.targetId);
        if (e == null) {
            DefaultTestReport report = new DefaultTestReport(this);
            report.setErrorCode(ERROR_GET_ELEMENT_BY_ID_FAILED);
            report.addDescriptionEntry(ENTRY_KEY_ID, this.targetId);
            report.setPassed(false);
            return report;
        }
        Element fc = null;
        Node n = e.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1) {
                fc = (Element)n;
                break;
            }
            n = n.getNextSibling();
        }
        Element ne = doc.createElementNS(null, "elt4");
        e.replaceChild(ne, fc);
        if (ne.getParentNode() != e || fc.getParentNode() != null) {
            DefaultTestReport report = new DefaultTestReport(this);
            report.setErrorCode("TestReport.error.test.failed");
            report.setPassed(false);
            return report;
        }
        return this.reportSuccess();
    }
}

