/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.File;
import java.net.URL;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetAttributeTest
extends AbstractTest {
    protected String testFileName;
    protected String rootTag;
    protected String targetId;
    protected String targetAttribute;
    protected String targetValue;
    protected String parserClassName = XMLResourceDescriptor.getXMLParserClassName();
    public static String ERROR_GET_ELEMENT_BY_ID_FAILED = "error.get.element.by.id.failed";
    public static String ENTRY_KEY_ID = "entry.key.id";

    public SetAttributeTest(String testFileName, String rootTag, String targetId, String targetAttribute, String targetValue) {
        this.testFileName = testFileName;
        this.rootTag = rootTag;
        this.targetId = targetId;
        this.targetAttribute = targetAttribute;
        this.targetValue = targetValue;
    }

    public String getParserClassName() {
        return this.parserClassName;
    }

    public void setParserClassName(String parserClassName) {
        this.parserClassName = parserClassName;
    }

    @Override
    public TestReport runImpl() throws Exception {
        File f;
        URL url;
        SAXDocumentFactory df = new SAXDocumentFactory(GenericDOMImplementation.getDOMImplementation(), this.parserClassName);
        Document doc = df.createDocument(null, this.rootTag, (url = (f = new File(this.testFileName)).toURL()).toString(), url.openStream());
        Element e = doc.getElementById(this.targetId);
        if (e == null) {
            DefaultTestReport report = new DefaultTestReport(this);
            report.setErrorCode(ERROR_GET_ELEMENT_BY_ID_FAILED);
            report.addDescriptionEntry(ENTRY_KEY_ID, this.targetId);
            report.setPassed(false);
            return report;
        }
        e.setAttribute(this.targetAttribute, this.targetValue);
        if (this.targetValue.equals(e.getAttribute(this.targetAttribute))) {
            return this.reportSuccess();
        }
        DefaultTestReport report = new DefaultTestReport(this);
        report.setErrorCode("TestReport.error.test.failed");
        report.setPassed(false);
        return report;
    }
}

