/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.parser.DefaultPreserveAspectRatioHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGPreserveAspectRatio;

public abstract class AbstractSVGPreserveAspectRatio
implements SVGPreserveAspectRatio,
SVGConstants {
    protected static final String[] ALIGN_VALUES;
    protected static final String[] MEET_OR_SLICE_VALUES;
    protected short align = (short)6;
    protected short meetOrSlice = 1;

    static {
        String[] stringArray = new String[11];
        stringArray[1] = "none";
        stringArray[2] = "xMinYMin";
        stringArray[3] = "xMidYMin";
        stringArray[4] = "xMaxYMin";
        stringArray[5] = "xMinYMid";
        stringArray[6] = "xMidYMid";
        stringArray[7] = "xMaxYMid";
        stringArray[8] = "xMinYMax";
        stringArray[9] = "xMidYMax";
        stringArray[10] = "xMaxYMax";
        ALIGN_VALUES = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[1] = "meet";
        stringArray2[2] = "slice";
        MEET_OR_SLICE_VALUES = stringArray2;
    }

    public static String getValueAsString(short align, short meetOrSlice) {
        if (align < 1 || align > 10) {
            return null;
        }
        String value = ALIGN_VALUES[align];
        if (align == 1) {
            return value;
        }
        if (meetOrSlice < 1 || meetOrSlice > 2) {
            return null;
        }
        return String.valueOf(value) + ' ' + MEET_OR_SLICE_VALUES[meetOrSlice];
    }

    @Override
    public short getAlign() {
        return this.align;
    }

    @Override
    public short getMeetOrSlice() {
        return this.meetOrSlice;
    }

    @Override
    public void setAlign(short align) {
        this.align = align;
        this.setAttributeValue(this.getValueAsString());
    }

    @Override
    public void setMeetOrSlice(short meetOrSlice) {
        this.meetOrSlice = meetOrSlice;
        this.setAttributeValue(this.getValueAsString());
    }

    public void reset() {
        this.align = (short)6;
        this.meetOrSlice = 1;
    }

    protected abstract void setAttributeValue(String var1) throws DOMException;

    protected abstract DOMException createDOMException(short var1, String var2, Object[] var3);

    protected void setValueAsString(String value) throws DOMException {
        PreserveAspectRatioParserHandler ph = new PreserveAspectRatioParserHandler();
        try {
            PreserveAspectRatioParser p = new PreserveAspectRatioParser();
            p.setPreserveAspectRatioHandler(ph);
            p.parse(value);
            this.align = ph.getAlign();
            this.meetOrSlice = ph.getMeetOrSlice();
        }
        catch (ParseException ex) {
            throw this.createDOMException((short)13, "preserve.aspect.ratio", new Object[]{value});
        }
    }

    protected String getValueAsString() {
        if (this.align < 1 || this.align > 10) {
            throw this.createDOMException((short)13, "preserve.aspect.ratio.align", new Object[]{new Integer(this.align)});
        }
        String value = ALIGN_VALUES[this.align];
        if (this.align == 1) {
            return value;
        }
        if (this.meetOrSlice < 1 || this.meetOrSlice > 2) {
            throw this.createDOMException((short)13, "preserve.aspect.ratio.meet.or.slice", new Object[]{new Integer(this.meetOrSlice)});
        }
        return String.valueOf(value) + ' ' + MEET_OR_SLICE_VALUES[this.meetOrSlice];
    }

    protected class PreserveAspectRatioParserHandler
    extends DefaultPreserveAspectRatioHandler {
        public short align = (short)6;
        public short meetOrSlice = 1;

        protected PreserveAspectRatioParserHandler() {
        }

        public short getAlign() {
            return this.align;
        }

        public short getMeetOrSlice() {
            return this.meetOrSlice;
        }

        @Override
        public void none() throws ParseException {
            this.align = 1;
        }

        @Override
        public void xMaxYMax() throws ParseException {
            this.align = (short)10;
        }

        @Override
        public void xMaxYMid() throws ParseException {
            this.align = (short)7;
        }

        @Override
        public void xMaxYMin() throws ParseException {
            this.align = (short)4;
        }

        @Override
        public void xMidYMax() throws ParseException {
            this.align = (short)9;
        }

        @Override
        public void xMidYMid() throws ParseException {
            this.align = (short)6;
        }

        @Override
        public void xMidYMin() throws ParseException {
            this.align = (short)3;
        }

        @Override
        public void xMinYMax() throws ParseException {
            this.align = (short)8;
        }

        @Override
        public void xMinYMid() throws ParseException {
            this.align = (short)5;
        }

        @Override
        public void xMinYMin() throws ParseException {
            this.align = (short)2;
        }

        @Override
        public void meet() throws ParseException {
            this.meetOrSlice = 1;
        }

        @Override
        public void slice() throws ParseException {
            this.meetOrSlice = (short)2;
        }
    }
}

