/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.File;
import java.net.URL;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CloneNodeTest
extends AbstractTest {
    protected String testFileName;
    protected String targetId;

    public CloneNodeTest(String file, String id) {
        this.testFileName = file;
        this.targetId = id;
    }

    @Override
    public TestReport runImpl() throws Exception {
        File f;
        URL url;
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory df = new SAXSVGDocumentFactory(parser);
        Document doc = df.createDocument((url = (f = new File(this.testFileName)).toURL()).toString(), url.openStream());
        Element e = doc.getElementById(this.targetId);
        if (e == null) {
            DefaultTestReport report = new DefaultTestReport(this);
            report.setErrorCode("error.get.element.by.id.failed");
            report.addDescriptionEntry("entry.key.id", this.targetId);
            report.setPassed(false);
            return report;
        }
        Element celt = (Element)e.cloneNode(true);
        NamedNodeMap attrs = e.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            String val2;
            Node attr = attrs.item(i);
            String ns = attr.getNamespaceURI();
            String name = ns == null ? attr.getNodeName() : attr.getLocalName();
            String val = attr.getNodeValue();
            if (!val.equals(val2 = celt.getAttributeNS(ns, name))) {
                DefaultTestReport report = new DefaultTestReport(this);
                report.setErrorCode("error.attr.comparison.failed");
                report.addDescriptionEntry("entry.attr.name", name);
                report.setPassed(false);
                return report;
            }
            ++i;
        }
        return this.reportSuccess();
    }
}

