/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.util.XMLConstants;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtilities
extends XMLUtilities
implements XMLConstants {
    protected static final String[] LOCK_STRINGS = new String[]{"", "CapsLock", "NumLock", "NumLock CapsLock", "Scroll", "Scroll CapsLock", "Scroll NumLock", "Scroll NumLock CapsLock", "KanaMode", "KanaMode CapsLock", "KanaMode NumLock", "KanaMode NumLock CapsLock", "KanaMode Scroll", "KanaMode Scroll CapsLock", "KanaMode Scroll NumLock", "KanaMode Scroll NumLock CapsLock"};
    protected static final String[] MODIFIER_STRINGS = new String[]{"", "Shift", "Control", "Control Shift", "Meta", "Meta Shift", "Control Meta", "Control Meta Shift", "Alt", "Alt Shift", "Alt Control", "Alt Control Shift", "Alt Meta", "Alt Meta Shift", "Alt Control Meta", "Alt Control Meta Shift", "AltGraph", "AltGraph Shift", "AltGraph Control", "AltGraph Control Shift", "AltGraph Meta", "AltGraph Meta Shift", "AltGraph Control Meta", "AltGraph Control Meta Shift", "Alt AltGraph", "Alt AltGraph Shift", "Alt AltGraph Control", "Alt AltGraph Control Shift", "Alt AltGraph Meta", "Alt AltGraph Meta Shift", "Alt AltGraph Control Meta", "Alt AltGraph Control Meta Shift"};

    protected DOMUtilities() {
    }

    public static void writeDocument(Document doc, Writer w) throws IOException {
        AbstractDocument d = (AbstractDocument)doc;
        if (doc.getDocumentElement() == null) {
            throw new IOException("No document element");
        }
        NSMap m = NSMap.create();
        Node n = doc.getFirstChild();
        while (n != null) {
            DOMUtilities.writeNode(n, w, m, "1.1".equals(d.getXmlVersion()));
            n = n.getNextSibling();
        }
    }

    protected static void writeNode(Node n, Writer w, NSMap m, boolean isXML11) throws IOException {
        switch (n.getNodeType()) {
            case 1: {
                Node c;
                String tagName;
                if (n.hasAttributes()) {
                    NamedNodeMap attr = n.getAttributes();
                    int len = attr.getLength();
                    int i = 0;
                    while (i < len) {
                        Attr a = (Attr)attr.item(i);
                        String name = a.getNodeName();
                        if (name.startsWith("xmlns")) {
                            if (name.length() == 5) {
                                m = m.declare("", a.getNodeValue());
                            } else {
                                String prefix = name.substring(6);
                                m = m.declare(prefix, a.getNodeValue());
                            }
                        }
                        ++i;
                    }
                }
                w.write(60);
                String ns = n.getNamespaceURI();
                if (ns == null) {
                    tagName = n.getNodeName();
                    w.write(tagName);
                    if (!"".equals(m.getNamespace(""))) {
                        w.write(" xmlns=\"\"");
                        m = m.declare("", "");
                    }
                } else {
                    String prefix = n.getPrefix();
                    if (prefix == null) {
                        prefix = "";
                    }
                    if (ns.equals(m.getNamespace(prefix))) {
                        tagName = n.getNodeName();
                        w.write(tagName);
                    } else {
                        prefix = m.getPrefixForElement(ns);
                        if (prefix == null) {
                            prefix = m.getNewPrefix();
                            tagName = String.valueOf(prefix) + ':' + n.getLocalName();
                            w.write(String.valueOf(tagName) + " xmlns:" + prefix + "=\"" + DOMUtilities.contentToString(ns, isXML11) + '\"');
                            m = m.declare(prefix, ns);
                        } else {
                            tagName = prefix.equals("") ? n.getLocalName() : String.valueOf(prefix) + ':' + n.getLocalName();
                            w.write(tagName);
                        }
                    }
                }
                if (n.hasAttributes()) {
                    NamedNodeMap attr = n.getAttributes();
                    int len = attr.getLength();
                    int i = 0;
                    while (i < len) {
                        Attr a = (Attr)attr.item(i);
                        String name = a.getNodeName();
                        String prefix = a.getPrefix();
                        String ans = a.getNamespaceURI();
                        if (!(ans == null || "xmlns".equals(prefix) || name.equals("xmlns") || (prefix == null || ans.equals(m.getNamespace(prefix))) && prefix != null)) {
                            prefix = m.getPrefixForAttr(ans);
                            if (prefix == null) {
                                prefix = m.getNewPrefix();
                                m = m.declare(prefix, ans);
                                w.write(" xmlns:" + prefix + "=\"" + DOMUtilities.contentToString(ans, isXML11) + '\"');
                            }
                            name = String.valueOf(prefix) + ':' + a.getLocalName();
                        }
                        w.write(String.valueOf(' ') + name + "=\"" + DOMUtilities.contentToString(a.getNodeValue(), isXML11) + '\"');
                        ++i;
                    }
                }
                if ((c = n.getFirstChild()) != null) {
                    w.write(62);
                    do {
                        DOMUtilities.writeNode(c, w, m, isXML11);
                    } while ((c = c.getNextSibling()) != null);
                    w.write("</" + tagName + '>');
                    break;
                }
                w.write("/>");
                break;
            }
            case 3: {
                w.write(DOMUtilities.contentToString(n.getNodeValue(), isXML11));
                break;
            }
            case 4: {
                String data = n.getNodeValue();
                if (data.indexOf("]]>") != -1) {
                    throw new IOException("Unserializable CDATA section node");
                }
                w.write("<![CDATA[" + DOMUtilities.assertValidCharacters(data, isXML11) + "]]>");
                break;
            }
            case 5: {
                w.write(String.valueOf('&') + n.getNodeName() + ';');
                break;
            }
            case 7: {
                String target = n.getNodeName();
                String data = n.getNodeValue();
                if (target.equalsIgnoreCase("xml") || target.indexOf(58) != -1 || data.indexOf("?>") != -1) {
                    throw new IOException("Unserializable processing instruction node");
                }
                w.write("<?" + target + ' ' + data + "?>");
                break;
            }
            case 8: {
                w.write("<!--");
                String data = n.getNodeValue();
                int len = data.length();
                if (len != 0 && data.charAt(len - 1) == '-' || data.indexOf("--") != -1) {
                    throw new IOException("Unserializable comment node");
                }
                w.write(data);
                w.write("-->");
                break;
            }
            case 10: {
                String subset;
                String sysID;
                DocumentType dt = (DocumentType)n;
                w.write("<!DOCTYPE " + n.getOwnerDocument().getDocumentElement().getNodeName());
                String pubID = dt.getPublicId();
                if (pubID != null) {
                    char q = DOMUtilities.getUsableQuote(pubID);
                    if (q == '\u0000') {
                        throw new IOException("Unserializable DOCTYPE node");
                    }
                    w.write(" PUBLIC " + q + pubID + q);
                }
                if ((sysID = dt.getSystemId()) != null) {
                    char q = DOMUtilities.getUsableQuote(sysID);
                    if (q == '\u0000') {
                        throw new IOException("Unserializable DOCTYPE node");
                    }
                    if (pubID == null) {
                        w.write(" SYSTEM");
                    }
                    w.write(" " + q + sysID + q);
                }
                if ((subset = dt.getInternalSubset()) != null) {
                    w.write(String.valueOf('[') + subset + ']');
                }
                w.write(62);
                break;
            }
            default: {
                throw new IOException("Unknown DOM node type " + n.getNodeType());
            }
        }
    }

    public static void writeNode(Node n, Writer w) throws IOException {
        if (n.getNodeType() == 9) {
            DOMUtilities.writeDocument((Document)n, w);
        } else {
            AbstractDocument d = (AbstractDocument)n.getOwnerDocument();
            DOMUtilities.writeNode(n, w, NSMap.create(), d == null ? false : "1.1".equals(d.getXmlVersion()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static char getUsableQuote(String s) {
        int ret = 0;
        int i = s.length() - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (c == '\"') {
                if (ret != 0) return '\u0000';
                ret = 39;
            } else if (c == '\'') {
                if (ret != 0) return '\u0000';
                ret = 34;
            }
            --i;
        }
        if (ret == 0) {
            return (char)34;
        }
        int n = ret;
        return (char)n;
    }

    public static String getXML(Node n) {
        StringWriter writer = new StringWriter();
        try {
            DOMUtilities.writeNode(n, writer);
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            return "";
        }
        return ((Object)writer).toString();
    }

    protected static String assertValidCharacters(String s, boolean isXML11) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (!isXML11 && !DOMUtilities.isXMLCharacter(c) || isXML11 && !DOMUtilities.isXML11Character(c)) {
                throw new IOException("Invalid character");
            }
            ++i;
        }
        return s;
    }

    public static String contentToString(String s, boolean isXML11) throws IOException {
        StringBuffer result = new StringBuffer(s.length());
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (!isXML11 && !DOMUtilities.isXMLCharacter(c) || isXML11 && !DOMUtilities.isXML11Character(c)) {
                throw new IOException("Invalid character");
            }
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                case '\'': {
                    result.append("&apos;");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static int getChildIndex(Node child, Node parent) {
        if (child == null || child.getParentNode() != parent || child.getParentNode() == null) {
            return -1;
        }
        return DOMUtilities.getChildIndex(child);
    }

    public static int getChildIndex(Node child) {
        NodeList children = child.getParentNode().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node currentChild = children.item(i);
            if (currentChild == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isAnyNodeAncestorOf(ArrayList ancestorNodes, Node node) {
        int n = ancestorNodes.size();
        int i = 0;
        while (i < n) {
            Node ancestor = (Node)ancestorNodes.get(i);
            if (DOMUtilities.isAncestorOf(ancestor, node)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAncestorOf(Node node, Node descendant) {
        if (node == null || descendant == null) {
            return false;
        }
        Node currentNode = descendant.getParentNode();
        while (currentNode != null) {
            if (currentNode == node) {
                return true;
            }
            currentNode = currentNode.getParentNode();
        }
        return false;
    }

    public static boolean isParentOf(Node node, Node parentNode) {
        return node != null && parentNode != null && node.getParentNode() == parentNode;
    }

    public static boolean canAppend(Node node, Node parentNode) {
        return node != null && parentNode != null && node != parentNode && !DOMUtilities.isAncestorOf(node, parentNode);
    }

    public static boolean canAppendAny(ArrayList children, Node parentNode) {
        if (!DOMUtilities.canHaveChildren(parentNode)) {
            return false;
        }
        int n = children.size();
        int i = 0;
        while (i < n) {
            Node child = (Node)children.get(i);
            if (DOMUtilities.canAppend(child, parentNode)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean canHaveChildren(Node parentNode) {
        if (parentNode == null) {
            return false;
        }
        switch (parentNode.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    public static Node parseXML(String text, Document doc, String uri, Map prefixes, String wrapperElementName, SAXDocumentFactory documentFactory) {
        String wrapperElementPrefix = "";
        String wrapperElementSuffix = "";
        if (wrapperElementName != null) {
            wrapperElementPrefix = "<" + wrapperElementName;
            if (prefixes != null) {
                wrapperElementPrefix = String.valueOf(wrapperElementPrefix) + " ";
                for (Map.Entry e : prefixes.entrySet()) {
                    String currentKey = (String)e.getKey();
                    String currentValue = (String)e.getValue();
                    wrapperElementPrefix = String.valueOf(wrapperElementPrefix) + currentKey + "=\"" + currentValue + "\" ";
                }
            }
            wrapperElementPrefix = String.valueOf(wrapperElementPrefix) + ">";
            wrapperElementSuffix = String.valueOf(wrapperElementSuffix) + "</" + wrapperElementName + '>';
        }
        if (wrapperElementPrefix.trim().length() == 0 && wrapperElementSuffix.trim().length() == 0) {
            try {
                Document d = documentFactory.createDocument(uri, new StringReader(text));
                if (doc == null) {
                    return d;
                }
                DocumentFragment result = doc.createDocumentFragment();
                result.appendChild(doc.importNode(d.getDocumentElement(), true));
                return result;
            }
            catch (Exception d) {
                // empty catch block
            }
        }
        StringBuffer sb = new StringBuffer(wrapperElementPrefix.length() + text.length() + wrapperElementSuffix.length());
        sb.append(wrapperElementPrefix);
        sb.append(text);
        sb.append(wrapperElementSuffix);
        String newText = sb.toString();
        try {
            Document d = documentFactory.createDocument(uri, new StringReader(newText));
            if (doc == null) {
                return d;
            }
            Node node = d.getDocumentElement().getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    node = doc.importNode(node, true);
                    DocumentFragment result = doc.createDocumentFragment();
                    result.appendChild(node);
                    return result;
                }
                node = node.getNextSibling();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Document deepCloneDocument(Document doc, DOMImplementation impl) {
        Element root = doc.getDocumentElement();
        Document result = impl.createDocument(root.getNamespaceURI(), root.getNodeName(), null);
        Element rroot = result.getDocumentElement();
        boolean before = true;
        Node n = doc.getFirstChild();
        while (n != null) {
            if (n == root) {
                before = false;
                if (root.hasAttributes()) {
                    NamedNodeMap attr = root.getAttributes();
                    int len = attr.getLength();
                    int i = 0;
                    while (i < len) {
                        rroot.setAttributeNode((Attr)result.importNode(attr.item(i), true));
                        ++i;
                    }
                }
                Node c = root.getFirstChild();
                while (c != null) {
                    rroot.appendChild(result.importNode(c, true));
                    c = c.getNextSibling();
                }
            } else if (n.getNodeType() != 10) {
                if (before) {
                    result.insertBefore(result.importNode(n, true), rroot);
                } else {
                    result.appendChild(result.importNode(n, true));
                }
            }
            n = n.getNextSibling();
        }
        return result;
    }

    public static boolean isValidName(String s) {
        int m;
        int len = s.length();
        if (len == 0) {
            return false;
        }
        char c = s.charAt(0);
        int d = c / 32;
        if ((NAME_FIRST_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
            return false;
        }
        int i = 1;
        while (i < len) {
            c = s.charAt(i);
            d = c / 32;
            if ((NAME_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidName11(String s) {
        int m;
        int len = s.length();
        if (len == 0) {
            return false;
        }
        char c = s.charAt(0);
        int d = c / 32;
        if ((NAME11_FIRST_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
            return false;
        }
        int i = 1;
        while (i < len) {
            c = s.charAt(i);
            d = c / 32;
            if ((NAME11_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidPrefix(String s) {
        return s.indexOf(58) == -1;
    }

    public static String getPrefix(String s) {
        int i = s.indexOf(58);
        return i == -1 || i == s.length() - 1 ? null : s.substring(0, i);
    }

    public static String getLocalName(String s) {
        int i = s.indexOf(58);
        return i == -1 || i == s.length() - 1 ? s : s.substring(i + 1);
    }

    /*
     * Unable to fully structure code
     */
    public static void parseStyleSheetPIData(String data, HashTable table) {
        i = 0;
        while (i < data.length()) {
            c = data.charAt(i);
            if (!XMLUtilities.isXMLSpace(c)) break;
            ++i;
        }
        block1: while (i < data.length()) {
            c = data.charAt(i);
            d = c / 32;
            if ((DOMUtilities.NAME_FIRST_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + c);
            }
            ident = new StringBuffer();
            ident.append(c);
            while (++i < data.length()) {
                c = data.charAt(i);
                d = c / 32;
                if ((DOMUtilities.NAME_CHARACTER[d] & 1 << (m = c % 32)) == 0) break;
                ident.append(c);
            }
            if (i < data.length()) ** GOTO lbl26
            throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            while (XMLUtilities.isXMLSpace(c = data.charAt(i))) {
                ++i;
lbl26:
                // 2 sources

                if (i < data.length()) continue;
            }
            if (i >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            if (data.charAt(i) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            ++i;
            while (i < data.length()) {
                c = data.charAt(i);
                if (!XMLUtilities.isXMLSpace(c)) break;
                ++i;
            }
            if (i >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            c = data.charAt(i);
            ++i;
            value = new StringBuffer();
            if (c == '\'') {
                while (i < data.length()) {
                    c = data.charAt(i);
                    if (c == '\'') break;
                    value.append(c);
                    ++i;
                }
                if (i >= data.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
                }
            } else if (c == '\"') {
                while (i < data.length()) {
                    c = data.charAt(i);
                    if (c == '\"') break;
                    value.append(c);
                    ++i;
                }
                if (i >= data.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            table.put(ident.toString().intern(), value.toString());
            ++i;
            while (i < data.length()) {
                c = data.charAt(i);
                if (!XMLUtilities.isXMLSpace(c)) continue block1;
                ++i;
            }
        }
    }

    public static String getModifiersList(int lockState, int modifiersEx) {
        modifiersEx = (modifiersEx & 0x2000) != 0 ? 0x10 | modifiersEx >> 6 & 0xF : modifiersEx >> 6 & 0xF;
        String s = LOCK_STRINGS[lockState & 0xF];
        if (s.length() != 0) {
            return String.valueOf(s) + ' ' + MODIFIER_STRINGS[modifiersEx];
        }
        return MODIFIER_STRINGS[modifiersEx];
    }

    public static boolean isAttributeSpecifiedNS(Element e, String namespaceURI, String localName) {
        Attr a = e.getAttributeNodeNS(namespaceURI, localName);
        return a != null && a.getSpecified();
    }

    private static class NSMap {
        private String prefix;
        private String ns;
        private NSMap next;
        private int nextPrefixNumber;

        public static NSMap create() {
            return new NSMap().declare("xml", "http://www.w3.org/XML/1998/namespace").declare("xmlns", "http://www.w3.org/2000/xmlns/");
        }

        private NSMap() {
        }

        public NSMap declare(String prefix, String ns) {
            NSMap m = new NSMap();
            m.prefix = prefix;
            m.ns = ns;
            m.next = this;
            m.nextPrefixNumber = this.nextPrefixNumber;
            return m;
        }

        public String getNewPrefix() {
            String prefix;
            while (this.getNamespace(prefix = "a" + this.nextPrefixNumber++) != null) {
            }
            return prefix;
        }

        public String getNamespace(String prefix) {
            NSMap m = this;
            while (m.next != null) {
                if (m.prefix.equals(prefix)) {
                    return m.ns;
                }
                m = m.next;
            }
            return null;
        }

        public String getPrefixForElement(String ns) {
            NSMap m = this;
            while (m.next != null) {
                if (ns.equals(m.ns)) {
                    return m.prefix;
                }
                m = m.next;
            }
            return null;
        }

        public String getPrefixForAttr(String ns) {
            NSMap m = this;
            while (m.next != null) {
                if (ns.equals(m.ns) && !m.prefix.equals("")) {
                    return m.prefix;
                }
                m = m.next;
            }
            return null;
        }
    }
}

