/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.batik.ext.awt.geom.Messages;
import org.apache.batik.ext.awt.geom.RectListManager;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;
import org.apache.batik.util.Base64Test;

public class RectListManagerTest
extends AbstractTest {
    public static final String REFERENCE_DIR = "test-references/org/apache/batik/ext/awt/geom/";
    public static final String VARIATION_DIR = "variation/";
    public static final String CANDIDATE_DIR = "candidate/";
    public static final String ERROR_READING_RECTS = "RectListManagerTest.error.reading.rects";
    public static final String ERROR_CANNOT_READ_REF_URL = "RectListManagerTest.error.cannot.read.ref.url";
    public static final String ERROR_WRONG_RESULT = "RectListManagerTest.error.wrong.result";
    public static final String ERROR_NO_REFERENCE = "RectListManagerTest.error.no.reference";
    public static final String ENTRY_KEY_ERROR_DESCRIPTION = "RectListManagerTest.entry.key.error.description";
    protected URL rects = null;
    protected URL ref = null;
    protected URL var = null;
    protected File can = null;
    static final String RECT_PREF = "rect";
    static final String RLM_PREF = "rectlistmanger";
    static final String MERGE_PREF = "merge";
    static final String ADD_PREF = "add";
    static final String SUBTRACT_PREF = "subtract";
    static final String CONTAINS_ALL_PREF = "containsall";
    static final String REMOVE_ALL_PREF = "removeall";
    static final String RETAIN_ALL_PREF = "retainall";
    static final String PRINT_PREF = "print";

    public RectListManagerTest(String rects, String ref) {
        this.rects = this.resolveURL(REFERENCE_DIR + rects);
        this.ref = this.resolveURL(REFERENCE_DIR + ref);
        this.var = this.resolveURL("test-references/org/apache/batik/ext/awt/geom/variation/" + ref);
        this.can = new File("test-references/org/apache/batik/ext/awt/geom/candidate/" + ref);
    }

    protected URL resolveURL(String url) {
        File f = new File(url).getAbsoluteFile();
        if (f.getParentFile().exists()) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException();
            }
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(url);
        }
    }

    @Override
    public String getName() {
        return this.rects.toString();
    }

    @Override
    public TestReport runImpl() throws Exception {
        DefaultTestReport report = new DefaultTestReport(this);
        int lineNo = 0;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.rects.openStream()));
            if (this.can.exists()) {
                this.can.delete();
            }
            FileOutputStream fos = new FileOutputStream(this.can);
            PrintStream ps = new PrintStream(fos);
            HashMap rlms = new HashMap();
            RectListManager currRLM = null;
            String currID = null;
            while ((line = reader.readLine()) != null) {
                String pref;
                ++lineNo;
                StringTokenizer st = new StringTokenizer(line = line.toLowerCase());
                if (!st.hasMoreTokens() || (pref = st.nextToken()).startsWith("#")) continue;
                if (RECT_PREF.equals(pref)) {
                    if (st.countTokens() != 4 || currRLM == null) continue;
                    int x = Integer.parseInt(st.nextToken());
                    int y = Integer.parseInt(st.nextToken());
                    int w = Integer.parseInt(st.nextToken());
                    int h = Integer.parseInt(st.nextToken());
                    currRLM.add(new Rectangle(x, y, w, h));
                    continue;
                }
                if (RLM_PREF.equals(pref)) {
                    String id = st.nextToken();
                    Object o = rlms.get(id);
                    if (o == null) {
                        o = new RectListManager();
                        rlms.put(id, o);
                    }
                    currRLM = (RectListManager)o;
                    currID = id;
                    continue;
                }
                if (MERGE_PREF.equals(pref)) {
                    if (currRLM == null) continue;
                    int overhead = Integer.parseInt(st.nextToken());
                    int lineOverhead = Integer.parseInt(st.nextToken());
                    currRLM.mergeRects(overhead, lineOverhead);
                    continue;
                }
                if (ADD_PREF.equals(pref)) {
                    String id;
                    Object o;
                    if (currRLM == null || (o = rlms.get(id = st.nextToken())) == null) continue;
                    currRLM.add((RectListManager)o);
                    continue;
                }
                if (SUBTRACT_PREF.equals(pref)) {
                    String id;
                    Object o;
                    if (currRLM == null || (o = rlms.get(id = st.nextToken())) == null) continue;
                    int overhead = Integer.parseInt(st.nextToken());
                    int lineOverhead = Integer.parseInt(st.nextToken());
                    currRLM.subtract((RectListManager)o, overhead, lineOverhead);
                    continue;
                }
                if (CONTAINS_ALL_PREF.equals(pref)) {
                    String id;
                    Object o;
                    if (currRLM == null || (o = rlms.get(id = st.nextToken())) == null) continue;
                    RectListManager rlm = (RectListManager)o;
                    ps.println("ID: " + currID + " Sz: " + currRLM.size());
                    if (currRLM.containsAll(rlm)) {
                        ps.println("  Contains all: " + id + " Sz: " + rlm.size());
                    } else {
                        ps.println("  Does not contain all: " + id + " Sz: " + rlm.size());
                    }
                    ps.println();
                    continue;
                }
                if (REMOVE_ALL_PREF.equals(pref)) {
                    String id;
                    Object o;
                    if (currRLM == null || (o = rlms.get(id = st.nextToken())) == null) continue;
                    currRLM.removeAll((RectListManager)o);
                    continue;
                }
                if (RETAIN_ALL_PREF.equals(pref)) {
                    String id;
                    Object o;
                    if (currRLM == null || (o = rlms.get(id = st.nextToken())) == null) continue;
                    currRLM.retainAll((RectListManager)o);
                    continue;
                }
                if (!PRINT_PREF.equals(pref) || currRLM == null) continue;
                Iterator i = currRLM.iterator();
                ps.println("ID: " + currID + " Sz: " + currRLM.size());
                while (i.hasNext()) {
                    ps.println("  " + i.next());
                }
                ps.println();
            }
            ps.close();
            fos.close();
        }
        catch (Exception e) {
            StringWriter trace = new StringWriter();
            e.printStackTrace(new PrintWriter(trace));
            report.setErrorCode(ERROR_READING_RECTS);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), Messages.formatMessage(ERROR_READING_RECTS, new String[]{"" + lineNo, this.rects.toString(), trace.toString()}))});
            report.setPassed(false);
            return report;
        }
        InputStream refIS = null;
        try {
            refIS = this.var.openStream();
        }
        catch (Exception e) {
            try {
                refIS = this.ref.openStream();
            }
            catch (Exception ex) {
                StringWriter trace = new StringWriter();
                e.printStackTrace(new PrintWriter(trace));
                report.setErrorCode(ERROR_CANNOT_READ_REF_URL);
                report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), Messages.formatMessage(ERROR_CANNOT_READ_REF_URL, new String[]{this.ref.toString(), trace.toString()}))});
                report.setPassed(false);
            }
        }
        int mismatch = -2;
        if (refIS != null) {
            FileInputStream canIS = new FileInputStream(this.can);
            Checker check = new Checker(canIS, refIS);
            check.start();
            mismatch = check.getMismatch();
        }
        if (mismatch == -1) {
            report.setPassed(true);
            this.can.delete();
            return report;
        }
        if (mismatch == -2) {
            report.setErrorCode(ERROR_NO_REFERENCE);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), Messages.formatMessage(ERROR_NO_REFERENCE, new String[]{this.ref.toString()}))});
        } else {
            report.setErrorCode(ERROR_WRONG_RESULT);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), Messages.formatMessage(ERROR_WRONG_RESULT, new String[]{"" + mismatch}))});
        }
        report.setPassed(false);
        return report;
    }

    public static class Checker
    extends Thread {
        int mismatch = -2;
        InputStream is1;
        InputStream is2;

        public Checker(InputStream is1, InputStream is2) {
            this.is1 = is1;
            this.is2 = is2;
        }

        public int getMismatch() {
            while (true) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            return this.mismatch;
        }

        @Override
        public void run() {
            this.mismatch = Base64Test.compareStreams(this.is1, this.is2, true);
        }
    }
}

