/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.png;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.png.PNGDecodeParam;
import org.apache.batik.ext.awt.image.codec.png.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.png.PNGImageDecoder;
import org.apache.batik.ext.awt.image.codec.png.PNGImageEncoder;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.TestReport;

public class PNGEncoderTest
extends AbstractTest {
    public static final String ERROR_CANNOT_ENCODE_IMAGE = "PNGEncoderTest.error.cannot.encode.image";
    public static final String ERROR_CANNOT_DECODE_IMAGE = "PNGEncoderTest.error.cannot.decode.image";
    public static final String ERROR_DECODED_DOES_NOT_MATCH_ENCODED = "PNGEncoderTest.error.decoded.does.not.match.encoded";

    @Override
    public TestReport runImpl() throws Exception {
        BufferedImage image = new BufferedImage(100, 75, 2);
        Graphics2D ig = image.createGraphics();
        ig.scale(0.5, 0.5);
        ig.setPaint(new Color(128, 0, 0));
        ig.fillRect(0, 0, 100, 50);
        ig.setPaint(Color.orange);
        ig.fillRect(100, 0, 100, 50);
        ig.setPaint(Color.yellow);
        ig.fillRect(0, 50, 100, 50);
        ig.setPaint(Color.red);
        ig.fillRect(100, 50, 100, 50);
        ig.setPaint(new Color(255, 127, 127));
        ig.fillRect(0, 100, 100, 50);
        ig.setPaint(Color.black);
        ig.draw(new Rectangle2D.Double(0.5, 0.5, 199.0, 149.0));
        ig.dispose();
        image = image.getSubimage(50, 0, 50, 25);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream os = this.buildOutputStream(bos);
        PNGEncodeParam params = PNGEncodeParam.getDefaultEncodeParam(image);
        PNGImageEncoder pngImageEncoder = new PNGImageEncoder(os, params);
        try {
            pngImageEncoder.encode(image);
            os.close();
        }
        catch (Exception e) {
            return this.reportException(ERROR_CANNOT_ENCODE_IMAGE, e);
        }
        InputStream is = this.buildInputStream(bos);
        PNGImageDecoder pngImageDecoder = new PNGImageDecoder(is, new PNGDecodeParam());
        RenderedImage decodedRenderedImage = null;
        try {
            decodedRenderedImage = pngImageDecoder.decodeAsRenderedImage(0);
        }
        catch (Exception e) {
            return this.reportException(ERROR_CANNOT_DECODE_IMAGE, e);
        }
        BufferedImage decodedImage = null;
        if (decodedRenderedImage instanceof BufferedImage) {
            decodedImage = (BufferedImage)decodedRenderedImage;
        } else {
            decodedImage = new BufferedImage(decodedRenderedImage.getWidth(), decodedRenderedImage.getHeight(), 2);
            ig = decodedImage.createGraphics();
            ig.drawRenderedImage(decodedRenderedImage, new AffineTransform());
            ig.dispose();
        }
        if (!PNGEncoderTest.checkIdentical(image, decodedImage)) {
            return this.reportError(ERROR_DECODED_DOES_NOT_MATCH_ENCODED);
        }
        return this.reportSuccess();
    }

    public OutputStream buildOutputStream(ByteArrayOutputStream bos) {
        return bos;
    }

    public InputStream buildInputStream(ByteArrayOutputStream bos) {
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public static boolean checkIdentical(BufferedImage imgA, BufferedImage imgB) {
        boolean identical = true;
        if (imgA.getWidth() == imgB.getWidth() && imgA.getHeight() == imgB.getHeight()) {
            int w = imgA.getWidth();
            int h = imgA.getHeight();
            int i = 0;
            while (i < h) {
                int j = 0;
                while (j < w) {
                    if (imgA.getRGB(j, i) != imgB.getRGB(j, i)) {
                        identical = false;
                        break;
                    }
                    ++j;
                }
                if (!identical) break;
                ++i;
            }
        }
        return identical;
    }
}

