/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.tiff;

import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImage;
import org.apache.batik.ext.awt.image.codec.util.SeekableStream;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class TIFFRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] sig1;
    static final byte[] sig2;
    static MagicNumberRegistryEntry.MagicNumber[] magicNumbers;
    static final String[] exts;
    static final String[] mimeTypes;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 73;
        byArray[1] = 73;
        byArray[2] = 42;
        sig1 = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[0] = 77;
        byArray2[1] = 77;
        byArray2[3] = 42;
        sig2 = byArray2;
        magicNumbers = new MagicNumberRegistryEntry.MagicNumber[]{new MagicNumberRegistryEntry.MagicNumber(0, sig1), new MagicNumberRegistryEntry.MagicNumber(0, sig2)};
        exts = new String[]{"tiff", "tif"};
        mimeTypes = new String[]{"image/tiff", "image/tif"};
    }

    public TIFFRegistryEntry() {
        super("TIFF", exts, mimeTypes, magicNumbers);
    }

    @Override
    public Filter handleStream(InputStream inIS, ParsedURL origURL, boolean needRawData) {
        Object[] errParam;
        String errCode;
        final DeferRable dr = new DeferRable();
        final InputStream is = inIS;
        if (origURL != null) {
            errCode = "url.format.unreadable";
            errParam = new Object[]{"TIFF", origURL};
        } else {
            errCode = "stream.format.unreadable";
            errParam = new Object[]{"TIFF"};
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                Filter filt;
                try {
                    TIFFDecodeParam param = new TIFFDecodeParam();
                    SeekableStream ss = SeekableStream.wrapInputStream(is, true);
                    AbstractRed cr = new TIFFImage(ss, param, 0);
                    cr = new Any2sRGBRed(cr);
                    filt = new RedRable(cr);
                }
                catch (IOException ioe) {
                    filt = ImageTagRegistry.getBrokenLinkImage(TIFFRegistryEntry.this, errCode, errParam);
                }
                catch (ThreadDeath td) {
                    Filter filt2 = ImageTagRegistry.getBrokenLinkImage(TIFFRegistryEntry.this, errCode, errParam);
                    dr.setSource(filt2);
                    throw td;
                }
                catch (Throwable t) {
                    filt = ImageTagRegistry.getBrokenLinkImage(TIFFRegistryEntry.this, errCode, errParam);
                }
                dr.setSource(filt);
            }
        };
        t.start();
        return dr;
    }
}

