/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.batik.gvt.Messages;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGCanvasHandler;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.svg.JSVGRenderingAccuracyTest;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGTextContentElement;

public class TextSelectionTest
extends JSVGRenderingAccuracyTest {
    public static final String REFERENCE_DIR = "test-references/org/apache/batik/gvt/";
    public static final String VARIATION_DIR = "variation/";
    public static final String CANDIDATE_DIR = "candidate/";
    public static final String ERROR_READING_SVG = "TextSelectionTest.error.reading.svg";
    public static final String ERROR_BAD_ID = "TextSelectionTest.error.bad.id";
    public static final String ERROR_ID_NOT_TEXT = "TextSelectionTest.error.id.not.text";
    public static final String ERROR_GETTING_SELECTION = "TextSelectionTest.error.getting.selection";
    public static final String ERROR_CANNOT_READ_REF_URL = "TextSelectionTest.error.cannot.read.ref.url";
    public static final String ERROR_WRONG_RESULT = "TextSelectionTest.error.wrong.result";
    public static final String ERROR_NO_REFERENCE = "TextSelectionTest.error.no.reference";
    public static final String ENTRY_KEY_ERROR_DESCRIPTION = "TextSelectionTest.entry.key.error.description";
    protected String textID = null;
    protected int start;
    protected int end;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public TextSelectionTest(String file, String textID, Integer start, Integer end) {
        this.textID = textID;
        this.start = start;
        this.end = end;
        super.setFile(file);
    }

    @Override
    protected String buildRefImgURL(String svgDir, String svgFile) {
        return String.valueOf(this.getRefImagePrefix()) + svgDir + this.getRefImageSuffix() + svgFile + '-' + this.textID + '-' + this.start + '-' + this.end + ".png";
    }

    public String buildVariationURL(String svgDir, String svgFile) {
        return String.valueOf(this.getVariationPrefix()) + svgDir + this.getVariationSuffix() + svgFile + '-' + this.textID + '-' + this.start + '-' + this.end + ".png";
    }

    @Override
    public String buildSaveVariationFile(String svgDir, String svgFile) {
        return String.valueOf(this.getSaveVariationPrefix()) + svgDir + this.getSaveVariationSuffix() + svgFile + '-' + this.textID + '-' + this.start + '-' + this.end + ".png";
    }

    @Override
    public String buildCandidateReferenceFile(String svgDir, String svgFile) {
        return String.valueOf(this.getCandidateReferencePrefix()) + svgDir + this.getCandidateReferenceSuffix() + svgFile + '-' + this.textID + '-' + this.start + '-' + this.end + ".png";
    }

    @Override
    public String getName() {
        return String.valueOf(super.getName()) + '#' + this.textID + '(' + this.start + ',' + this.end + ')';
    }

    @Override
    public JSVGCanvasHandler createCanvasHandler() {
        return new JSVGCanvasHandler(this, this){

            @Override
            public JSVGCanvas createCanvas() {
                JSVGCanvas ret = new JSVGCanvas();
                ret.setDocumentState(1);
                return ret;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void canvasRendered(JSVGCanvas canvas) {
        DefaultTestReport report = new DefaultTestReport(this);
        try {
            Element e = canvas.getSVGDocument().getElementById(this.textID);
            if (e == null) {
                report.setErrorCode(ERROR_BAD_ID);
                report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), Messages.formatMessage(ERROR_BAD_ID, new String[]{this.textID}))});
                report.setPassed(false);
                this.failReport = report;
                return;
            }
            try {
                if (!(e instanceof SVGTextContentElement)) {
                    report.setErrorCode(ERROR_ID_NOT_TEXT);
                    report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), Messages.formatMessage(ERROR_ID_NOT_TEXT, new String[]{this.id, e.toString()}))});
                    report.setPassed(false);
                    this.failReport = report;
                    return;
                }
                SVGTextContentElement tce = (SVGTextContentElement)e;
                tce.selectSubString(this.start, this.end);
                return;
            }
            catch (Exception e2) {
                StringWriter trace = new StringWriter();
                e2.printStackTrace(new PrintWriter(trace));
                report.setErrorCode(ERROR_GETTING_SELECTION);
                report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), Messages.formatMessage(ERROR_GETTING_SELECTION, new String[]{this.id, String.valueOf(this.start), String.valueOf(this.end), trace.toString()}))});
                report.setPassed(false);
                this.failReport = report;
            }
            return;
        }
        finally {
            this.scriptDone();
        }
    }
}

