/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;

public class ArabicTextHandler {
    private static final int arabicStart = 1536;
    private static final int arabicEnd = 1791;
    private static final AttributedCharacterIterator.Attribute ARABIC_FORM = GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM;
    private static final Integer ARABIC_NONE = GVTAttributedCharacterIterator.TextAttribute.ARABIC_NONE;
    private static final Integer ARABIC_ISOLATED = GVTAttributedCharacterIterator.TextAttribute.ARABIC_ISOLATED;
    private static final Integer ARABIC_TERMINAL = GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL;
    private static final Integer ARABIC_INITIAL = GVTAttributedCharacterIterator.TextAttribute.ARABIC_INITIAL;
    private static final Integer ARABIC_MEDIAL = GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL;
    static int singleCharFirst = 1569;
    static int singleCharLast = 1610;
    static int[][] singleCharRemappings;
    static int doubleCharFirst;
    static int doubleCharLast;
    static int[][][] doubleCharRemappings;

    static {
        int[][] nArrayArray = new int[42][];
        nArrayArray[0] = new int[]{65152, -1, -1, -1};
        nArrayArray[1] = new int[]{65153, 65154, -1, -1};
        nArrayArray[2] = new int[]{65155, 65156, -1, -1};
        nArrayArray[3] = new int[]{65157, 65158, -1, -1};
        nArrayArray[4] = new int[]{65159, 65160, -1, -1};
        nArrayArray[5] = new int[]{65161, 65162, 65163, 65164};
        nArrayArray[6] = new int[]{65165, 65166, -1, -1};
        nArrayArray[7] = new int[]{65167, 65168, 65169, 65170};
        nArrayArray[8] = new int[]{65171, 65172, -1, -1};
        nArrayArray[9] = new int[]{65173, 65174, 65175, 65176};
        nArrayArray[10] = new int[]{65177, 65178, 65179, 65180};
        nArrayArray[11] = new int[]{65181, 65182, 65183, 65184};
        nArrayArray[12] = new int[]{65185, 65186, 65187, 65188};
        nArrayArray[13] = new int[]{65189, 65190, 65191, 65192};
        nArrayArray[14] = new int[]{65193, 65194, -1, -1};
        nArrayArray[15] = new int[]{65195, 65196, -1, -1};
        nArrayArray[16] = new int[]{65197, 65198, -1, -1};
        nArrayArray[17] = new int[]{65199, 65200, -1, -1};
        nArrayArray[18] = new int[]{65201, 65202, 65203, 65204};
        nArrayArray[19] = new int[]{65205, 65206, 65207, 65208};
        nArrayArray[20] = new int[]{65209, 65210, 65211, 65212};
        nArrayArray[21] = new int[]{65213, 65214, 65215, 65216};
        nArrayArray[22] = new int[]{65217, 65218, 65219, 65220};
        nArrayArray[23] = new int[]{65221, 65222, 65223, 65224};
        nArrayArray[24] = new int[]{65225, 65226, 65227, 65228};
        nArrayArray[25] = new int[]{65229, 65230, 65231, 65232};
        nArrayArray[32] = new int[]{65233, 65234, 65235, 65236};
        nArrayArray[33] = new int[]{65237, 65238, 65239, 65240};
        nArrayArray[34] = new int[]{65241, 65242, 65243, 65244};
        nArrayArray[35] = new int[]{65245, 65246, 65247, 65248};
        nArrayArray[36] = new int[]{65249, 65250, 65251, 65252};
        nArrayArray[37] = new int[]{65253, 65254, 65255, 65256};
        nArrayArray[38] = new int[]{65257, 65258, 65259, 65260};
        nArrayArray[39] = new int[]{65261, 65262, -1, -1};
        nArrayArray[40] = new int[]{65263, 65264, -1, -1};
        nArrayArray[41] = new int[]{65265, 65266, 65267, 65268};
        singleCharRemappings = nArrayArray;
        doubleCharFirst = 1570;
        doubleCharLast = 1618;
        int[][][] nArrayArray2 = new int[43][][];
        nArrayArray2[0] = new int[][]{{1604, 65269, 65270, -1, -1}};
        nArrayArray2[1] = new int[][]{{1604, 65271, 65272, -1, -1}};
        nArrayArray2[3] = new int[][]{{1604, 65273, 65274, -1, -1}};
        nArrayArray2[5] = new int[][]{{1604, 65275, 65276, -1, -1}};
        nArrayArray2[35] = new int[][]{{32, 65136, -1, -1, -1}, {1600, -1, -1, -1, 65137}};
        nArrayArray2[36] = new int[][]{{32, 65138, -1, -1, -1}};
        nArrayArray2[37] = new int[][]{{32, 65140, -1, -1, -1}};
        nArrayArray2[38] = new int[][]{{32, 65142, -1, -1, -1}, {1600, -1, -1, -1, 65143}};
        nArrayArray2[39] = new int[][]{{32, 65144, -1, -1, -1}, {1600, -1, -1, -1, 65145}};
        nArrayArray2[40] = new int[][]{{32, 65146, -1, -1, -1}, {1600, -1, -1, -1, 65147}};
        nArrayArray2[41] = new int[][]{{32, 65148, -1, -1, -1}, {1600, -1, -1, -1, 65149}};
        nArrayArray2[42] = new int[][]{{32, 65150, -1, -1, -1}, {1600, -1, -1, -1, 65151}};
        doubleCharRemappings = nArrayArray2;
    }

    private ArabicTextHandler() {
    }

    public static AttributedString assignArabicForms(AttributedString as) {
        int i;
        char c;
        if (!ArabicTextHandler.containsArabic(as)) {
            return as;
        }
        AttributedCharacterIterator aci = as.getIterator();
        int numChars = aci.getEndIndex() - aci.getBeginIndex();
        int[] charOrder = null;
        if (numChars >= 3) {
            char prevChar = aci.first();
            c = aci.next();
            i = 1;
            char nextChar = aci.next();
            while (nextChar != '\uffff') {
                if (ArabicTextHandler.arabicCharTransparent(c) && ArabicTextHandler.hasSubstitute(prevChar, nextChar)) {
                    if (charOrder == null) {
                        charOrder = new int[numChars];
                        int j = 0;
                        while (j < numChars) {
                            charOrder[j] = j + aci.getBeginIndex();
                            ++j;
                        }
                    }
                    int temp = charOrder[i];
                    charOrder[i] = charOrder[i - 1];
                    charOrder[i - 1] = temp;
                }
                prevChar = c;
                c = nextChar;
                nextChar = aci.next();
                ++i;
            }
        }
        if (charOrder != null) {
            StringBuffer reorderedString = new StringBuffer(numChars);
            i = 0;
            while (i < numChars) {
                c = aci.setIndex((int)charOrder[i]);
                reorderedString.append(c);
                ++i;
            }
            AttributedString reorderedAS = new AttributedString(reorderedString.toString());
            int i2 = 0;
            while (i2 < numChars) {
                aci.setIndex(charOrder[i2]);
                Map<AttributedCharacterIterator.Attribute, Object> attributes = aci.getAttributes();
                reorderedAS.addAttributes(attributes, i2, i2 + 1);
                ++i2;
            }
            if (charOrder[0] != aci.getBeginIndex()) {
                aci.setIndex(charOrder[0]);
                Float x = (Float)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.X);
                Float y = (Float)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.Y);
                if (x != null && !x.isNaN()) {
                    reorderedAS.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, new Float(Float.NaN), charOrder[0], charOrder[0] + 1);
                    reorderedAS.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, x, 0, 1);
                }
                if (y != null && !y.isNaN()) {
                    reorderedAS.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, new Float(Float.NaN), charOrder[0], charOrder[0] + 1);
                    reorderedAS.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, y, 0, 1);
                }
            }
            as = reorderedAS;
        }
        aci = as.getIterator();
        int runStart = -1;
        int idx = aci.getBeginIndex();
        char c2 = aci.first();
        while (c2 != '\uffff') {
            if (c2 >= '\u0600' && c2 <= '\u06ff') {
                if (runStart == -1) {
                    runStart = idx;
                }
            } else if (runStart != -1) {
                as.addAttribute(ARABIC_FORM, ARABIC_NONE, runStart, idx);
                runStart = -1;
            }
            c2 = aci.next();
            ++idx;
        }
        if (runStart != -1) {
            as.addAttribute(ARABIC_FORM, ARABIC_NONE, runStart, idx);
        }
        aci = as.getIterator();
        int end = aci.getBeginIndex();
        Integer currentForm = ARABIC_NONE;
        block5: while (aci.setIndex(end) != '\uffff') {
            int start = aci.getRunStart(ARABIC_FORM);
            end = aci.getRunLimit(ARABIC_FORM);
            char currentChar = aci.setIndex(start);
            currentForm = (Integer)aci.getAttribute(ARABIC_FORM);
            if (currentForm == null) continue;
            int currentIndex = start;
            int prevCharIndex = start - 1;
            while (currentIndex < end) {
                char prevChar = currentChar;
                currentChar = aci.setIndex(currentIndex);
                while (ArabicTextHandler.arabicCharTransparent(currentChar) && currentIndex < end) {
                    currentChar = aci.setIndex(++currentIndex);
                }
                if (currentIndex >= end) continue block5;
                Integer prevForm = currentForm;
                currentForm = ARABIC_NONE;
                if (prevCharIndex >= start) {
                    if (ArabicTextHandler.arabicCharShapesRight(prevChar) && ArabicTextHandler.arabicCharShapesLeft(currentChar)) {
                        prevForm = new Integer(prevForm + 1);
                        as.addAttribute(ARABIC_FORM, prevForm, prevCharIndex, prevCharIndex + 1);
                        currentForm = ARABIC_INITIAL;
                    } else if (ArabicTextHandler.arabicCharShaped(currentChar)) {
                        currentForm = ARABIC_ISOLATED;
                    }
                } else if (ArabicTextHandler.arabicCharShaped(currentChar)) {
                    currentForm = ARABIC_ISOLATED;
                }
                if (currentForm != ARABIC_NONE) {
                    as.addAttribute(ARABIC_FORM, currentForm, currentIndex, currentIndex + 1);
                }
                prevCharIndex = currentIndex++;
            }
        }
        return as;
    }

    public static boolean arabicChar(char c) {
        return c >= '\u0600' && c <= '\u06ff';
    }

    public static boolean containsArabic(AttributedString as) {
        return ArabicTextHandler.containsArabic(as.getIterator());
    }

    public static boolean containsArabic(AttributedCharacterIterator aci) {
        char c = aci.first();
        while (c != '\uffff') {
            if (ArabicTextHandler.arabicChar(c)) {
                return true;
            }
            c = aci.next();
        }
        return false;
    }

    public static boolean arabicCharTransparent(char c) {
        char charVal = c;
        if (charVal < '\u064b' || charVal > '\u06ed') {
            return false;
        }
        return charVal <= '\u0655' || charVal == '\u0670' || charVal >= '\u06d6' && charVal <= '\u06e4' || charVal >= '\u06e7' && charVal <= '\u06e8' || charVal >= '\u06ea';
    }

    private static boolean arabicCharShapesRight(char c) {
        char charVal = c;
        return charVal >= '\u0622' && charVal <= '\u0625' || charVal == '\u0627' || charVal == '\u0629' || charVal >= '\u062f' && charVal <= '\u0632' || charVal == '\u0648' || charVal >= '\u0671' && charVal <= '\u0673' || charVal >= '\u0675' && charVal <= '\u0677' || charVal >= '\u0688' && charVal <= '\u0699' || charVal == '\u06c0' || charVal >= '\u06c2' && charVal <= '\u06cb' || charVal == '\u06cd' || charVal == '\u06cf' || charVal >= '\u06d2' && charVal <= '\u06d3' || ArabicTextHandler.arabicCharShapesDuel(c);
    }

    private static boolean arabicCharShapesDuel(char c) {
        char charVal = c;
        return charVal == '\u0626' || charVal == '\u0628' || charVal >= '\u062a' && charVal <= '\u062e' || charVal >= '\u0633' && charVal <= '\u063a' || charVal >= '\u0641' && charVal <= '\u0647' || charVal >= '\u0649' && charVal <= '\u064a' || charVal >= '\u0678' && charVal <= '\u0687' || charVal >= '\u069a' && charVal <= '\u06bf' || charVal == '\u06c1' || charVal == '\u06cc' || charVal == '\u06ce' || charVal >= '\u06d0' && charVal <= '\u06d1' || charVal >= '\u06fa' && charVal <= '\u06fc';
    }

    private static boolean arabicCharShapesLeft(char c) {
        return ArabicTextHandler.arabicCharShapesDuel(c);
    }

    private static boolean arabicCharShaped(char c) {
        return ArabicTextHandler.arabicCharShapesRight(c);
    }

    public static boolean hasSubstitute(char ch1, char ch2) {
        if (ch1 < doubleCharFirst || ch1 > doubleCharLast) {
            return false;
        }
        int[][] remaps = doubleCharRemappings[ch1 - doubleCharFirst];
        if (remaps == null) {
            return false;
        }
        int i = 0;
        while (i < remaps.length) {
            if (remaps[i][0] == ch2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int getSubstituteChar(char ch1, char ch2, int form) {
        if (form == 0) {
            return -1;
        }
        if (ch1 < doubleCharFirst || ch1 > doubleCharLast) {
            return -1;
        }
        int[][] remaps = doubleCharRemappings[ch1 - doubleCharFirst];
        if (remaps == null) {
            return -1;
        }
        int i = 0;
        while (i < remaps.length) {
            if (remaps[i][0] == ch2) {
                return remaps[i][form];
            }
            ++i;
        }
        return -1;
    }

    public static int getSubstituteChar(char ch, int form) {
        if (form == 0) {
            return -1;
        }
        if (ch < singleCharFirst || ch > singleCharLast) {
            return -1;
        }
        int[] chars = singleCharRemappings[ch - singleCharFirst];
        if (chars == null) {
            return -1;
        }
        return chars[form - 1];
    }

    /*
     * Unable to fully structure code
     */
    public static String createSubstituteString(AttributedCharacterIterator aci) {
        start = aci.getBeginIndex();
        end = aci.getEndIndex();
        numChar = end - start;
        substString = new StringBuffer(numChar);
        i = start;
        while (i < end) {
            block5: {
                block7: {
                    block6: {
                        block4: {
                            c = aci.setIndex(i);
                            if (ArabicTextHandler.arabicChar(c)) break block4;
                            substString.append(c);
                            break block5;
                        }
                        form = (Integer)aci.getAttribute(ArabicTextHandler.ARABIC_FORM);
                        if (!ArabicTextHandler.charStartsLigature(c) || i + 1 >= end) ** GOTO lbl-1000
                        nextChar = aci.setIndex(i + 1);
                        nextForm = (Integer)aci.getAttribute(ArabicTextHandler.ARABIC_FORM);
                        if (form == null || nextForm == null) ** GOTO lbl-1000
                        if (!form.equals(ArabicTextHandler.ARABIC_TERMINAL) || !nextForm.equals(ArabicTextHandler.ARABIC_INITIAL)) break block6;
                        substChar = ArabicTextHandler.getSubstituteChar(c, nextChar, ArabicTextHandler.ARABIC_ISOLATED);
                        if (substChar <= -1) ** GOTO lbl-1000
                        substString.append((char)substChar);
                        ++i;
                        break block5;
                    }
                    if (!form.equals(ArabicTextHandler.ARABIC_TERMINAL)) break block7;
                    substChar = ArabicTextHandler.getSubstituteChar(c, nextChar, ArabicTextHandler.ARABIC_TERMINAL);
                    if (substChar <= -1) ** GOTO lbl-1000
                    substString.append((char)substChar);
                    ++i;
                    break block5;
                }
                if (form.equals(ArabicTextHandler.ARABIC_MEDIAL) && nextForm.equals(ArabicTextHandler.ARABIC_MEDIAL) && (substChar = ArabicTextHandler.getSubstituteChar(c, nextChar, ArabicTextHandler.ARABIC_MEDIAL)) > -1) {
                    substString.append((char)substChar);
                    ++i;
                } else lbl-1000:
                // 5 sources

                {
                    if (form != null && form > 0 && (substChar = ArabicTextHandler.getSubstituteChar(c, form)) > -1) {
                        c = (char)substChar;
                    }
                    substString.append(c);
                }
            }
            ++i;
        }
        return substString.toString();
    }

    public static boolean charStartsLigature(char c) {
        char charVal = c;
        return charVal == '\u064b' || charVal == '\u064c' || charVal == '\u064d' || charVal == '\u064e' || charVal == '\u064f' || charVal == '\u0650' || charVal == '\u0651' || charVal == '\u0652' || charVal == '\u0622' || charVal == '\u0623' || charVal == '\u0625' || charVal == '\u0627';
    }

    public static int getNumChars(char c) {
        if (ArabicTextHandler.isLigature(c)) {
            return 2;
        }
        return 1;
    }

    public static boolean isLigature(char c) {
        char charVal = c;
        if (charVal < '\ufe70' || charVal > '\ufefc') {
            return false;
        }
        return charVal <= '\ufe72' || charVal == '\ufe74' || charVal >= '\ufe76' && charVal <= '\ufe7f' || charVal >= '\ufef5';
    }
}

