/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.io.StringReader;
import org.apache.batik.parser.DefaultLengthHandler;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;

public class LengthParserTest
extends AbstractTest {
    protected String sourceLength;
    protected String destinationLength;
    protected StringBuffer buffer;
    protected String resultLength;

    public LengthParserTest(String slength, String dlength) {
        this.sourceLength = slength;
        this.destinationLength = dlength;
    }

    @Override
    public TestReport runImpl() throws Exception {
        LengthParser pp = new LengthParser();
        pp.setLengthHandler(new TestHandler());
        try {
            pp.parse(new StringReader(this.sourceLength));
        }
        catch (ParseException e) {
            DefaultTestReport report = new DefaultTestReport(this);
            report.setErrorCode("parse.error");
            report.addDescriptionEntry("exception.text", e.getMessage());
            report.setPassed(false);
            return report;
        }
        if (!this.destinationLength.equals(this.resultLength)) {
            DefaultTestReport report = new DefaultTestReport(this);
            report.setErrorCode("invalid.parsing.events");
            report.addDescriptionEntry("expected.text", this.destinationLength);
            report.addDescriptionEntry("generated.text", this.resultLength);
            report.setPassed(false);
            return report;
        }
        return this.reportSuccess();
    }

    class TestHandler
    extends DefaultLengthHandler {
        @Override
        public void startLength() throws ParseException {
            LengthParserTest.this.buffer = new StringBuffer();
        }

        @Override
        public void lengthValue(float v) throws ParseException {
            LengthParserTest.this.buffer.append(v);
        }

        @Override
        public void em() throws ParseException {
            LengthParserTest.this.buffer.append("em");
        }

        @Override
        public void ex() throws ParseException {
            LengthParserTest.this.buffer.append("ex");
        }

        @Override
        public void in() throws ParseException {
            LengthParserTest.this.buffer.append("in");
        }

        @Override
        public void cm() throws ParseException {
            LengthParserTest.this.buffer.append("cm");
        }

        @Override
        public void mm() throws ParseException {
            LengthParserTest.this.buffer.append("mm");
        }

        @Override
        public void pc() throws ParseException {
            LengthParserTest.this.buffer.append("pc");
        }

        @Override
        public void pt() throws ParseException {
            LengthParserTest.this.buffer.append("pt");
        }

        @Override
        public void px() throws ParseException {
            LengthParserTest.this.buffer.append("px");
        }

        @Override
        public void percentage() throws ParseException {
            LengthParserTest.this.buffer.append("%");
        }

        @Override
        public void endLength() throws ParseException {
            LengthParserTest.this.resultLength = LengthParserTest.this.buffer.toString();
        }
    }
}

