/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.io.StringReader;
import org.apache.batik.parser.DefaultTransformListHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.TransformListParser;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;

public class TransformListParserTest
extends AbstractTest {
    protected String sourceTransform;
    protected String destinationTransform;
    protected StringBuffer buffer;
    protected String resultTransform;

    public TransformListParserTest(String stransform, String dtransform) {
        this.sourceTransform = stransform;
        this.destinationTransform = dtransform;
    }

    @Override
    public TestReport runImpl() throws Exception {
        TransformListParser pp = new TransformListParser();
        pp.setTransformListHandler(new TestHandler());
        try {
            pp.parse(new StringReader(this.sourceTransform));
        }
        catch (ParseException e) {
            DefaultTestReport report = new DefaultTestReport(this);
            report.setErrorCode("parse.error");
            report.addDescriptionEntry("exception.text", e.getMessage());
            report.setPassed(false);
            return report;
        }
        if (!this.destinationTransform.equals(this.resultTransform)) {
            DefaultTestReport report = new DefaultTestReport(this);
            report.setErrorCode("invalid.parsing.events");
            report.addDescriptionEntry("expected.text", this.destinationTransform);
            report.addDescriptionEntry("generated.text", this.resultTransform);
            report.setPassed(false);
            return report;
        }
        return this.reportSuccess();
    }

    class TestHandler
    extends DefaultTransformListHandler {
        boolean first;

        @Override
        public void startTransformList() throws ParseException {
            TransformListParserTest.this.buffer = new StringBuffer();
            this.first = true;
        }

        @Override
        public void matrix(float a, float b, float c, float d, float e, float f) throws ParseException {
            if (!this.first) {
                TransformListParserTest.this.buffer.append(' ');
            }
            this.first = false;
            TransformListParserTest.this.buffer.append("matrix(");
            TransformListParserTest.this.buffer.append(a);
            TransformListParserTest.this.buffer.append(", ");
            TransformListParserTest.this.buffer.append(b);
            TransformListParserTest.this.buffer.append(", ");
            TransformListParserTest.this.buffer.append(c);
            TransformListParserTest.this.buffer.append(", ");
            TransformListParserTest.this.buffer.append(d);
            TransformListParserTest.this.buffer.append(", ");
            TransformListParserTest.this.buffer.append(e);
            TransformListParserTest.this.buffer.append(", ");
            TransformListParserTest.this.buffer.append(f);
            TransformListParserTest.this.buffer.append(")");
        }

        @Override
        public void rotate(float theta) throws ParseException {
            if (!this.first) {
                TransformListParserTest.this.buffer.append(' ');
            }
            this.first = false;
        }

        @Override
        public void rotate(float theta, float cx, float cy) throws ParseException {
            if (!this.first) {
                TransformListParserTest.this.buffer.append(' ');
            }
            this.first = false;
        }

        @Override
        public void translate(float tx) throws ParseException {
            if (!this.first) {
                TransformListParserTest.this.buffer.append(' ');
            }
            this.first = false;
            TransformListParserTest.this.buffer.append("translate(");
            TransformListParserTest.this.buffer.append(tx);
            TransformListParserTest.this.buffer.append(")");
        }

        @Override
        public void translate(float tx, float ty) throws ParseException {
            if (!this.first) {
                TransformListParserTest.this.buffer.append(' ');
            }
            this.first = false;
            TransformListParserTest.this.buffer.append("translate(");
            TransformListParserTest.this.buffer.append(tx);
            TransformListParserTest.this.buffer.append(", ");
            TransformListParserTest.this.buffer.append(ty);
            TransformListParserTest.this.buffer.append(")");
        }

        @Override
        public void scale(float sx) throws ParseException {
            if (!this.first) {
                TransformListParserTest.this.buffer.append(' ');
            }
            this.first = false;
            TransformListParserTest.this.buffer.append("scale(");
            TransformListParserTest.this.buffer.append(sx);
            TransformListParserTest.this.buffer.append(")");
        }

        @Override
        public void scale(float sx, float sy) throws ParseException {
            if (!this.first) {
                TransformListParserTest.this.buffer.append(' ');
            }
            this.first = false;
            TransformListParserTest.this.buffer.append("scale(");
            TransformListParserTest.this.buffer.append(sx);
            TransformListParserTest.this.buffer.append(", ");
            TransformListParserTest.this.buffer.append(sy);
            TransformListParserTest.this.buffer.append(")");
        }

        @Override
        public void skewX(float skx) throws ParseException {
            if (!this.first) {
                TransformListParserTest.this.buffer.append(' ');
            }
            this.first = false;
            TransformListParserTest.this.buffer.append("skewX(");
            TransformListParserTest.this.buffer.append(skx);
            TransformListParserTest.this.buffer.append(")");
        }

        @Override
        public void skewY(float sky) throws ParseException {
            if (!this.first) {
                TransformListParserTest.this.buffer.append(' ');
            }
            this.first = false;
            TransformListParserTest.this.buffer.append("skewY(");
            TransformListParserTest.this.buffer.append(sky);
            TransformListParserTest.this.buffer.append(")");
        }

        @Override
        public void endTransformList() throws ParseException {
            TransformListParserTest.this.resultTransform = TransformListParserTest.this.buffer.toString();
        }
    }
}

