/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.NoLoadScriptSecurity;
import org.apache.batik.bridge.RelaxedScriptSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.svg.SelfContainedSVGOnLoadTest;
import org.apache.batik.util.ApplicationSecurityEnforcer;
import org.apache.batik.util.ParsedURL;

public class ScriptSelfTest
extends SelfContainedSVGOnLoadTest {
    boolean secure = true;
    boolean constrain = true;
    String scripts = "text/ecmascript, application/java-archive";
    TestUserAgent userAgent = new TestUserAgent();

    @Override
    public void setId(String id) {
        super.setId(id);
        this.svgURL = this.resolveURL("test-resources/org/apache/batik/" + id + ".svg");
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public Boolean getSecure() {
        return this.secure ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setConstrain(Boolean constrain) {
        this.constrain = constrain;
    }

    public Boolean getConstrain() {
        return this.constrain ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setScripts(String scripts) {
        this.scripts = scripts;
    }

    public String getScripts() {
        return this.scripts;
    }

    @Override
    public TestReport runImpl() throws Exception {
        ApplicationSecurityEnforcer ase = new ApplicationSecurityEnforcer(this.getClass(), "org/apache/batik/apps/svgbrowser/resources/svgbrowser.policy");
        if (this.secure) {
            ase.enforceSecurity(true);
        }
        try {
            TestReport testReport = super.runImpl();
            return testReport;
        }
        finally {
            ase.enforceSecurity(false);
        }
    }

    @Override
    protected UserAgent buildUserAgent() {
        return this.userAgent;
    }

    class TestUserAgent
    extends UserAgentAdapter {
        TestUserAgent() {
        }

        @Override
        public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptPURL, ParsedURL docPURL) {
            if (ScriptSelfTest.this.scripts.indexOf(scriptType) == -1) {
                return new NoLoadScriptSecurity(scriptType);
            }
            if (ScriptSelfTest.this.constrain) {
                return new DefaultScriptSecurity(scriptType, scriptPURL, docPURL);
            }
            return new RelaxedScriptSecurity(scriptType, scriptPURL, docPURL);
        }
    }
}

