/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import org.apache.batik.svggen.Painter;

public class Clip
implements Painter {
    @Override
    public void paint(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape clipShape = g.getClip();
        AffineTransform transform = g.getTransform();
        g.setPaint(Color.black);
        Dimension size = new Dimension(300, 400);
        int w = 100;
        int h = 50;
        int vOffset = h + 20;
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics2D gi = image.createGraphics();
        gi.setPaint(Color.white);
        gi.fillRect(0, 0, 100, 50);
        gi.setPaint(Color.green);
        gi.fillRect(0, 0, 50, 25);
        gi.setPaint(Color.black);
        gi.fillRect(50, 0, 50, 25);
        gi.setPaint(Color.red);
        gi.fillRect(50, 25, 50, 25);
        gi.dispose();
        g.clipRect(0, 0, size.width, size.height);
        g.drawImage((Image)image, 0, 0, null);
        g.setClip(clipShape);
        g.drawString("Clip set to device bounds", 110, 25);
        g.translate(0, vOffset);
        g.drawString("Clip set to upper right quarter", 110, 25);
        g.clipRect(w / 2, 0, w / 2, h / 2);
        g.drawImage((Image)image, 0, 0, null);
        g.setTransform(transform);
        g.setClip(clipShape);
        g.translate(0, 2 * vOffset);
        g.drawString("Clip set to upper right quarter", 110, 15);
        g.drawString("after .5 scale", 110, 30);
        g.scale(0.5, 0.5);
        g.clipRect(w / 2, 0, w / 2, h / 2);
        g.drawImage((Image)image, 0, 0, null);
        g.setTransform(transform);
        g.setClip(clipShape);
        g.translate(0, 3 * vOffset);
        g.drawString("Non-Rectagular clip", 110, 25);
        Ellipse2D.Float circle = new Ellipse2D.Float(0.0f, 0.0f, w, h);
        g.clip(circle);
        g.drawImage((Image)image, 0, 0, null);
        g.setTransform(transform);
        g.setClip(clipShape);
        g.translate(0, 4 * vOffset);
        g.drawString("Non-Rectagular clip after", 110, 15);
        g.drawString(".5 scale", 110, 30);
        g.scale(0.5, 0.5);
        g.clip(circle);
        g.drawImage((Image)image, 0, 0, null);
        g.setTransform(transform);
        g.setClip(clipShape);
        g.translate(0, 5 * vOffset);
        g.drawString("Non-Rectagular clip before", 110, 15);
        g.drawString(".5 scale", 110, 30);
        g.clip(circle);
        g.scale(0.5, 0.5);
        g.drawImage((Image)image, 0, 0, null);
    }
}

