/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Font;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.CachedImageHandlerBase64Encoder;
import org.apache.batik.svggen.DefaultStyleHandler;
import org.apache.batik.svggen.Painter;
import org.apache.batik.svggen.SVGAccuracyTest;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GeneratorContext
extends SVGAccuracyTest
implements SVGConstants {
    private Element topLevelGroup = null;

    public GeneratorContext(Painter painter, URL refURL) {
        super(painter, refURL);
    }

    @Override
    protected SVGGraphics2D buildSVGGraphics2D() {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String namespaceURI = "http://www.w3.org/2000/svg";
        Document domFactory = impl.createDocument(namespaceURI, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault(domFactory);
        ctx.setIDGenerator(new TestIDGenerator());
        CachedImageHandlerBase64Encoder ihandler = new CachedImageHandlerBase64Encoder();
        ctx.setGenericImageHandler(ihandler);
        CDATASection styleSheet = domFactory.createCDATASection("");
        ctx.setStyleHandler(new TestStyleHandler(styleSheet));
        ctx.setComment("Generated by the Batik Test Framework. Test:\u00e9j");
        ctx.setEmbeddedFontsOn(true);
        SVGGeneratorContext.GraphicContextDefaults defaults = new SVGGeneratorContext.GraphicContextDefaults();
        defaults.font = new Font("Arial", 0, 12);
        ctx.setGraphicContextDefaults(defaults);
        SVGGraphics2D g2d = new SVGGraphics2D(ctx, false);
        this.topLevelGroup = g2d.getTopLevelGroup();
        Element style = domFactory.createElementNS("http://www.w3.org/2000/svg", "style");
        style.setAttributeNS(null, "type", "text/css");
        style.appendChild(styleSheet);
        this.topLevelGroup.appendChild(style);
        return g2d;
    }

    @Override
    protected void configureSVGGraphics2D(SVGGraphics2D g2d) {
        this.topLevelGroup.appendChild(g2d.getTopLevelGroup());
        g2d.setTopLevelGroup(this.topLevelGroup);
    }

    public static class TestIDGenerator
    extends SVGIDGenerator {
        @Override
        public String generateID(String prefix) {
            return "test" + super.generateID(prefix);
        }
    }

    public static class TestStyleHandler
    extends DefaultStyleHandler {
        private CDATASection styleSheet;

        public TestStyleHandler(CDATASection styleSheet) {
            this.styleSheet = styleSheet;
        }

        @Override
        public void setStyle(Element element, Map styleMap, SVGGeneratorContext generatorContext) {
            Iterator iter = styleMap.keySet().iterator();
            String id = generatorContext.getIDGenerator().generateID("C");
            this.styleSheet.appendData("." + id + " {");
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)styleMap.get(key);
                this.styleSheet.appendData(String.valueOf(key) + ":" + value + ";");
            }
            this.styleSheet.appendData("}\n");
            element.setAttribute("class", id);
        }
    }
}

