/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.svggen.AbstractImageHandlerEncoder;
import org.apache.batik.svggen.SVGGraphics2DIOException;

public class ImageHandlerPNGEncoder
extends AbstractImageHandlerEncoder {
    public ImageHandlerPNGEncoder(String imageDir, String urlRoot) throws SVGGraphics2DIOException {
        super(imageDir, urlRoot);
    }

    @Override
    public final String getSuffix() {
        return ".png";
    }

    @Override
    public final String getPrefix() {
        return "pngImage";
    }

    @Override
    public void encodeImage(BufferedImage buf, File imageFile) throws SVGGraphics2DIOException {
        try (FileOutputStream os = new FileOutputStream(imageFile);){
            ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
            writer.writeImage(buf, os);
        }
        catch (IOException e) {
            throw new SVGGraphics2DIOException("could not write image File " + imageFile.getName());
        }
    }

    @Override
    public BufferedImage buildBufferedImage(Dimension size) {
        return new BufferedImage(size.width, size.height, 2);
    }
}

