/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.net.URL;
import org.apache.batik.svggen.Painter;
import org.apache.batik.svggen.SVGAccuracyTest;
import org.apache.batik.test.DefaultTestSuite;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.TestReportValidator;

public class SVGAccuracyTestValidator
extends DefaultTestSuite {
    public SVGAccuracyTestValidator() {
        this.addTest(new NullPainter());
        this.addTest(new PainterWithException());
        this.addTest(new NullReferenceURL());
        this.addTest(new InexistantReferenceURL());
        this.addTest(new DiffWithReferenceImage());
        this.addTest(new SameAsReferenceImage());
    }

    static class DiffWithReferenceImage
    extends ValidPainterTest {
        DiffWithReferenceImage() {
        }

        @Override
        public TestReport runImpl() throws Exception {
            File tmpFile = File.createTempFile("EmptySVGReference", null);
            tmpFile.deleteOnExit();
            SVGAccuracyTest t = new SVGAccuracyTest(this, tmpFile.toURL());
            this.setConfig(t, false, "SVGAccuracyTest.error.generated.svg.inaccurate");
            return super.runImpl();
        }
    }

    static class InexistantReferenceURL
    extends ValidPainterTest {
        InexistantReferenceURL() {
        }

        @Override
        public TestReport runImpl() throws Exception {
            SVGAccuracyTest t = new SVGAccuracyTest(this, new URL("http", "dummyHost", "dummyFile.svg"));
            this.setConfig(t, false, "SVGAccuracyTest.error.cannot.open.reference.svg.file");
            return super.runImpl();
        }
    }

    static class NullPainter
    extends TestReportValidator {
        NullPainter() {
        }

        @Override
        public TestReport runImpl() throws Exception {
            Painter painter = null;
            URL refURL = new URL("http", "dummyHost", "dummyFile.svg");
            SVGAccuracyTest t = new SVGAccuracyTest(painter, refURL);
            this.setConfig(t, false, "SVGAccuracyTest.error.cannot.generate.svg");
            return super.runImpl();
        }
    }

    static class NullReferenceURL
    extends ValidPainterTest {
        NullReferenceURL() {
        }

        @Override
        public TestReport runImpl() throws Exception {
            SVGAccuracyTest t = new SVGAccuracyTest(this, null);
            this.setConfig(t, false, "SVGAccuracyTest.error.cannot.open.reference.svg.file");
            return super.runImpl();
        }
    }

    static class PainterWithException
    extends TestReportValidator
    implements Painter {
        PainterWithException() {
        }

        @Override
        public void paint(Graphics2D g) {
            g.setComposite(null);
            g.fillRect(0, 0, 20, 20);
        }

        @Override
        public TestReport runImpl() throws Exception {
            PainterWithException painter = this;
            URL refURL = new URL("http", "dummyHost", "dummyFile.svg");
            SVGAccuracyTest t = new SVGAccuracyTest(painter, refURL);
            this.setConfig(t, false, "SVGAccuracyTest.error.cannot.generate.svg");
            return super.runImpl();
        }
    }

    static class SameAsReferenceImage
    extends ValidPainterTest {
        SameAsReferenceImage() {
        }

        @Override
        public TestReport runImpl() throws Exception {
            File tmpFile = File.createTempFile("SVGReference", null);
            tmpFile.deleteOnExit();
            SVGAccuracyTest t = new SVGAccuracyTest(this, tmpFile.toURL());
            t.setSaveSVG(tmpFile);
            this.setConfig(t, false, "SVGAccuracyTest.error.generated.svg.inaccurate");
            super.runImpl();
            this.setConfig(t, true, null);
            return super.runImpl();
        }
    }

    static class ValidPainterTest
    extends TestReportValidator
    implements Painter {
        ValidPainterTest() {
        }

        @Override
        public void paint(Graphics2D g) {
            g.setPaint(Color.red);
            g.fillRect(0, 0, 40, 40);
        }
    }
}

