/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.io.File;
import java.net.URL;
import org.apache.batik.svggen.GeneratorContext;
import org.apache.batik.svggen.Painter;
import org.apache.batik.svggen.SVGAccuracyTest;
import org.apache.batik.test.DefaultTestSuite;
import org.apache.batik.test.Test;
import org.apache.batik.test.svg.PreconfiguredRenderingTest;
import org.apache.batik.test.svg.SVGRenderingAccuracyTest;
import org.apache.batik.test.util.ImageCompareTest;

public class SVGGeneratorTests
extends DefaultTestSuite {
    public static final String GENERATOR_REFERENCE_BASE = "test-references/org/apache/batik/svggen/";
    public static final String RENDERING_DIR = "rendering";
    public static final String ACCEPTED_VARIATION_DIR = "accepted-variation";
    public static final String[] VARIATION_PLATFORMS = PreconfiguredRenderingTest.DEFAULT_VARIATION_PLATFORMS;
    public static final String CANDIDATE_VARIATION_DIR = "candidate-variation";
    public static final String CANDIDATE_REF_DIR = "candidate-ref";
    public static final String RENDERING_CANDIDATE_REF_DIR = "candidate-reference";
    public static final String PNG_EXTENSION = ".png";
    public static final String SVG_EXTENSION = ".svg";
    public static final String PLAIN_GENERATION_PREFIX = "";
    public static final String CUSTOM_CONTEXT_GENERATION_PREFIX = "Context";

    @Override
    public void setId(String id) {
        super.setId(id);
        String clName = String.valueOf(this.getPackageName()) + "." + id;
        Class<?> cl = null;
        try {
            cl = Class.forName(clName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(clName);
        }
        Object o = null;
        try {
            o = cl.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(clName);
        }
        if (!(o instanceof Painter)) {
            throw new IllegalArgumentException(clName);
        }
        Painter painter = o;
        this.addTest(this.makeSVGAccuracyTest(painter, id));
        this.addTest(this.makeGeneratorContext(painter, id));
        this.addTest(this.makeSVGRenderingAccuracyTest(painter, id, PLAIN_GENERATION_PREFIX));
        this.addTest(this.makeSVGRenderingAccuracyTest(painter, id, CUSTOM_CONTEXT_GENERATION_PREFIX));
        this.addTest(this.makeImageCompareTest(painter, id, PLAIN_GENERATION_PREFIX, CUSTOM_CONTEXT_GENERATION_PREFIX));
    }

    @Override
    public String getName() {
        return "SVGGeneratorTest - " + this.getId();
    }

    protected String getPackageName() {
        return "org.apache.batik.svggen";
    }

    private Test makeImageCompareTest(Painter painter, String id, String prefixA, String prefixB) {
        String cl = this.getNonQualifiedClassName(painter);
        String clA = String.valueOf(prefixA) + cl;
        String clB = String.valueOf(prefixB) + cl;
        String testReferenceA = "test-references/org/apache/batik/svggen/rendering/" + clA + PNG_EXTENSION;
        String testReferenceB = "test-references/org/apache/batik/svggen/rendering/" + clB + PNG_EXTENSION;
        ImageCompareTest t = new ImageCompareTest(testReferenceA, testReferenceB);
        t.setName(String.valueOf(id) + "-RenderingComparison");
        t.setId(String.valueOf(id) + ".renderingComparison");
        return t;
    }

    private Test makeSVGRenderingAccuracyTest(Painter painter, String id, String prefix) {
        String cl = String.valueOf(prefix) + this.getNonQualifiedClassName(painter);
        String testSource = GENERATOR_REFERENCE_BASE + cl + SVG_EXTENSION;
        String testReference = "test-references/org/apache/batik/svggen/rendering/" + cl + PNG_EXTENSION;
        String[] variationURLs = new String[VARIATION_PLATFORMS.length + 1];
        variationURLs[0] = "test-references/org/apache/batik/svggen/rendering/accepted-variation/" + cl + PNG_EXTENSION;
        int i = 0;
        while (i < VARIATION_PLATFORMS.length) {
            variationURLs[i + 1] = "test-references/org/apache/batik/svggen/rendering/accepted-variation/" + cl + '_' + VARIATION_PLATFORMS[i] + PNG_EXTENSION;
            ++i;
        }
        String saveVariation = "test-references/org/apache/batik/svggen/rendering/candidate-variation/" + cl + PNG_EXTENSION;
        String candidateReference = "test-references/org/apache/batik/svggen/rendering/candidate-reference/" + cl + PNG_EXTENSION;
        SVGRenderingAccuracyTest test = new SVGRenderingAccuracyTest(testSource, testReference);
        int i2 = 0;
        while (i2 < variationURLs.length) {
            test.addVariationURL(variationURLs[i2]);
            ++i2;
        }
        test.setSaveVariation(new File(saveVariation));
        test.setCandidateReference(new File(candidateReference));
        test.setName(String.valueOf(id) + "-" + prefix + "RenderingCheck");
        test.setId(String.valueOf(id) + "." + prefix + "renderingCheck");
        return test;
    }

    private Test makeGeneratorContext(Painter painter, String id) {
        String cl = CUSTOM_CONTEXT_GENERATION_PREFIX + this.getNonQualifiedClassName(painter);
        GeneratorContext test = new GeneratorContext(painter, this.makeURL(painter, CUSTOM_CONTEXT_GENERATION_PREFIX));
        test.setSaveSVG(new File("test-references/org/apache/batik/svggen/candidate-ref/" + cl + SVG_EXTENSION));
        test.setName(String.valueOf(id) + "-ConfiguredContextGeneration");
        test.setId(String.valueOf(id) + ".configuredContextGeneration");
        return test;
    }

    private Test makeSVGAccuracyTest(Painter painter, String id) {
        String cl = this.getNonQualifiedClassName(painter);
        SVGAccuracyTest test = new SVGAccuracyTest(painter, this.makeURL(painter, PLAIN_GENERATION_PREFIX));
        test.setSaveSVG(new File("test-references/org/apache/batik/svggen/candidate-ref/" + cl + SVG_EXTENSION));
        test.setName(String.valueOf(id) + "-DefaultContextGeneration");
        test.setId(String.valueOf(id) + ".defaultContextGeneration");
        return test;
    }

    private String getNonQualifiedClassName(Painter painter) {
        String cl = painter.getClass().getName();
        int n = cl.lastIndexOf(46);
        return cl.substring(n + 1);
    }

    private URL makeURL(Painter painter, String prefix) {
        String urlString = "file:test-references/org/apache/batik/svggen/" + prefix + this.getNonQualifiedClassName(painter) + SVG_EXTENSION;
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (Exception e) {
            throw new Error(e.getMessage());
        }
        return url;
    }
}

