/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.NameRecord;
import org.apache.batik.svggen.font.table.Table;

public class NameTable
implements Table {
    private short formatSelector;
    private short numberOfNameRecords;
    private short stringStorageOffset;
    private NameRecord[] records;

    protected NameTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        raf.seek(de.getOffset());
        this.formatSelector = raf.readShort();
        this.numberOfNameRecords = raf.readShort();
        this.stringStorageOffset = raf.readShort();
        this.records = new NameRecord[this.numberOfNameRecords];
        int i = 0;
        while (i < this.numberOfNameRecords) {
            this.records[i] = new NameRecord(raf);
            ++i;
        }
        i = 0;
        while (i < this.numberOfNameRecords) {
            this.records[i].loadString(raf, de.getOffset() + this.stringStorageOffset);
            ++i;
        }
    }

    public String getRecord(short nameId) {
        int i = 0;
        while (i < this.numberOfNameRecords) {
            if (this.records[i].getNameId() == nameId) {
                return this.records[i].getRecordString();
            }
            ++i;
        }
        return "";
    }

    @Override
    public int getType() {
        return 1851878757;
    }
}

