/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Script;
import org.apache.batik.svggen.font.table.ScriptRecord;

public class ScriptList {
    private int scriptCount = 0;
    private ScriptRecord[] scriptRecords;
    private Script[] scripts;

    protected ScriptList(RandomAccessFile raf, int offset) throws IOException {
        raf.seek(offset);
        this.scriptCount = raf.readUnsignedShort();
        this.scriptRecords = new ScriptRecord[this.scriptCount];
        this.scripts = new Script[this.scriptCount];
        int i = 0;
        while (i < this.scriptCount) {
            this.scriptRecords[i] = new ScriptRecord(raf);
            ++i;
        }
        i = 0;
        while (i < this.scriptCount) {
            this.scripts[i] = new Script(raf, offset + this.scriptRecords[i].getOffset());
            ++i;
        }
    }

    public int getScriptCount() {
        return this.scriptCount;
    }

    public ScriptRecord getScriptRecord(int i) {
        return this.scriptRecords[i];
    }

    public Script findScript(String tag) {
        if (tag.length() != 4) {
            return null;
        }
        int tagVal = tag.charAt(0) << 24 | tag.charAt(1) << 16 | tag.charAt(2) << 8 | tag.charAt(3);
        int i = 0;
        while (i < this.scriptCount) {
            if (this.scriptRecords[i].getTag() == tagVal) {
                return this.scripts[i];
            }
            ++i;
        }
        return null;
    }
}

