/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing;

import java.awt.Dimension;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGCanvasHandler;
import org.apache.batik.swing.TestMessages;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.MemoryLeakTest;
import org.apache.batik.test.TestReport;
import org.w3c.dom.Element;

public class JSVGMemoryLeakTest
extends MemoryLeakTest
implements JSVGCanvasHandler.Delegate {
    TestReport failReport = null;
    boolean done;
    JSVGCanvasHandler handler;
    JFrame theFrame;
    WeakReference theCanvas;

    @Override
    public String getName() {
        return "JSVGMemoryLeakTest." + this.getId();
    }

    protected void setTheCanvas(JSVGCanvas c) {
        this.theCanvas = new WeakReference<JSVGCanvas>(c);
    }

    protected JSVGCanvas getTheCanvas() {
        return (JSVGCanvas)this.theCanvas.get();
    }

    public static String fmt(String key, Object[] args) {
        return TestMessages.formatMessage(key, args);
    }

    public JSVGCanvasHandler createHandler() {
        return new JSVGCanvasHandler(this, this);
    }

    @Override
    public TestReport doSomething() throws Exception {
        this.handler = this.createHandler();
        this.registerObjectDesc(this.handler, "Handler");
        this.done = false;
        this.handler.runCanvas(this.getId());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JSVGMemoryLeakTest.this.theFrame.remove(JSVGMemoryLeakTest.this.getTheCanvas());
                JSVGMemoryLeakTest.this.getTheCanvas().dispose();
                JSVGMemoryLeakTest.this.theFrame.dispose();
                JSVGMemoryLeakTest.this.theFrame = null;
                JSVGMemoryLeakTest.this.theCanvas = null;
            }
        });
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JSVGMemoryLeakTest.this.theFrame = new JFrame("FocusFrame");
                JSVGMemoryLeakTest.this.theFrame.setSize(new Dimension(40, 50));
                JSVGMemoryLeakTest.this.theFrame.setVisible(true);
            }
        });
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JSVGMemoryLeakTest.this.theFrame.setVisible(false);
                JSVGMemoryLeakTest.this.theFrame.dispose();
            }
        });
        this.handler = null;
        if (this.failReport != null) {
            return this.failReport;
        }
        DefaultTestReport report = new DefaultTestReport(this);
        report.setPassed(true);
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scriptDone() {
        JSVGMemoryLeakTest jSVGMemoryLeakTest = this;
        synchronized (jSVGMemoryLeakTest) {
            this.done = true;
            this.handler.scriptDone();
        }
    }

    public void registerElement(Element e, String desc) {
        SVGOMElement svge;
        SVGContext svgctx;
        this.registerObjectDesc(e, desc);
        UpdateManager um = this.getTheCanvas().getUpdateManager();
        BridgeContext bc = um.getBridgeContext();
        GraphicsNode gn = bc.getGraphicsNode(e);
        if (gn != null) {
            this.registerObjectDesc(gn, String.valueOf(desc) + "_GN");
        }
        if (e instanceof SVGOMElement && (svgctx = (svge = (SVGOMElement)e).getSVGContext()) != null) {
            this.registerObjectDesc(svgctx, String.valueOf(desc) + "_CTX");
        }
    }

    public void registerResourceContext(String uriSubstring, String desc) {
        UpdateManager um = this.getTheCanvas().getUpdateManager();
        BridgeContext bc = um.getBridgeContext();
        BridgeContext[] ctxs = bc.getChildContexts();
        int i = 0;
        while (i < ctxs.length) {
            String url;
            bc = ctxs[i];
            if (bc != null && (url = ((SVGOMDocument)bc.getDocument()).getURL()).indexOf(uriSubstring) != -1) {
                this.registerObjectDesc(ctxs[i], desc);
            }
            ++i;
        }
    }

    @Override
    public boolean canvasInit(JSVGCanvas canvas) {
        this.setTheCanvas(canvas);
        this.theFrame = this.handler.getFrame();
        File f = new File(this.getId());
        try {
            canvas.setURI(f.toURL().toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.registerObjectDesc(canvas, "JSVGCanvas");
        this.registerObjectDesc(this.handler.getFrame(), "JFrame");
        return true;
    }

    @Override
    public void canvasLoaded(JSVGCanvas canvas) {
        this.registerObjectDesc(canvas.getSVGDocument(), "SVGDoc");
    }

    @Override
    public void canvasRendered(JSVGCanvas canvas) {
        this.registerObjectDesc(canvas.getGraphicsNode(), "GVT");
        UpdateManager um = canvas.getUpdateManager();
        if (um == null) {
            return;
        }
        BridgeContext bc = um.getBridgeContext();
        this.registerObjectDesc(um, "updateManager");
        this.registerObjectDesc(bc, "bridgeContext");
        BridgeContext[] subCtxs = bc.getChildContexts();
        int i = 0;
        while (i < subCtxs.length) {
            if (subCtxs[i] != null) {
                SVGOMDocument doc = (SVGOMDocument)subCtxs[i].getDocument();
                this.registerObjectDesc(subCtxs[i], "BridgeContext_" + doc.getURL());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canvasUpdated(JSVGCanvas canvas) {
        JSVGMemoryLeakTest jSVGMemoryLeakTest = this;
        synchronized (jSVGMemoryLeakTest) {
            return this.done;
        }
    }

    @Override
    public void canvasDone(JSVGCanvas canvas) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failure(TestReport report) {
        JSVGMemoryLeakTest jSVGMemoryLeakTest = this;
        synchronized (jSVGMemoryLeakTest) {
            this.done = true;
            this.failReport = report;
        }
    }
}

