/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing;

import java.awt.EventQueue;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGCanvasHandler;
import org.apache.batik.swing.JSVGMemoryLeakTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;
import org.w3c.dom.svg.SVGDocument;

public class NullSetSVGDocumentTest
extends JSVGMemoryLeakTest {
    public static final String TEST_NON_NULL_URI = "file:samples/anne.svg";
    public static final String ENTRY_KEY_ERROR_DESCRIPTION = "JSVGCanvasHandler.entry.key.error.description";
    public static final String ERROR_IMAGE_NOT_CLEARED = "NullSetSVGDocumentTest.message.error.image.not.cleared";
    public static final String ERROR_ON_SET = "NullSetSVGDocumentTest.message.error.on.set";

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public JSVGCanvasHandler createHandler() {
        return new JSVGCanvasHandler(this, this){

            @Override
            public JSVGCanvas createCanvas() {
                return new JSVGCanvas(){

                    @Override
                    protected void installSVGDocument(SVGDocument doc) {
                        super.installSVGDocument(doc);
                        if (doc != null) {
                            return;
                        }
                        (this).NullSetSVGDocumentTest.this.handler.scriptDone();
                    }
                };
            }
        };
    }

    public Runnable getRunnable(final JSVGCanvas canvas) {
        return new Runnable(){

            @Override
            public void run() {
                canvas.setSVGDocument(null);
            }
        };
    }

    @Override
    public boolean canvasInit(JSVGCanvas canvas) {
        this.setTheCanvas(canvas);
        this.theFrame = this.handler.getFrame();
        canvas.setDocumentState(1);
        canvas.setURI(TEST_NON_NULL_URI);
        this.registerObjectDesc(canvas, "JSVGCanvas");
        this.registerObjectDesc(this.handler.getFrame(), "JFrame");
        return true;
    }

    @Override
    public void canvasRendered(JSVGCanvas canvas) {
        super.canvasRendered(canvas);
        try {
            EventQueue.invokeAndWait(this.getRunnable(canvas));
        }
        catch (Throwable t) {
            t.printStackTrace();
            StringWriter trace = new StringWriter();
            t.printStackTrace(new PrintWriter(trace));
            DefaultTestReport report = new DefaultTestReport(this);
            report.setErrorCode(ERROR_ON_SET);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(NullSetSVGDocumentTest.fmt(ENTRY_KEY_ERROR_DESCRIPTION, null), NullSetSVGDocumentTest.fmt(ERROR_ON_SET, new Object[]{trace.toString()}))});
            report.setPassed(false);
            this.failReport = report;
        }
    }

    @Override
    public boolean canvasUpdated(JSVGCanvas canvas) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void canvasDone(JSVGCanvas canvas) {
        NullSetSVGDocumentTest nullSetSVGDocumentTest = this;
        synchronized (nullSetSVGDocumentTest) {
            this.checkObjects(new String[]{"SVGDoc", "GVT", "updateManager"});
            if (canvas.getOffScreen() == null) {
                return;
            }
            System.err.println(">>>>>>> Canvas not cleared");
            DefaultTestReport report = new DefaultTestReport(this);
            report.setErrorCode(ERROR_IMAGE_NOT_CLEARED);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(NullSetSVGDocumentTest.fmt(ENTRY_KEY_ERROR_DESCRIPTION, null), NullSetSVGDocumentTest.fmt(ERROR_IMAGE_NOT_CLEARED, null))});
            report.setPassed(false);
            this.failReport = report;
            return;
        }
    }
}

