/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.Messages;
import org.apache.batik.test.TestReport;
import org.apache.batik.util.CleanerThread;

public abstract class MemoryLeakTest
extends AbstractTest {
    static final int NUM_GC = 10;
    static final int MIN_MEMORY = 200000;
    static final int ALLOC_SZ = 1000;
    static final String ERROR_OBJS_NOT_CLEARED = "MemoryLeakTest.message.error.objs.not.cleared";
    static final String ERROR_DESCRIPTION = "TestReport.entry.key.error.description";
    Map objs = new HashMap();
    List entries = new ArrayList();

    public static String fmt(String key, Object[] args) {
        return Messages.formatMessage(key, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(Object o) {
        Map map = this.objs;
        synchronized (map) {
            String desc = o.toString();
            this.objs.put(desc, new WeakRef(o, desc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObjectDesc(Object o, String desc) {
        Map map = this.objs;
        synchronized (map) {
            this.objs.put(desc, new WeakRef(o, desc));
        }
    }

    public boolean checkObject(String desc) {
        String[] strs = new String[]{desc};
        return this.checkObjects(strs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkObjects(String[] descs) {
        Runtime rt = Runtime.getRuntime();
        ArrayList l = new ArrayList();
        int nBlock = (int)(rt.totalMemory() / 10000L);
        try {
            try {
                while (true) {
                    int i;
                    boolean passed = true;
                    Map map = this.objs;
                    synchronized (map) {
                        i = 0;
                        while (i < descs.length) {
                            String desc = descs[i];
                            WeakRef wr = (WeakRef)this.objs.get(desc);
                            if (wr != null && wr.get() != null) {
                                passed = false;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (passed) {
                        return true;
                    }
                    ArrayList<byte[]> l2 = new ArrayList<byte[]>();
                    i = 0;
                    while (i < nBlock) {
                        l2.add(new byte[1000]);
                        ++i;
                    }
                    l.add(l2);
                }
            }
            catch (OutOfMemoryError passed) {
                l = null;
            }
        }
        catch (Throwable throwable) {
            l = null;
            throw throwable;
        }
        int i = 0;
        while (i < 10) {
            rt.gc();
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        boolean passed = true;
        Map i2 = this.objs;
        synchronized (i2) {
            int i3 = 0;
            while (i3 < descs.length) {
                Object o;
                String desc = descs[i3];
                WeakRef wr = (WeakRef)this.objs.get(desc);
                if (wr != null && (o = wr.get()) != null) {
                    if (!passed) {
                        sb.append(",");
                    }
                    passed = false;
                    sb.append("'");
                    sb.append(wr.getDesc());
                    sb.append("'");
                }
                ++i3;
            }
            if (passed) {
                return true;
            }
        }
        String objStr = sb.toString();
        TestReport.Entry entry = new TestReport.Entry(MemoryLeakTest.fmt(ERROR_DESCRIPTION, null), MemoryLeakTest.fmt(ERROR_OBJS_NOT_CLEARED, new Object[]{objStr}));
        this.entries.add(entry);
        if (objStr.length() > 40) {
            objStr = String.valueOf(objStr.substring(0, 40)) + "...";
        }
        System.err.println(">>>>> Objects not cleared: " + objStr);
        return false;
    }

    public boolean checkObjectsList(List descs) {
        String[] strs = new String[descs.size()];
        descs.toArray(strs);
        return this.checkObjects(strs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAllObjects() {
        Runtime rt = Runtime.getRuntime();
        ArrayList l = new ArrayList();
        int nBlock = (int)(rt.totalMemory() / 10000L);
        try {
            try {
                while (true) {
                    boolean passed = true;
                    Map map = this.objs;
                    synchronized (map) {
                        for (WeakRef wr : this.objs.values()) {
                            if (wr == null || wr.get() == null) continue;
                            passed = false;
                            break;
                        }
                    }
                    if (passed) {
                        return true;
                    }
                    ArrayList<byte[]> l2 = new ArrayList<byte[]>();
                    int i = 0;
                    while (i < nBlock) {
                        l2.add(new byte[1000]);
                        ++i;
                    }
                    l.add(l2);
                }
            }
            catch (OutOfMemoryError passed) {
                l = null;
            }
        }
        catch (Throwable throwable) {
            l = null;
            throw throwable;
        }
        int i = 0;
        while (i < 10) {
            rt.gc();
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        Map l2 = this.objs;
        synchronized (l2) {
            boolean passed = true;
            for (WeakRef wr : this.objs.values()) {
                Object o = wr.get();
                if (o == null) continue;
                if (!passed) {
                    sb.append(",");
                }
                passed = false;
                sb.append("'");
                sb.append(wr.getDesc());
                sb.append("'");
            }
            if (passed) {
                return true;
            }
        }
        String objStr = sb.toString();
        TestReport.Entry entry = new TestReport.Entry(MemoryLeakTest.fmt(ERROR_DESCRIPTION, null), MemoryLeakTest.fmt(ERROR_OBJS_NOT_CLEARED, new Object[]{objStr}));
        this.entries.add(entry);
        if (objStr.length() > 40) {
            objStr = String.valueOf(objStr.substring(0, 40)) + "...";
        }
        System.err.println(">>>>> Objects not cleared: " + objStr);
        return false;
    }

    @Override
    public TestReport runImpl() throws Exception {
        TestReport ret = this.doSomething();
        if (ret != null && !ret.hasPassed()) {
            return ret;
        }
        this.checkAllObjects();
        DefaultTestReport report = new DefaultTestReport(this);
        if (this.entries.size() == 0) {
            report.setPassed(true);
            return report;
        }
        report.setErrorCode(ERROR_OBJS_NOT_CLEARED);
        report.setDescription(this.entries.toArray(new TestReport.Entry[this.entries.size()]));
        report.setPassed(false);
        return report;
    }

    public abstract TestReport doSomething() throws Exception;

    public class WeakRef
    extends CleanerThread.WeakReferenceCleared {
        String desc;

        public WeakRef(Object o) {
            super(o);
            this.desc = o.toString();
        }

        public WeakRef(Object o, String desc) {
            super(o);
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleared() {
            Map map = MemoryLeakTest.this.objs;
            synchronized (map) {
                MemoryLeakTest.this.objs.remove(this.desc);
            }
        }
    }
}

