/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.svg;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGCanvasHandler;
import org.apache.batik.swing.gvt.Overlay;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.svg.Messages;
import org.apache.batik.test.svg.SamplesRenderingTest;

public class JSVGRenderingAccuracyTest
extends SamplesRenderingTest
implements JSVGCanvasHandler.Delegate {
    public static final String ERROR_SAVE_FAILED = "JSVGRenderingAccuracyTest.message.error.save.failed";
    protected URL srcURL;
    protected FileOutputStream fos;
    protected TestReport failReport = null;
    protected boolean done;
    protected JSVGCanvasHandler handler = null;

    public static String fmt(String key, Object[] args) {
        return Messages.formatMessage(key, args);
    }

    public JSVGCanvasHandler createCanvasHandler() {
        return new JSVGCanvasHandler(this, this);
    }

    @Override
    public TestReport encode(URL srcURL, FileOutputStream fos) {
        this.srcURL = srcURL;
        this.fos = fos;
        this.handler = this.createCanvasHandler();
        this.done = false;
        this.handler.runCanvas(srcURL.toString());
        this.handler = null;
        if (this.failReport != null) {
            return this.failReport;
        }
        DefaultTestReport report = new DefaultTestReport(this);
        report.setPassed(true);
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scriptDone() {
        JSVGRenderingAccuracyTest jSVGRenderingAccuracyTest = this;
        synchronized (jSVGRenderingAccuracyTest) {
            this.done = true;
            this.handler.scriptDone();
        }
    }

    @Override
    public boolean canvasInit(JSVGCanvas canvas) {
        canvas.setURI(this.srcURL.toString());
        return true;
    }

    @Override
    public void canvasLoaded(JSVGCanvas canvas) {
    }

    @Override
    public void canvasRendered(JSVGCanvas canvas) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canvasUpdated(JSVGCanvas canvas) {
        JSVGRenderingAccuracyTest jSVGRenderingAccuracyTest = this;
        synchronized (jSVGRenderingAccuracyTest) {
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void canvasDone(JSVGCanvas canvas) {
        JSVGRenderingAccuracyTest jSVGRenderingAccuracyTest = this;
        synchronized (jSVGRenderingAccuracyTest) {
            this.done = true;
            if (this.failReport != null) {
                return;
            }
            try {
                BufferedImage theImage = JSVGRenderingAccuracyTest.copyImage(canvas.getOffScreen());
                List overlays = canvas.getOverlays();
                Graphics2D g = theImage.createGraphics();
                Iterator it = overlays.iterator();
                while (it.hasNext()) {
                    ((Overlay)it.next()).paint(g);
                }
                this.saveImage(theImage, this.fos);
            }
            catch (IOException ioe) {
                StringWriter trace = new StringWriter();
                ioe.printStackTrace(new PrintWriter(trace));
                DefaultTestReport report = new DefaultTestReport(this);
                report.setErrorCode(ERROR_SAVE_FAILED);
                report.setDescription(new TestReport.Entry[]{new TestReport.Entry(JSVGRenderingAccuracyTest.fmt("SVGRenderingAccuracyTest.entry.key.error.description", null), JSVGRenderingAccuracyTest.fmt(ERROR_SAVE_FAILED, new Object[]{this.srcURL.toString(), trace.toString()}))});
                report.setPassed(false);
                this.failReport = report;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failure(TestReport report) {
        JSVGRenderingAccuracyTest jSVGRenderingAccuracyTest = this;
        synchronized (jSVGRenderingAccuracyTest) {
            this.done = true;
            this.failReport = report;
        }
    }

    public static BufferedImage copyImage(BufferedImage bi) {
        BufferedImage ret = new BufferedImage(bi.getWidth(), bi.getHeight(), bi.getType());
        bi.copyData(ret.getRaster());
        return ret;
    }
}

