/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.svg;

import java.util.Vector;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestSuite;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.svg.SelfContainedSVGOnLoadTest;

public class SelfContainedSVGOnLoadTestValidator
extends DefaultTestSuite {
    public static final String ERROR_UNEXPECTED_TEST_RESULT = "SelfContainedSVGOnLoadTestValidator.error.unexpected.test.result";
    public static final String ERROR_UNEXPECTED_ERROR_CODE = "SelfContainedSVGOnLoadTestValidator.error.unexpected.error.code";
    public static final String ERROR_UNEXPECTED_NUMBER_OF_DESCRIPTION_ENTRIES = "SelfContainedSVGOnLoadTestValidator.error.unexpected.number.of.description.entries";
    public static final String ERROR_UNEXPECTED_TEST_FAILURE = "SelfContainedSVGOnLoadTestValidator.error.unexpected.test.failure";
    public static final String ERROR_UNEXPECTED_DESCRIPTION_ENTRY = "SelfContainedSVGOnLoadTestValidator.error.unexpected.description.entry";
    public static final String ENTRY_ERROR_CODE = "SelfContainedSVGOnLoadTestValidator.entry.error.code";
    public static final String ENTRY_EXPECTED_ERROR_CODE = "SelfContainedSVGOnLoadTestValidator.entry.expected.error.code";
    public static final String ENTRY_NUMBER_OF_DESCRIPTION = "SelfContainedSVGOnLoadTestValidator.entry.number.of.description";
    public static final String ENTRY_EXPECTED_NUMBER_OF_DESCRIPTION = "SelfContainedSVGOnLoadTestValidator.entry.expected.number.of.description";
    public static final String ENTRY_KEY = "SelfContainedSVGOnLoadTestValidator.entry.key";
    public static final String ENTRY_EXPECTED_KEY = "SelfContainedSVGOnLoadTestValidator.entry.expected.key";
    public static final String invalidURL = "invalidURL";
    public static final String processingErrorURL = "test-resources/org/apache/batik/test/svg/processingError.svg";
    public static final String invalidTestResultElementsNumberURL = "test-resources/org/apache/batik/test/svg/invalidTestResultElementsNumber.svg";
    public static final String unexpectedResultValueURL = "test-resources/org/apache/batik/test/svg/unexpectedResultValue.svg";
    public static final String missingOrEmptyErrorCodeURL = "test-resources/org/apache/batik/test/svg/missingOrEmptyErrorCode.svg";
    public static final String errorURL = "test-resources/org/apache/batik/test/svg/error.svg";
    public static final String errorAndEntriesURL = "test-resources/org/apache/batik/test/svg/errorAndEntries.svg";
    public static final String successURL = "test-resources/org/apache/batik/test/svg/success.svg";

    public SelfContainedSVGOnLoadTestValidator() {
        this.addTest(new CannotLoadSVGDocument());
        this.addTest(new ProcessingError());
        this.addTest(new InvalidTestResultElementsNumber());
        this.addTest(new UnexpectedResultValue());
        this.addTest(new MissingOrEmptyErrorCode());
        this.addTest(new ReportError());
        this.addTest(new ReportSuccess());
        this.addTest(new ReportErrorAndEntries());
    }

    static class CannotLoadSVGDocument
    extends DefaultErrorTest {
        public CannotLoadSVGDocument() {
            super(SelfContainedSVGOnLoadTestValidator.invalidURL, "SelfContainedSVGOnLoadTest.error.cannot.load.svg.document", new String[]{"SelfContainedSVGOnLoadTest.entry.key.error.description"});
        }
    }

    static class DefaultErrorTest
    extends AbstractTest {
        String svgURL;
        String expectedErrorCode;
        String[] expectedEntryCodes;

        public DefaultErrorTest(String svgURL, String expectedErrorCode, String[] expectedEntryCodes) {
            this.svgURL = svgURL;
            this.expectedErrorCode = expectedErrorCode;
            this.expectedEntryCodes = expectedEntryCodes;
        }

        @Override
        public TestReport runImpl() throws Exception {
            SelfContainedSVGOnLoadTest t = new SelfContainedSVGOnLoadTest(this.svgURL);
            TestReport tr = t.run();
            if (tr.hasPassed()) {
                return this.reportError(SelfContainedSVGOnLoadTestValidator.ERROR_UNEXPECTED_TEST_RESULT);
            }
            if (tr.getErrorCode() != this.expectedErrorCode) {
                TestReport r = this.reportError(SelfContainedSVGOnLoadTestValidator.ERROR_UNEXPECTED_ERROR_CODE);
                r.addDescriptionEntry(SelfContainedSVGOnLoadTestValidator.ENTRY_ERROR_CODE, tr.getErrorCode());
                r.addDescriptionEntry(SelfContainedSVGOnLoadTestValidator.ENTRY_EXPECTED_ERROR_CODE, this.expectedErrorCode);
                return r;
            }
            TestReport.Entry[] desc = tr.getDescription();
            int nDesc = 0;
            int enDesc = 0;
            if (desc != null) {
                nDesc = desc.length;
            }
            if (this.expectedEntryCodes != null) {
                enDesc = this.expectedEntryCodes.length;
            }
            if (nDesc != enDesc) {
                TestReport r = this.reportError(SelfContainedSVGOnLoadTestValidator.ERROR_UNEXPECTED_NUMBER_OF_DESCRIPTION_ENTRIES);
                r.addDescriptionEntry(SelfContainedSVGOnLoadTestValidator.ENTRY_NUMBER_OF_DESCRIPTION, "" + nDesc);
                r.addDescriptionEntry(SelfContainedSVGOnLoadTestValidator.ENTRY_EXPECTED_NUMBER_OF_DESCRIPTION, "" + enDesc);
                return r;
            }
            if (nDesc > 0) {
                Vector<String> veDesc = new Vector<String>();
                int i = 0;
                while (i < nDesc) {
                    veDesc.add(this.expectedEntryCodes[i]);
                    ++i;
                }
                i = 0;
                while (i < nDesc) {
                    String key = desc[i].getKey();
                    if (key == null || !veDesc.contains(key)) {
                        TestReport r = this.reportError(SelfContainedSVGOnLoadTestValidator.ERROR_UNEXPECTED_DESCRIPTION_ENTRY);
                        if (key != null) {
                            r.addDescriptionEntry(SelfContainedSVGOnLoadTestValidator.ENTRY_KEY, key);
                            r.addDescriptionEntry(SelfContainedSVGOnLoadTestValidator.ENTRY_EXPECTED_KEY, "SelfContainedSVGOnLoadTest.entry.key.number.of.test.result.elements");
                        }
                        return r;
                    }
                    ++i;
                }
            }
            return this.reportSuccess();
        }
    }

    static class InvalidTestResultElementsNumber
    extends DefaultErrorTest {
        public InvalidTestResultElementsNumber() {
            super(SelfContainedSVGOnLoadTestValidator.invalidTestResultElementsNumberURL, "SelfContainedSVGOnLoadTest.error.unexpected.number.of.test.result.elements", new String[]{"SelfContainedSVGOnLoadTest.entry.key.number.of.test.result.elements"});
        }
    }

    static class MissingOrEmptyErrorCode
    extends DefaultErrorTest {
        public MissingOrEmptyErrorCode() {
            super(SelfContainedSVGOnLoadTestValidator.missingOrEmptyErrorCodeURL, "SelfContainedSVGOnLoadTest.error.missing.or.empty.error.code.on.failed.test", null);
        }
    }

    static class ProcessingError
    extends DefaultErrorTest {
        public ProcessingError() {
            super(SelfContainedSVGOnLoadTestValidator.processingErrorURL, "SelfContainedSVGOnLoadTest.error.while.processing.svg.document", new String[]{"SelfContainedSVGOnLoadTest.entry.key.error.description"});
        }
    }

    static class ReportError
    extends DefaultErrorTest {
        public ReportError() {
            super(SelfContainedSVGOnLoadTestValidator.errorURL, "can.you.read.this.error.code", null);
        }
    }

    static class ReportErrorAndEntries
    extends DefaultErrorTest {
        public ReportErrorAndEntries() {
            super(SelfContainedSVGOnLoadTestValidator.errorAndEntriesURL, "can.you.read.this.error.code", new String[]{"can.you.read.this.first.entry", "can.you.read.this.second.entry"});
        }
    }

    static class ReportSuccess
    extends AbstractTest {
        ReportSuccess() {
        }

        public TestReport rumImpl() throws Exception {
            SelfContainedSVGOnLoadTest t = new SelfContainedSVGOnLoadTest(SelfContainedSVGOnLoadTestValidator.successURL);
            TestReport tr = t.run();
            if (!tr.hasPassed()) {
                return this.reportError(SelfContainedSVGOnLoadTestValidator.ERROR_UNEXPECTED_TEST_FAILURE);
            }
            return this.reportSuccess();
        }
    }

    static class UnexpectedResultValue
    extends DefaultErrorTest {
        public UnexpectedResultValue() {
            super(SelfContainedSVGOnLoadTestValidator.unexpectedResultValueURL, "SelfContainedSVGOnLoadTest.error.unexpected.result.value", new String[]{"SelfContainedSVGOnLoadTest.entry.key.result.value"});
        }
    }
}

