/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.batik.test.xml.Messages;
import org.apache.batik.test.xml.XMLReflectConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLReflect
implements XMLReflectConstants {
    public static final String NO_MATCHING_CONSTRUCTOR = "xml.XMLReflect.error.no.matching.constructor";

    public static Object buildObject(Element element) throws Exception {
        Constructor constructor;
        int i;
        Element classDefiningElement = XMLReflect.getClassDefiningElement(element);
        String className = classDefiningElement.getAttribute("class");
        Class<?> cl = Class.forName(className);
        Object[] argsArray = null;
        Class[] argsClasses = null;
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int n = children.getLength();
            ArrayList<Object> args = new ArrayList<Object>();
            i = 0;
            while (i < n) {
                Element childElement;
                String tagName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (tagName = (childElement = (Element)child).getTagName().intern()) == "arg") {
                    Object arg = XMLReflect.buildArgument(childElement);
                    args.add(arg);
                }
                ++i;
            }
            if (args.size() > 0) {
                argsArray = new Object[args.size()];
                args.toArray(argsArray);
                argsClasses = new Class[args.size()];
                i = 0;
                while (i < args.size()) {
                    argsClasses[i] = argsArray[i].getClass();
                    ++i;
                }
            }
        }
        if ((constructor = XMLReflect.getDeclaredConstructor(cl, argsClasses)) == null) {
            String argsClassesStr = "null";
            if (argsClasses != null) {
                argsClassesStr = "";
                i = 0;
                while (i < argsClasses.length) {
                    argsClassesStr = String.valueOf(argsClassesStr) + argsClasses[i].getName() + " / ";
                    ++i;
                }
            }
            throw new Exception(Messages.formatMessage(NO_MATCHING_CONSTRUCTOR, new Object[]{className, argsClassesStr}));
        }
        return XMLReflect.configureObject(constructor.newInstance(argsArray), element, classDefiningElement);
    }

    public static Object configureObject(Object obj, Element element, Element classDefiningElement) throws Exception {
        ArrayList<Element> v = new ArrayList<Element>();
        v.add(element);
        while (element != classDefiningElement) {
            element = (Element)element.getParentNode();
            v.add(element);
        }
        int ne = v.size();
        int j = ne - 1;
        while (j >= 0) {
            element = (Element)v.get(j);
            NodeList children = element.getChildNodes();
            if (children != null && children.getLength() > 0) {
                int n = children.getLength();
                int i = 0;
                while (i < n) {
                    Element childElement;
                    String tagName;
                    Node child = children.item(i);
                    if (child.getNodeType() == 1 && (tagName = (childElement = (Element)child).getTagName().intern()) == "property") {
                        Object arg = XMLReflect.buildArgument(childElement);
                        String propertyName = childElement.getAttribute("name");
                        XMLReflect.setObjectProperty(obj, propertyName, arg);
                    }
                    ++i;
                }
            }
            --j;
        }
        return obj;
    }

    public static void setObjectProperty(Object obj, String propertyName, Object propertyValue) throws Exception {
        Class<?> cl = obj.getClass();
        Method m = null;
        try {
            m = cl.getMethod("set" + propertyName, propertyValue.getClass());
        }
        catch (NoSuchMethodException e) {
            Class<?> propertyClass = propertyValue.getClass();
            if (propertyClass == Double.class) {
                m = cl.getMethod("set" + propertyName, Double.TYPE);
            }
            if (propertyClass == Float.class) {
                m = cl.getMethod("set" + propertyName, Float.TYPE);
            }
            if (propertyClass == Integer.class) {
                m = cl.getMethod("set" + propertyName, Integer.TYPE);
            }
            if (propertyClass == Boolean.class) {
                m = cl.getMethod("set" + propertyName, Boolean.TYPE);
            }
            System.err.println("Could not find a set method for property : " + propertyName + " with value " + propertyValue + " and class " + propertyValue.getClass().getName());
            throw e;
        }
        if (m != null) {
            m.invoke(obj, propertyValue);
        }
    }

    public static Constructor getDeclaredConstructor(Class cl, Class[] argClasses) {
        Constructor<?>[] cs = cl.getDeclaredConstructors();
        int i = 0;
        while (i < cs.length) {
            Class<?>[] reqArgClasses = cs[i].getParameterTypes();
            if (reqArgClasses != null && reqArgClasses.length > 0) {
                if (reqArgClasses.length == argClasses.length) {
                    int j = 0;
                    while (j < argClasses.length) {
                        if (!reqArgClasses[j].isAssignableFrom(argClasses[j])) break;
                        ++j;
                    }
                    if (j == argClasses.length) {
                        return cs[i];
                    }
                }
            } else if (argClasses == null || argClasses.length == 0) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }

    public static Object buildArgument(Element element) throws Exception {
        if (!element.hasChildNodes()) {
            Element classDefiningElement = XMLReflect.getClassDefiningElement(element);
            String classAttr = classDefiningElement.getAttribute("class");
            Class<?> cl = Class.forName(classAttr);
            if (element.hasAttribute("value")) {
                String value = element.getAttribute("value");
                Constructor<?> constructor = cl.getDeclaredConstructor(String.class);
                return constructor.newInstance(value);
            }
            return cl.newInstance();
        }
        return XMLReflect.buildObject(element);
    }

    public static Element getClassDefiningElement(Element element) {
        if (element != null) {
            String classAttr = element.getAttribute("class");
            if (classAttr == null || "".equals(classAttr)) {
                Node parent = element.getParentNode();
                if (parent != null && parent.getNodeType() == 1) {
                    return XMLReflect.getClassDefiningElement((Element)parent);
                }
                return null;
            }
            return element;
        }
        return null;
    }
}

