/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.batik.test.TestException;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.TestReportProcessor;
import org.apache.batik.test.TestSuite;
import org.apache.batik.test.xml.Messages;
import org.apache.batik.test.xml.XTRConstants;
import org.apache.batik.util.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTestReportProcessor
implements TestReportProcessor,
XTRConstants,
XMLConstants {
    public static final String ERROR_REPORT_DIRECTORY_UNUSABLE = "xml.XMLTestReportProcessor.error.report.directory.unusable";
    public static final String ERROR_REPORT_RESOURCES_DIRECTORY_UNUSABLE = "xml.XMLTestReportProcessor.error.report.resources.directory.unusable";
    public static final String XML_TEST_REPORT_DEFAULT_DIRECTORY;
    public static final String XML_REPORT_DIRECTORY;
    public static final String XML_RESOURCES_DIRECTORY;
    public static final String XML_TEST_REPORT_NAME;
    protected XMLReportConsumer consumer;
    protected String reportDate;
    protected File reportDirectory;
    protected File xmlDirectory;
    protected File xmlResourcesDirectory;
    private static String EOL;
    private static String PROPERTY_LINE_SEPARATOR;
    private static String PROPERTY_LINE_SEPARATOR_DEFAULT;

    static {
        String temp;
        XML_TEST_REPORT_DEFAULT_DIRECTORY = Messages.formatMessage("XMLTestReportProcessor.config.xml.test.report.default.directory", null);
        XML_REPORT_DIRECTORY = Messages.formatMessage("XMLTestReportProcessor.xml.report.directory", null);
        XML_RESOURCES_DIRECTORY = Messages.formatMessage("XMLTestReportProcessor.xml.resources.directory", null);
        XML_TEST_REPORT_NAME = Messages.formatMessage("XMLTestReportProcessor.config.xml.test.report.name", null);
        PROPERTY_LINE_SEPARATOR = "line.separator";
        PROPERTY_LINE_SEPARATOR_DEFAULT = "\n";
        try {
            temp = System.getProperty(PROPERTY_LINE_SEPARATOR, PROPERTY_LINE_SEPARATOR_DEFAULT);
        }
        catch (SecurityException e) {
            temp = PROPERTY_LINE_SEPARATOR_DEFAULT;
        }
        EOL = temp;
    }

    public XMLTestReportProcessor() {
    }

    public XMLTestReportProcessor(XMLReportConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public void processReport(TestReport report) throws TestException {
        this.initializeReportDirectories();
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            DOMImplementation impl = docBuilder.getDOMImplementation();
            Document document = null;
            document = report.getTest() instanceof TestSuite ? impl.createDocument("http://xml.apache.org/xml-batik/test/xtr", "testSuiteReport", null) : impl.createDocument("http://xml.apache.org/xml-batik/test/xtr", "testReport", null);
            Element root = document.getDocumentElement();
            root.setAttribute("date", this.reportDate);
            this.processReport(report, root, document);
            File xmlReport = this.serializeReport(root);
            if (this.consumer != null) {
                this.consumer.onNewReport(xmlReport, this.getReportDirectory());
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            throw new TestException("TestReportProcessor.error.code.internal.error", new Object[]{e.getClass().getName(), e.getMessage(), sw.toString()}, e);
        }
    }

    public void checkDirectory(File dir, String errorCode) throws TestException {
        boolean dirOK = false;
        try {
            if (!dir.exists()) {
                dirOK = dir.mkdir();
            } else if (dir.isDirectory()) {
                dirOK = true;
            }
        }
        catch (Throwable throwable) {
            if (!dirOK) {
                throw new TestException(errorCode, new Object[]{dir.getAbsolutePath()}, null);
            }
            throw throwable;
        }
        if (!dirOK) {
            throw new TestException(errorCode, new Object[]{dir.getAbsolutePath()}, null);
        }
    }

    public void initializeReportDirectories() throws TestException {
        String dirName;
        File baseReportDir = new File(XML_TEST_REPORT_DEFAULT_DIRECTORY);
        this.checkDirectory(baseReportDir, ERROR_REPORT_DIRECTORY_UNUSABLE);
        Calendar c = Calendar.getInstance();
        this.reportDate = dirName = c.get(1) + "." + this.makeTwoDigits(c.get(2) + 1) + "." + this.makeTwoDigits(c.get(5)) + "-" + this.makeTwoDigits(c.get(11)) + "h" + this.makeTwoDigits(c.get(12)) + "m" + this.makeTwoDigits(c.get(13)) + "s";
        this.reportDirectory = new File(baseReportDir, dirName);
        this.checkDirectory(this.reportDirectory, ERROR_REPORT_DIRECTORY_UNUSABLE);
        this.xmlDirectory = new File(this.reportDirectory, XML_REPORT_DIRECTORY);
        this.checkDirectory(this.xmlDirectory, ERROR_REPORT_DIRECTORY_UNUSABLE);
        this.xmlResourcesDirectory = new File(this.xmlDirectory, XML_RESOURCES_DIRECTORY);
        this.checkDirectory(this.xmlResourcesDirectory, ERROR_REPORT_DIRECTORY_UNUSABLE);
    }

    protected String makeTwoDigits(int i) {
        if (i > 9) {
            return "" + i;
        }
        return "0" + i;
    }

    public File getReportDirectory() {
        return this.reportDirectory;
    }

    public File getReportResourcesDirectory() {
        return this.xmlResourcesDirectory;
    }

    protected void processReport(TestReport report, Element reportElement, Document reportDocument) throws IOException {
        TestReport.Entry[] entries;
        int n;
        if (report == null) {
            throw new IllegalArgumentException();
        }
        reportElement.setAttribute("testName", report.getTest().getName());
        String id = report.getTest().getQualifiedId();
        if (!"".equals(id)) {
            reportElement.setAttribute("id", id);
        }
        String status = report.hasPassed() ? "passed" : "failed";
        reportElement.setAttribute("status", status);
        String className = report.getTest().getClass().getName();
        reportElement.setAttribute("class", className);
        if (!report.hasPassed()) {
            reportElement.setAttribute("errorCode", report.getErrorCode());
        }
        int n2 = n = (entries = report.getDescription()) != null ? entries.length : 0;
        if (n > 0) {
            Element descriptionElement = reportDocument.createElementNS(null, "description");
            reportElement.appendChild(descriptionElement);
            int i = 0;
            while (i < n) {
                this.processEntry(entries[i], descriptionElement, reportDocument);
                ++i;
            }
        }
    }

    protected void processEntry(TestReport.Entry entry, Element descriptionElement, Document reportDocument) throws IOException {
        Object value = entry.getValue();
        String key = entry.getKey();
        if (value instanceof TestReport) {
            TestReport report = (TestReport)value;
            Element reportElement = null;
            reportElement = report.getTest() instanceof TestSuite ? reportDocument.createElementNS("http://xml.apache.org/xml-batik/test/xtr", "testSuiteReport") : reportDocument.createElementNS("http://xml.apache.org/xml-batik/test/xtr", "testReport");
            descriptionElement.appendChild(reportElement);
            this.processReport((TestReport)entry.getValue(), reportElement, reportDocument);
        } else if (value instanceof URL) {
            Element entryElement = reportDocument.createElementNS("http://xml.apache.org/xml-batik/test/xtr", "uriEntry");
            descriptionElement.appendChild(entryElement);
            entryElement.setAttribute("key", key.toString());
            entryElement.setAttribute("value", value.toString());
        } else if (value instanceof File) {
            File tmpFile = (File)value;
            File tmpFileCopy = this.createResourceFileForName(tmpFile.getName());
            this.copy(tmpFile, tmpFileCopy);
            Element entryElement = reportDocument.createElementNS("http://xml.apache.org/xml-batik/test/xtr", "fileEntry");
            descriptionElement.appendChild(entryElement);
            entryElement.setAttribute("key", key.toString());
            entryElement.setAttribute("value", tmpFileCopy.toURL().toString());
        } else {
            Element entryElement = reportDocument.createElementNS("http://xml.apache.org/xml-batik/test/xtr", "genericEntry");
            descriptionElement.appendChild(entryElement);
            entryElement.setAttribute("key", key.toString());
            Attr a = reportDocument.createAttribute("value");
            a.setValue(value != null ? value.toString() : "null");
            entryElement.setAttributeNode(a);
        }
    }

    protected File createResourceFileForName(String fileName) {
        File r = new File(this.xmlResourcesDirectory, fileName);
        if (!r.exists()) {
            return r;
        }
        return this.createResourceFileForName(fileName, 1);
    }

    protected File createResourceFileForName(String fileName, int instance) {
        File r;
        int n = fileName.lastIndexOf(46);
        String iFileName = String.valueOf(fileName) + instance;
        if (n != -1) {
            iFileName = String.valueOf(fileName.substring(0, n)) + instance + fileName.substring(n, fileName.length());
        }
        if (!(r = new File(this.xmlResourcesDirectory, iFileName)).exists()) {
            return r;
        }
        return this.createResourceFileForName(fileName, instance + 1);
    }

    protected void copy(File in, File out) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(in));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));
        byte[] b = new byte[1024];
        int n = -1;
        while ((n = ((InputStream)is).read(b)) != -1) {
            ((OutputStream)os).write(b, 0, n);
        }
        ((InputStream)is).close();
        ((OutputStream)os).close();
    }

    protected File serializeReport(Element reportElement) throws IOException {
        File reportFile = new File(this.xmlDirectory, XML_TEST_REPORT_NAME);
        FileWriter fw = new FileWriter(reportFile);
        this.serializeElement(reportElement, "", fw);
        fw.close();
        return reportFile;
    }

    protected void serializeElement(Element element, String prefix, Writer writer) throws IOException {
        writer.write(prefix);
        writer.write("<");
        writer.write(element.getTagName());
        this.serializeAttributes(element, writer);
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            writer.write(" >");
            writer.write(EOL);
            int n = children.getLength();
            int i = 0;
            while (i < n) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    this.serializeElement((Element)child, String.valueOf(prefix) + "    ", writer);
                }
                ++i;
            }
            writer.write(prefix);
            writer.write("</");
            writer.write(element.getTagName());
            writer.write(">");
        } else {
            writer.write(" />");
        }
        writer.write(EOL);
    }

    protected void serializeAttributes(Element element, Writer writer) throws IOException {
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int nAttr = attributes.getLength();
            int i = 0;
            while (i < nAttr) {
                Attr attr = (Attr)attributes.item(i);
                writer.write(" ");
                writer.write(attr.getName());
                writer.write("=");
                writer.write("\"");
                writer.write(this.encode(attr.getValue()));
                writer.write("\"");
                ++i;
            }
        }
    }

    protected String encode(String attrValue) {
        StringBuffer sb = new StringBuffer(attrValue);
        this.replace(sb, '&', "&amp;");
        this.replace(sb, '<', "&lt;");
        this.replace(sb, '>', "&gt;");
        this.replace(sb, '\"', "&quot;");
        this.replace(sb, '\'', "&apos;");
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected void replace(StringBuffer s, char c, String r) {
        v = String.valueOf(s.toString()) + 1;
        i = v.length();
        if (true) ** GOTO lbl9
        do {
            s.deleteCharAt(i);
            s.insert(i, r);
lbl9:
            // 2 sources

            --i;
        } while ((i = v.lastIndexOf(c, i)) != -1);
    }

    public static interface XMLReportConsumer {
        public void onNewReport(File var1, File var2) throws Exception;
    }
}

