/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.xml;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.DefaultTestSuite;
import org.apache.batik.test.Test;
import org.apache.batik.test.TestException;
import org.apache.batik.test.TestFilter;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.TestReportProcessor;
import org.apache.batik.test.TestSuite;
import org.apache.batik.test.xml.Messages;
import org.apache.batik.test.xml.XMLReflect;
import org.apache.batik.test.xml.XMLTestSuiteLoader;
import org.apache.batik.test.xml.XTRunConstants;
import org.apache.batik.test.xml.XTSConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTestSuiteRunner
implements XTRunConstants,
XTSConstants {
    public static final String MESSAGE_UNMATCHED_TEST_IDS = "XMLTestSuiteRunner.messages.unmatched.test.ids";
    public static final String CANNOT_CREATE_TEST_REPORT_PROCESSOR = "xml.XMLTestSuiteRunner.error.cannot.create.test.report.processor";
    public static final String TEST_SUITE_EXCEPTION = "xml.XMLTestSuiteRunner.test.suite.exception";
    public static final String TEST_REPORT_PROCESSING_EXCEPTION = "xml.XMLTestSuiteRunner.error.test.report.processing.exception";
    public static final String USAGE = "XMLTestSuiteRunner.messages.error.usage";
    public static final String NOT_A_FILE_TRY_URI = "XMLTestSuiteRunner.messages.error.not.a.file.try.uri";
    public static final String COULD_NOT_CONVERT_FILE_NAME_TO_URI = "XMLTestSuiteRunner.messages.error.could.not.convert.file.name.to.uri";
    public static final String INVALID_URI = "XMLTestSuiteRunner.messages.error.invalid.uri";
    public static final String INVALID_DOCUMENT = "XMLTestSuiteRunner.messages.error.invalid.document";
    public static final String ERROR_RUNNING_TEST_SUITE = "XMLTestSuiteRunner.messages.error.running.test.suite";

    protected TestReportProcessor[] extractTestReportProcessor(Element element) throws TestException {
        ArrayList<TestReportProcessor> processors = new ArrayList<TestReportProcessor>();
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int n = children.getLength();
            int i = 0;
            while (i < n) {
                Element childElement;
                String tagName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (tagName = (childElement = (Element)child).getTagName().intern()) == "testReportProcessor") {
                    processors.add(this.buildProcessor(childElement));
                }
                ++i;
            }
        }
        TestReportProcessor[] p = null;
        if (processors.size() > 0) {
            p = new TestReportProcessor[processors.size()];
            processors.toArray(p);
        }
        return p;
    }

    protected TestReportProcessor buildProcessor(Element element) throws TestException {
        try {
            return (TestReportProcessor)XMLReflect.buildObject(element);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            throw new TestException(CANNOT_CREATE_TEST_REPORT_PROCESSOR, new Object[]{element.getAttribute("class"), e.getClass().getName(), e.getMessage(), sw.toString()}, e);
        }
    }

    protected DefaultTestSuite buildTestRunTestSuite(Element element) throws TestException {
        DefaultTestSuite testSuite = new DefaultTestSuite();
        String name = element.getAttribute("name");
        testSuite.setName(name);
        String id = element.getAttribute("id");
        testSuite.setId(id);
        Element[] testSuites = this.getChildrenByTagName(element, "testSuite");
        int n = testSuites != null ? testSuites.length : 0;
        int i = 0;
        while (i < n) {
            String suiteHref = testSuites[i].getAttribute("href");
            TestSuite test = XMLTestSuiteLoader.loadTestSuite(suiteHref, testSuite);
            if (test != null) {
                testSuite.addTest(test);
            }
            ++i;
        }
        return testSuite;
    }

    protected Element[] getChildrenByTagName(Element element, String tagName) {
        tagName = tagName.intern();
        ArrayList<Element> childrenWithTagName = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int n = children.getLength();
            int i = 0;
            while (i < n) {
                Element childElement;
                String childTagName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (childTagName = (childElement = (Element)child).getTagName().intern()) == tagName) {
                    childrenWithTagName.add(childElement);
                }
                ++i;
            }
        }
        Element[] a = null;
        if (childrenWithTagName.size() > 0) {
            a = new Element[childrenWithTagName.size()];
            childrenWithTagName.toArray(a);
        }
        return a;
    }

    public TestReport run(Document doc, String[] ids) throws TestException {
        Element root = doc.getDocumentElement();
        return this.run(root, ids);
    }

    protected TestReport runTest(Test test) throws TestException {
        try {
            return test.run();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            throw new TestException(TEST_SUITE_EXCEPTION, new Object[]{test.getName(), test.getClass().getName(), e.getClass().getName(), e.getMessage(), sw.toString()}, e);
        }
    }

    protected void processReport(TestReport report, TestReportProcessor[] processors) throws TestException {
        int n = processors.length;
        int i = 0;
        try {
            while (i < n) {
                processors[i].processReport(report);
                ++i;
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            throw new TestException(TEST_REPORT_PROCESSING_EXCEPTION, new Object[]{processors[i].getClass().getName(), e.getClass().getName(), e.getMessage(), sw.toString()}, e);
        }
    }

    protected TestReport run(Element testRunElement, String[] ids) throws TestException {
        DefaultTestSuite testRun;
        Test filteredTestRun = testRun = this.buildTestRunTestSuite(testRunElement);
        if (ids != null && ids.length > 0) {
            IdBasedTestFilter filter = new IdBasedTestFilter(ids);
            filteredTestRun = filter.filter(testRun);
            String unusedIds = filter.traceUnusedIds();
            if (unusedIds != null) {
                System.err.println(Messages.formatMessage(MESSAGE_UNMATCHED_TEST_IDS, new Object[]{unusedIds}));
            }
        }
        if (filteredTestRun == null) {
            DefaultTestReport report = new DefaultTestReport(testRun);
            report.setPassed(true);
            return report;
        }
        TestReportProcessor[] processors = this.extractTestReportProcessor(testRunElement);
        TestReport report = this.runTest(testRun);
        if (processors != null) {
            this.processReport(report, processors);
        }
        return report;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println(Messages.formatMessage(USAGE, null));
            System.exit(0);
        }
        String uriStr = args[0];
        String[] ids = new String[args.length - 1];
        System.arraycopy(args, 1, ids, 0, args.length - 1);
        File file = new File(uriStr);
        URL url = null;
        if (file.exists()) {
            try {
                url = file.toURL();
            }
            catch (MalformedURLException e) {
                System.err.println(Messages.formatMessage(COULD_NOT_CONVERT_FILE_NAME_TO_URI, new Object[]{uriStr}));
                System.exit(0);
            }
        } else {
            System.err.println(Messages.formatMessage(NOT_A_FILE_TRY_URI, new Object[]{uriStr}));
            try {
                url = new URL(uriStr);
            }
            catch (MalformedURLException e) {
                System.err.println(Messages.formatMessage(INVALID_URI, new Object[]{uriStr}));
                System.exit(0);
            }
        }
        Document doc = null;
        try {
            System.err.println("Loading document ...");
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = docBuilder.parse(url.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(Messages.formatMessage(INVALID_DOCUMENT, new Object[]{uriStr, e.getClass().getName(), e.getMessage()}));
            System.exit(0);
        }
        try {
            System.err.println("Running test run...");
            XMLTestSuiteRunner r = new XMLTestSuiteRunner();
            r.run(doc, ids);
        }
        catch (TestException e) {
            System.err.println(Messages.formatMessage(ERROR_RUNNING_TEST_SUITE, new Object[]{e.getMessage()}));
            System.exit(0);
        }
        System.exit(1);
    }

    public static class AcceptAllTestsFilter
    implements TestFilter {
        @Override
        public Test filter(Test t) {
            return t;
        }
    }

    public static class IdBasedTestFilter
    implements TestFilter {
        protected String[] ids;
        protected Set unmatchedIds = new HashSet();

        public IdBasedTestFilter(String[] ids) {
            this.ids = ids;
            int i = 0;
            while (i < ids.length) {
                this.unmatchedIds.add(ids[i]);
                ++i;
            }
        }

        public String traceUnusedIds() {
            Object[] ui = this.unmatchedIds.toArray();
            StringBuffer sb = null;
            if (ui != null && ui.length > 0) {
                sb = new StringBuffer();
                sb.append(ui[0].toString());
                int i = 1;
                while (i < ui.length) {
                    sb.append(", ");
                    sb.append(ui[i].toString());
                    ++i;
                }
            }
            return sb != null ? sb.toString() : null;
        }

        public void filterTestSuite(TestSuite ts) {
            Test[] t = ts.getChildrenTests();
            int nTests = t != null ? t.length : 0;
            int i = 0;
            while (i < nTests) {
                if (this.filter(t[i]) == null) {
                    ts.removeTest(t[i]);
                }
                ++i;
            }
        }

        @Override
        public Test filter(Test t) {
            String id = t.getQualifiedId();
            boolean isRequested = this.isRequestedId(id);
            if (t instanceof TestSuite) {
                TestSuite ts = (TestSuite)t;
                this.filterTestSuite(ts);
                if (ts.getChildrenCount() > 0) {
                    return t;
                }
                return null;
            }
            if (isRequested) {
                return t;
            }
            return null;
        }

        protected boolean isRequestedId(String id) {
            int i = 0;
            while (i < this.ids.length) {
                if (this.ids[i].lastIndexOf(id) == 0) {
                    this.unmatchedIds.remove(this.ids[i]);
                    return true;
                }
                if (id.lastIndexOf(this.ids[i]) != -1) {
                    this.unmatchedIds.remove(this.ids[i]);
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

