/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.TestReport;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.XMLReader;

public class TranscoderInputTest
extends AbstractTest {
    @Override
    public TestReport runImpl() throws Exception {
        String TEST_URI = new File("samples/anne.svg").toURL().toString();
        TestTranscoder t = new TestTranscoder();
        TranscoderOutput out = new TranscoderOutput(new StringWriter());
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setValidating(false);
        SAXParser parser = saxFactory.newSAXParser();
        XMLReader xmlReader = parser.getXMLReader();
        TranscoderInput ti = new TranscoderInput(xmlReader);
        ti.setURI(TEST_URI);
        t.transcode(ti, out);
        this.assertTrue(t.passed);
        URL uri = new URL(TEST_URI);
        InputStream is = uri.openStream();
        TranscoderInput ti2 = new TranscoderInput(is);
        ti2.setURI(TEST_URI);
        t = new TestTranscoder();
        t.transcode(ti2, out);
        this.assertTrue(t.passed);
        uri = new URL(TEST_URI);
        is = uri.openStream();
        InputStreamReader r = new InputStreamReader(is);
        ti = new TranscoderInput(r);
        ti.setURI(TEST_URI);
        t = new TestTranscoder();
        t.transcode(ti, out);
        this.assertTrue(t.passed);
        String parser2 = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser2);
        Document doc = f.createDocument(TEST_URI);
        ti = new TranscoderInput(doc);
        ti.setURI(TEST_URI);
        t = new TestTranscoder();
        t.transcode(ti, out);
        this.assertTrue(t.passed);
        parser2 = XMLResourceDescriptor.getXMLParserClassName();
        DOMImplementation impl = GenericDOMImplementation.getDOMImplementation();
        SAXDocumentFactory f2 = new SAXDocumentFactory(impl, parser2);
        Document doc2 = f2.createDocument(TEST_URI);
        TranscoderInput ti3 = new TranscoderInput(doc2);
        ti3.setURI(TEST_URI);
        t = new TestTranscoder();
        t.transcode(ti3, out);
        this.assertTrue(t.passed);
        TranscoderInput ti4 = new TranscoderInput(TEST_URI);
        t = new TestTranscoder();
        t.transcode(ti4, out);
        this.assertTrue(t.passed);
        return this.reportSuccess();
    }

    static class TestTranscoder
    extends XMLAbstractTranscoder {
        boolean passed = false;

        public TestTranscoder() {
            this.addTranscodingHint(KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, "http://www.w3.org/2000/svg");
            this.addTranscodingHint(KEY_DOCUMENT_ELEMENT, "svg");
            this.addTranscodingHint(KEY_DOM_IMPLEMENTATION, SVGDOMImplementation.getDOMImplementation());
        }

        @Override
        protected void transcode(Document document, String uri, TranscoderOutput output) {
            this.passed = document != null;
        }
    }
}

