/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.AbstractImageTranscoderTest;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class AOITest
extends AbstractImageTranscoderTest {
    protected String inputURI;
    protected String refImageURI;
    protected Rectangle2D aoi;
    protected Float imgWidth;
    protected Float imgHeight;

    public AOITest(String inputURI, String refImageURI, Float x, Float y, Float width, Float height) {
        this(inputURI, refImageURI, x, y, width, height, new Float(-1.0f), new Float(-1.0f));
    }

    public AOITest(String inputURI, String refImageURI, Float x, Float y, Float width, Float height, Float imgWidth, Float imgHeight) {
        this.inputURI = inputURI;
        this.refImageURI = refImageURI;
        this.aoi = new Rectangle2D.Float(x.floatValue(), y.floatValue(), width.floatValue(), height.floatValue());
        this.imgWidth = imgWidth;
        this.imgHeight = imgHeight;
    }

    @Override
    protected TranscoderInput createTranscoderInput() {
        return new TranscoderInput(this.resolveURL(this.inputURI).toString());
    }

    @Override
    protected Map createTranscodingHints() {
        HashMap<TranscodingHints.Key, Object> hints = new HashMap<TranscodingHints.Key, Object>(11);
        hints.put(ImageTranscoder.KEY_AOI, this.aoi);
        if (this.imgWidth.floatValue() > 0.0f) {
            hints.put(ImageTranscoder.KEY_WIDTH, this.imgWidth);
        }
        if (this.imgHeight.floatValue() > 0.0f) {
            hints.put(ImageTranscoder.KEY_HEIGHT, this.imgHeight);
        }
        return hints;
    }

    @Override
    protected byte[] getReferenceImageData() {
        return AOITest.createBufferedImageData(this.resolveURL(this.refImageURI));
    }
}

