/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.svg.SVGRenderingAccuracyTest;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;

public abstract class AbstractImageTranscoderTest
extends AbstractTest {
    public static final String ERROR_IMAGE_DIFFER = "AbstractImageTranscoderTest.error.image.differ";
    public static final String DIFFERENCE_IMAGE = "AbstractImageTranscoderTest.error.difference.image";
    public static final String ERROR_TRANSCODING = "AbstractImageTranscoderTest.error.transcoder.exception";
    DefaultTestReport report;
    static String filename;

    protected URL resolveURL(String url) {
        File f = new File(url).getAbsoluteFile();
        if (f.getParentFile().exists()) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException();
            }
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(url);
        }
    }

    @Override
    public TestReport runImpl() throws Exception {
        this.report = new DefaultTestReport(this);
        try {
            DiffImageTranscoder transcoder = new DiffImageTranscoder(this.getReferenceImageData());
            Map hints = this.createTranscodingHints();
            if (hints != null) {
                transcoder.setTranscodingHints(hints);
            }
            TranscoderInput input = this.createTranscoderInput();
            transcoder.transcode(input, null);
        }
        catch (Exception ex) {
            this.report.setErrorCode(ERROR_TRANSCODING);
            this.report.addDescriptionEntry(ERROR_TRANSCODING, AbstractImageTranscoderTest.toString(ex));
            ex.printStackTrace();
            this.report.setPassed(false);
        }
        return this.report;
    }

    protected abstract TranscoderInput createTranscoderInput();

    protected Map createTranscodingHints() {
        return null;
    }

    protected abstract byte[] getReferenceImageData();

    public static String toString(Exception ex) {
        StringWriter trace = new StringWriter();
        ex.printStackTrace(new PrintWriter(trace));
        return trace.toString();
    }

    public static byte[] createBufferedImageData(URL url) {
        try {
            byte[] imgDataTmp;
            int length;
            filename = url.toString();
            InputStream istream = url.openStream();
            byte[] imgData = null;
            byte[] buf = new byte[1024];
            while ((length = istream.read(buf, 0, buf.length)) == buf.length) {
                if (imgData != null) {
                    imgDataTmp = new byte[imgData.length + length];
                    System.arraycopy(imgData, 0, imgDataTmp, 0, imgData.length);
                    System.arraycopy(buf, 0, imgDataTmp, imgData.length, length);
                    imgData = imgDataTmp;
                    continue;
                }
                imgData = new byte[length];
                System.arraycopy(buf, 0, imgData, 0, length);
            }
            if (imgData != null) {
                imgDataTmp = new byte[imgData.length + length];
                System.arraycopy(imgData, 0, imgDataTmp, 0, imgData.length);
                System.arraycopy(buf, 0, imgDataTmp, imgData.length, length);
                imgData = imgDataTmp;
            } else {
                imgData = new byte[length];
                System.arraycopy(buf, 0, imgData, 0, length);
            }
            istream.close();
            return imgData;
        }
        catch (IOException ex) {
            return null;
        }
    }

    protected BufferedImage getImage(InputStream is) throws IOException {
        ImageTagRegistry reg = ImageTagRegistry.getRegistry();
        Filter filt = reg.readStream(is);
        if (filt == null) {
            throw new IOException("Couldn't read Stream");
        }
        RenderedImage red = filt.createDefaultRendering();
        if (red == null) {
            throw new IOException("Couldn't render Stream");
        }
        BufferedImage img = new BufferedImage(red.getWidth(), red.getHeight(), 2);
        red.copyData(img.getRaster());
        return img;
    }

    protected class DiffImageTranscoder
    extends ImageTranscoder {
        protected boolean state;
        protected byte[] refImgData;

        public DiffImageTranscoder(byte[] refImgData) {
            this.refImgData = refImgData;
        }

        @Override
        public BufferedImage createImage(int w, int h) {
            return new BufferedImage(w, h, 2);
        }

        @Override
        public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
            this.compareImage(img);
        }

        protected void writeCandidateReference(byte[] imgData) {
            try {
                String s = new File(filename).getName();
                s = "test-references/org/apache/batik/transcoder/image/candidate-reference/" + s;
                System.out.println(s);
                FileOutputStream ostream = new FileOutputStream(s);
                ostream.write(imgData, 0, imgData.length);
                ostream.flush();
                ostream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void writeCandidateVariation(byte[] imgData, byte[] refData) {
            this.writeCandidateReference(imgData);
            try {
                BufferedImage ref = AbstractImageTranscoderTest.this.getImage(new ByteArrayInputStream(refData));
                BufferedImage img = AbstractImageTranscoderTest.this.getImage(new ByteArrayInputStream(imgData));
                BufferedImage diff = SVGRenderingAccuracyTest.buildDiffImage(ref, img);
                String s = new File(filename).getName();
                s = "test-references/org/apache/batik/transcoder/image/candidate-variation/" + s;
                ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
                try (FileOutputStream out = new FileOutputStream(s);){
                    writer.writeImage(diff, out);
                }
                AbstractImageTranscoderTest.this.report.addDescriptionEntry(AbstractImageTranscoderTest.DIFFERENCE_IMAGE, new File(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void compareImage(BufferedImage img) throws TranscoderException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput(out);
            PNGTranscoder t = new PNGTranscoder();
            t.writeImage(img, output);
            byte[] imgData = out.toByteArray();
            if (this.refImgData == null) {
                AbstractImageTranscoderTest.this.report.setErrorCode(AbstractImageTranscoderTest.ERROR_IMAGE_DIFFER);
                AbstractImageTranscoderTest.this.report.addDescriptionEntry(AbstractImageTranscoderTest.ERROR_IMAGE_DIFFER, "");
                AbstractImageTranscoderTest.this.report.setPassed(false);
                this.writeCandidateReference(imgData);
                this.state = false;
                return;
            }
            if (this.refImgData.length != imgData.length) {
                AbstractImageTranscoderTest.this.report.setErrorCode(AbstractImageTranscoderTest.ERROR_IMAGE_DIFFER);
                AbstractImageTranscoderTest.this.report.addDescriptionEntry(AbstractImageTranscoderTest.ERROR_IMAGE_DIFFER, "");
                AbstractImageTranscoderTest.this.report.setPassed(false);
                this.writeCandidateVariation(imgData, this.refImgData);
                return;
            }
            int i = 0;
            while (i < this.refImgData.length) {
                if (this.refImgData[i] != imgData[i]) {
                    AbstractImageTranscoderTest.this.report.setErrorCode(AbstractImageTranscoderTest.ERROR_IMAGE_DIFFER);
                    AbstractImageTranscoderTest.this.report.addDescriptionEntry(AbstractImageTranscoderTest.ERROR_IMAGE_DIFFER, "");
                    AbstractImageTranscoderTest.this.report.setPassed(false);
                    this.writeCandidateVariation(imgData, this.refImgData);
                    return;
                }
                ++i;
            }
            this.state = true;
        }

        public boolean isIdentical() {
            return this.state;
        }
    }
}

